<?php
/**
 * Gutenberg helpers
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Check if Gutenberg can edit this post type
 *
 * This is a wrapper for the gutenberg_can_edit_post_type() core function.
 * So we can use it when Gutenberg is not active.
 *
 */
function uncode_gutenberg_can_edit_post_type( $post_type ) {
	if ( ! function_exists( 'gutenberg_can_edit_post_type' ) ) {
		return false;
	}

	return gutenberg_can_edit_post_type( $post_type );
}

/**
 * Check if Gutenberg is the active editor
 */
function uncode_is_gutenberg_current_editor( $post_type ) {
	// Gutenberg is not active
	if ( ! uncode_is_gutenberg_active() ) {
		return false;
	}

	// Gutenberg can't edit this post type
	if ( ! uncode_gutenberg_can_edit_post_type( $post_type ) ) {
		return false;
	}

	if ( isset( $_REQUEST ) && isset( $_REQUEST[ 'classic-editor' ] ) ) {
		return false;
	}

	return true;
}

/**
 * Get skin classes for content block
 */
function uncode_gutenberg_content_block_skin_classes() {
	global $metabox_data;

	if (isset($metabox_data['_uncode_specific_style'][0]) && $metabox_data['_uncode_specific_style'][0] !== '') {
		$style = $metabox_data['_uncode_specific_style'][0];
		if (isset($metabox_data['_uncode_specific_bg_color'][0]) && $metabox_data['_uncode_specific_bg_color'][0] !== '') {
			$bg_color = $metabox_data['_uncode_specific_bg_color'][0];
		}
	} else {
		$style = ot_get_option('_uncode_general_style');
		if (isset($metabox_data['_uncode_specific_bg_color'][0]) && $metabox_data['_uncode_specific_bg_color'][0] !== '') {
			$bg_color = $metabox_data['_uncode_specific_bg_color'][0];
		} else $bg_color = ot_get_option('_uncode_general_bg_color');
	}

	$bg_color = ($bg_color == '') ? ' style-'.$style.'-bg' : ' style-'.$bg_color.'-bg';
	$skin     = $style ? ' style-' . $style : ' style-light';
	$class    = $bg_color . $skin;

	return $class;
}




