(function ($) {
	"use strict";
	$(document).ready(function($){
		if( $('#dsk_layouttype').length > 0 ){
			var selector = document.getElementById('dsk_layouttype');
			var imgLayoutHTML = '';
		    for(var i = 1; i < selector.options.length; i++){
		    	if( selector.options[i].value ){
		    		imgLayoutHTML = imgLayoutHTML + '<span class="img-layout '+selector.options[i].value+'" data-value="'+selector.options[i].value+'" title="'+selector.options[i].text+'"></span>';
		    	}
		    }
		    $('#dsk_layouttype').parent().append(imgLayoutHTML); $('#dsk_layouttype').css('display', 'none');
		}
		$('.img-layout').each(function(){
			// Add active class
			if($(this).attr('data-value') == $('#dsk_layouttype').attr('data-selected')){
				$(this).addClass('active');
			}
			showHideDependLayout($('#dsk_layouttype').attr('data-selected'));
			// Click img select
			$(this).on('click', function() {
				// Change active class
				var $val = $(this).attr('data-value'); $('.img-layout').removeClass('active'); $(this).addClass('active');
				// Set value for select
				$('#wpbody #dsk_layouttype').val($val);
				if( typeof $('#wpbody #dsk_layouttype').attr('data-selected') != 'undefined' ){
					$('#wpbody #dsk_layouttype').attr('data-selected', $val);
				}
				// Hide or show field codition
				showHideDependLayout($val);
			});
		});
		//
		if ( $('#page_template').val() == 'fullwidth.php' || $('#page_template').val() == 'sidepage.php' ){
			$('#sns_layout').fadeOut(500);
		}else{
			$('#sns_layout').fadeIn(500);
		}
		
		$('#page_template').change(function(){
			if( $(this).val() == 'fullwidth.php' || $('#page_template').val() == 'sidepage.php' ){
				$('#sns_layout').fadeOut(500);
			}else{
				$('#sns_layout').fadeIn(500);
			}
		})
		function showHideDependLayout($val){
			if( $val == 'm' ){
				$('#wpbody #dsk_leftsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				$('#wpbody #dsk_rightsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
			}else if( $val == 'l-m' ){
				$('#wpbody #dsk_leftsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
				$('#wpbody #dsk_rightsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
			}else if( $val == 'm-r' ){
				$('#wpbody #dsk_rightsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
				$('#wpbody #dsk_leftsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
			}
		}
		// Enable layout config
		$('#wpbody input[name="dsk_enablelayoutconfig"]').each(function(){
			if( $(this).attr('checked') == 'checked' ) enableLayoutConfig( $(this).val() );
			$(this).change(function(){
				enableLayoutConfig( $(this).val() );console.log($(this).val());
			})
		})
		function enableLayoutConfig($val){
			if( $val == '1' ){
				$('#wpbody #dsk_layouttype').parents('.rwmb-layouttype-wrapper').stop(true,true).fadeIn(500);
				showHideDependLayout($('#dsk_layouttype').val());
			}else{
				$('#wpbody #dsk_leftsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				$('#wpbody #dsk_rightsidebar').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				$('#wpbody #dsk_layouttype').parents('.rwmb-layouttype-wrapper').stop(true,true).fadeOut(500);
			}
		}
		// Header style
		$('#wpbody select[name=dsk_header_style]').each(function(){
			if ( $(this).val() == 'style1' ) {
				$('#wpbody select#dsk_mcat_style').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
			}else {
				$('#wpbody select#dsk_mcat_style').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
			}
			$(this).change(function(){
				if ( $(this).val() == 'style1' ) {
					$('#wpbody select#dsk_mcat_style').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody select#dsk_mcat_style').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				}
			})
		});
		// Breadcumd
		$('#wpbody select[name=dsk_showbreadcrump]').each(function(){
			if ( $(this).val() == '2' ) {
				$('#wpbody input[name=dsk_breadcrumbbg]').parents('.rwmb-image_advanced-wrapper').stop(true,true).fadeIn(500);
			}else {
				$('#wpbody input[name=dsk_breadcrumbbg]').parents('.rwmb-image_advanced-wrapper').stop(true,true).fadeOut(500);
			}
			$(this).change(function(){
				if ( $(this).val() == '2' ) {
					$('#wpbody input[name=dsk_breadcrumbbg]').parents('.rwmb-image_advanced-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody input[name=dsk_breadcrumbbg]').parents('.rwmb-image_advanced-wrapper').stop(true,true).fadeOut(500);
				}
			})
		});
		// Revolution
		$('#wpbody input[name=dsk_useslideshow]').each(function(){
			if( $(this).attr('checked') == 'checked' ){
				if ( $(this).val() == '1' ) {
					$('#wpbody select#dsk_revolutionslider').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody select#dsk_revolutionslider').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				}
			}
			$(this).change(function(){
				if ( $(this).val() == '1' ) {
					$('#wpbody select#dsk_revolutionslider').parents('.rwmb-select-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody select#dsk_revolutionslider').parents('.rwmb-select-wrapper').stop(true,true).fadeOut(500);
				}
			})
		});
		// Theme color
		$('#wpbody input[name=dsk_page_themecolor]').each(function(){
			if( $(this).attr('checked') == 'checked' ){
				if ( $(this).val() == '1' ) {
					$('#wpbody input#dsk_theme_color').parents('.rwmb-color-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody input#dsk_theme_color').parents('.rwmb-color-wrapper').stop(true,true).fadeOut(500);
				}
			}
			$(this).change(function(){
				if ( $(this).val() == '1' ) {
					$('#wpbody input#dsk_theme_color').parents('.rwmb-color-wrapper').stop(true,true).fadeIn(500);
				}else {
					$('#wpbody input#dsk_theme_color').parents('.rwmb-color-wrapper').stop(true,true).fadeOut(500);
				}
			})
		});
		// Post format
		if ( wp &&
			wp.data && 
			wp.data.select( 'core/editor' )!= null ) {
			wp.data.subscribe( function () {
				var newFormat = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'format' );
				if( newFormat !== '' ) {
					$('#sns-post-gallery, #sns-post-video, #sns-post-audio, #sns-post-quote, #sns-post-link').each(function(){
						$(this).hide();
					});
					if ( newFormat !== 'standard' ) $('#sns-post-' + newFormat).show();
				}
				return;
			});
		}
	});
})(jQuery);