<?php
// DSK Product Ajax Tab
add_shortcode('dsk_products_ajaxtab', 'dsk_products_ajaxtab_template');
add_action('vc_after_init', 'dsk_products_ajaxtab_settings');
function dsk_products_ajaxtab_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_woo_template('dsk_products_ajaxtab'))
        include $template;
    return ob_get_clean();
}
function dsk_products_ajaxtab_settings() {
	$extra_class = dsk_extra_class();
	$woocat_value = dsk_woo_cat();
	$categories = dsk_woo_cat(0);
	$woocat_value_drop =  array();
	dsk_woo_cat_level(0, 0, $categories, 0, $woocat_value_drop);

	vc_map( array(
		"name" => esc_html__("Products Ajax Tab",'dsk-shortcodes'),
		"base" => "dsk_products_ajaxtab",
		"icon" => "icon_dsk_products_ajaxtab",
		"class" => "dsk_products_ajaxtab",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "Products Ajax Tab",'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title",'dsk-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("The title", 'dsk-shortcodes'),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Tab by?",'dsk-shortcodes'),
				"param_name" => "tab_type",
				"admin_label" => true,
				"value" => array(
					esc_html__("Order by",'dsk-shortcodes') => '1',
					esc_html__("Category",'dsk-shortcodes') => '2',
				),
			),
			array(
				"type" => "checkbox",
				"heading" => esc_html__("Select tab to display",'dsk-shortcodes'),
				"param_name" => "orderby_tab",
				"value" => array(
					esc_html__('Latest', 'dsk-shortcodes') => "recent",
					esc_html__('Best Seller', 'dsk-shortcodes') => "best_selling",
					esc_html__('Top Rated', 'dsk-shortcodes') => "top_rate",
					esc_html__('Special', 'dsk-shortcodes') => "on_sale",
					esc_html__('Featured', 'dsk-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'dsk-shortcodes') => "recent_review",
				),
				"description" => "",
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '1',
				),
			),
			array(
				"type" => "checkbox",
				"heading" => esc_html__("Select tab to display",'dsk-shortcodes'),
				"param_name" => "cat_tab",
				"value" => $woocat_value,
				"description" => "",
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show tab All Category?",'dsk-shortcodes'),
				"param_name" => "show_tab_all",
				"value" => array(
					esc_html__('Yes', 'dsk-shortcodes') => "1",
					esc_html__('No', 'dsk-shortcodes') => "2",
				),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
		        "type" => "attach_images",
		        "heading" => esc_html__("Background image(or banner) for each tab content", 'dsk-shortcodes'),
		        "param_name" => "image_tabcontent",
		        'description' => esc_html__( 'Drag and drop image to sort oder. The oder of image is the same with the oder of tab above', 'dsk-shortcodes' ),
		        'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('3', '4'),
				),
		    ),
			array(
				"type" => "checkbox",
				"value" => $woocat_value,
				"heading" => esc_html__("Choice categories",'dsk-shortcodes'),
				"param_name" => "cat",
				"description" => esc_html__('If you dont choice, That mean it will query all category','dsk-shortcodes'),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Order by",'snsmarket-shortcodes'),
				"param_name" => "orderby",
				"value" => array(
					esc_html__('Latest', 'dsk-shortcodes') => "recent",
					esc_html__('Best Seller', 'dsk-shortcodes') => "best_selling",
					esc_html__('Top Rated', 'dsk-shortcodes') => "top_rate",
					esc_html__('Special', 'dsk-shortcodes') => "on_sale",
					esc_html__('Featured', 'dsk-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'dsk-shortcodes') => "recent_review",
				),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Product style",'dsk-shortcodes'),
				"param_name" => "gridstyle",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1",'dsk-shortcodes') => '',
					esc_html__("Style 2",'dsk-shortcodes') => '2',
					esc_html__("Style 3",'dsk-shortcodes') => '3',
					//esc_html__("Style 4",'dsk-shortcodes') => '4',
				),
			),
			array(
				"type" => "dropdown",
				'multiple' => true,
				"class" => "",
				"value" => array(
					esc_html__('No Effect', 'dsk-shortcodes') => "simple-effect",
					esc_html__('fadeIn', 'dsk-shortcodes') => "fadeIn",
					esc_html__('fadeInUp', 'dsk-shortcodes') => "fadeInUp",
					esc_html__('fadeInDown', 'dsk-shortcodes') => "fadeInDown",
					esc_html__('fadeInRight', 'dsk-shortcodes') => "fadeInRight",
					esc_html__('fadeInLeft', 'dsk-shortcodes') => "fadeInLeft",
					esc_html__('bounceIn', 'dsk-shortcodes') => "bounceIn",
					esc_html__('bounceInUp', 'dsk-shortcodes') => "bounceInUp",
					esc_html__('bounceInDown', 'dsk-shortcodes') => "bounceInDown",
					esc_html__('bounceInLeft', 'dsk-shortcodes') => "bounceInLeft",
					esc_html__('bounceInRight', 'dsk-shortcodes') => "bounceInRight",
					esc_html__('zoomIn', 'dsk-shortcodes') => "zoomIn",
					esc_html__('zoomInUp', 'dsk-shortcodes') => "zoomInUp",
					esc_html__('zoomInDown', 'dsk-shortcodes') => "zoomInDown",
					esc_html__('zoomInLeft', 'dsk-shortcodes') => "zoomInLeft",
					esc_html__('zoomInRight', 'dsk-shortcodes') => "zoomInRight",

				),
				"heading" => esc_html__("Effect to show product in tab",'dsk-shortcodes'),
				"param_name" => "effect",
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Template for each tab content",'dsk-shortcodes'),
				"param_name" => "content_tab_template",
				"admin_label" => true,
				"value" => array(
					esc_html__("Carousel",'dsk-shortcodes') => '1',
					esc_html__("Grid and Load more button",'dsk-shortcodes') => '2',
					esc_html__("Carousel - Special template 1",'dsk-shortcodes') => '3',
					esc_html__("Carousel - Special template 2",'dsk-shortcodes') => '4',
					esc_html__("Carousel - Special template 3",'dsk-shortcodes') => '5',
				),
			),
			
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Navigation",'dsk-shortcodes'),
				"param_name" => "use_nav",
				"value" => array(
					esc_html__("Yes",'dsk-shortcodes') => '1',
					esc_html__("No",'dsk-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1', '3', '4', '5'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Navigation position",'dsk-shortcodes'),
				"param_name" => "nav_pos",
				"value" => array(
					esc_html__("In middle box - Default",'dsk-shortcodes') => 'middlebox',
					esc_html__("In top right",'dsk-shortcodes') => 'topright',
					esc_html__("In top center",'dsk-shortcodes') => 'topcenter',
					
				),
				'dependency' => array(
					'element' => 'use_nav',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Paging",'dsk-shortcodes'),
				"param_name" => "use_paging",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '2',
					esc_html__("Yes",'dsk-shortcodes') => '1',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1', '3', '4', '5'),
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product limit for each tab",'dsk-shortcodes'),
				"param_name" => "number_limit",
				"admin_label" => true,
				"value" =>  esc_html__("16", 'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1', '3', '4', '5'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number product will show more with each click load more button",'dsk-shortcodes'),
				"param_name" => "num_showmore",
				"value" => "6",
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => '2',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'dsk-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Desktop",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_desktop",
				"admin_label" => true,
				"value" =>  esc_html__("5", 'dsk-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Tablet Landscape",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_tablet",
				"admin_label" => true,
				"value" =>  esc_html__("3", 'dsk-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Tablet Portrait",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'dsk-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Mobile Landscape",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_mobilel",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'dsk-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Nobile Portrait",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_mobilep",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'dsk-shortcodes'),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}