<?php
// SNS Product
add_shortcode('sns_products', 'dsk_products_template');
add_action('vc_after_init', 'dsk_products_settings');
function dsk_products_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_woo_template('sns_products'))
        include $template;
    return ob_get_clean();
}
function dsk_products_settings() {
	$extra_class = dsk_extra_class();
	$woocat_value = dsk_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Products",'dsk-shortcodes'),
		"base" => "sns_products",
		"icon" => "sns_icon_products",
		"class" => "sns_products",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "WooCommerce products",'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Text before Title",'dsk-shortcodes'),
				"param_name" => "before_title",
				"admin_label" => true,
				"value" =>  "",
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'dsk-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("New Products", 'dsk-shortcodes'),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Text after Title",'dsk-shortcodes'),
				"param_name" => "after_title",
				"admin_label" => true,
				"value" =>  "",
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"value" => $woocat_value,
				"heading" => esc_html__("Select Category",'dsk-shortcodes'),
				"param_name" => "lit_cat",
				"description" => esc_html__("If you don't select any category, It mean is selected all category", 'dsk-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Order By",'dsk-shortcodes'),
				"param_name" => "orderby",
				"value" => array(
					esc_html__('Latest products', 'dsk-shortcodes') => "recent",
					esc_html__('Best seller products', 'dsk-shortcodes') => "best_selling",
					esc_html__('Top rated products', 'dsk-shortcodes') => "top_rate",
					esc_html__('On sale products', 'dsk-shortcodes') => "on_sale",
					esc_html__('Hot deal', 'dsk-shortcodes') => "hot_deal",
					esc_html__('Featured products', 'dsk-shortcodes') => "featured_product",
					esc_html__('Recent review', 'dsk-shortcodes') => "recent_review",
				),
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Mode View",'dsk-shortcodes'),
				"param_name" => "modeview",
				"admin_label" => true,
				"value" => array(
					esc_html__("Gird",'dsk-shortcodes') => '1',
					esc_html__("List",'dsk-shortcodes') => '2',
				),
				"description" => esc_html__("Mode View", 'dsk-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Grid style",'dsk-shortcodes'),
				"param_name" => "gridstyle",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1",'dsk-shortcodes') => '',
					esc_html__("Style 2",'dsk-shortcodes') => '2',
					esc_html__("Style 3",'dsk-shortcodes') => '3',
					esc_html__("Style 4",'dsk-shortcodes') => '4',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Thumbnail type",'dsk-shortcodes'),
				"param_name" => "thumb_type",
				"value" => array(
					esc_html__("Shop Thumbnail",'dsk-shortcodes') => '',
					esc_html__("DSK 80x80 Thumbnail",'dsk-shortcodes') => '8080',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Navigation",'dsk-shortcodes'),
				"param_name" => "use_nav",
				"value" => array(
					esc_html__("Yes",'dsk-shortcodes') => '1',
					esc_html__("No",'dsk-shortcodes') => '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Navigation position",'dsk-shortcodes'),
				"param_name" => "nav_pos",
				"value" => array(
					esc_html__("In middle box - Default",'dsk-shortcodes') => 'middlebox',
					esc_html__("In top right",'dsk-shortcodes') => 'topright',
					esc_html__("In top center",'dsk-shortcodes') => 'topcenter',
					
				),
				'dependency' => array(
					'element' => 'use_nav',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Paging",'dsk-shortcodes'),
				"param_name" => "use_paging",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '2',
					esc_html__("Yes",'dsk-shortcodes') => '1',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Product number limit",'dsk-shortcodes'),
				"param_name" => "number_limit",
				"value" => "10",
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'dsk-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_desktop",
				"value" => "5"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_tablet",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_tabletp",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_mobilel",
				"value" => "2"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
				"param_name" => "number_mobilep",
				"value" => "1"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}