<?php
// SNS Product
add_shortcode('sns_special_deal', 'dsk_special_deal_template');
add_action('vc_after_init', 'dsk_special_deal_settings');
function dsk_special_deal_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_woo_template('sns_special_deal'))
        include $template;
    return ob_get_clean();
}
function dsk_special_deal_settings() {
	$extra_class = dsk_extra_class();
	$woocat_value = dsk_woo_cat();
	// Autocomplete product
    if ( class_exists('Vc_Vendor_Woocommerce') ){
        $dsk_vcwoo = 'Vc_Vendor_Woocommerce';
        add_filter( 'vc_autocomplete_sns_special_deal_ids_callback', array(&$dsk_vcwoo, 'productIdAutocompleteSuggester',), 10, 1 ); // Get suggestion(find). Must return an array
        add_filter( 'vc_autocomplete_sns_special_deal_ids_render', array(&$dsk_vcwoo, 'productIdAutocompleteRender',), 10, 1 ); // Render exact product. Must return an array (label,value)
    }
	vc_map( array(
		"name" => esc_html__("SNS Special Offer",'dsk-shortcodes'),
		"base" => "sns_special_deal",
		"icon" => "sns_icon_special_deal",
		"class" => "sns_special_deal",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "Show special deals products",'dsk-shortcodes' ),
		"params" => array(
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select deal products', 'dsk-shortcodes' ),
				'param_name' => 'ids',
				'settings' => array(
					'multiple' => true,
					'sortable' => true,
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend
				),
				'save_always' => true,
				'description' => __( 'You can typing id or product name to input form. And should select products are On sale and have "Sale price dates to"', 'dsk-shortcodes' ),
			),
			array(
		        "type" => "attach_images",
		        "heading" => esc_html__("Image for products deals", 'dsk-shortcodes'),
		        "param_name" => "img_prd",
		        'description' => esc_html__( 'Drag and drop image to sort oder. The oder of image is the same with the oder of special deals products above', 'dsk-shortcodes' ),
		    ),
		    array(
		        "type" => "attach_image",
		        "heading" => esc_html__("Background image for deal box", 'dsk-shortcodes'),
		        "param_name" => "bg",
		    ),
		    array(
		        "type" => "attach_image",
		        "heading" => esc_html__("Want to use Deal Badge?", 'dsk-shortcodes'),
		        "param_name" => "badge",
		    ),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}