<?php
// SNS Blog Page
add_shortcode('sns_blog_page', 'dsk_blog_page_template');
add_action('vc_after_init', 'dsk_blog_page_settings');
function dsk_blog_page_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_blog_page'))
        include $template;
    return ob_get_clean();
}
function dsk_blog_page_settings() {
	$extra_class = dsk_extra_class();
	$css_animation = dsk_css_animation();
	$cat_value = dsk_cat();
	vc_map( array(
		"name" => esc_html__("SNS Blog Page",'dsk-shortcodes'),
		"base" => "sns_blog_page",
		"icon" => "sns_icon_blogpage",
		"class" => "sns_blogpage",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "To create blog page with some style", 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "checkbox",
				"value" => $cat_value,
				"class" => "",
				"heading" => esc_html__("Categories",'dsk-shortcodes'),
				"description" => esc_html__( "If you dont sellect category, the default is sellected all category", 'dsk-shortcodes' ),
				"param_name" => "category"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Blog Style",'dsk-shortcodes'),
				"param_name" => "blog_type",
				"value" => array(
					esc_html__("Blog Default", "dsk-shortcodes") 	=> "layout1",
					esc_html__("Blog List", "dsk-shortcodes") 		=> "layout2",
					//esc_html__("Blog Masonry", "dsk-shortcodes")	=>  "masonry",
				),
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Page Navigation",'dsk-shortcodes'),
				"param_name" => "pagination",
				"value" => array(
					esc_html__("Default",'dsk-shortcodes') => 'def',
					esc_html__("Ajax click load more",'dsk-shortcodes') =>  'ajax',
					esc_html__("Ajax auto load more",'dsk-shortcodes') =>  'ajax2'
				),
				'description' => esc_html__('Choose Type of navigation.','dsk-shortcodes')
			),
            array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number post with each load more",'dsk-shortcodes'),
				"param_name" => "masonry_numload",
				"value" => "3",
				'dependency' => array(
					'element' => 'pagination',
					'value' => array('ajax', 'ajax2')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Post per pages",'dsk-shortcodes'),
				"param_name" => "posts_per_page",
				"value" => "6"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Excerpt Length",'dsk-shortcodes'),
				"param_name" => "excerpt_length",
				"value" => "75"
			),
			
			
			$css_animation,
			$extra_class,
		)
	) );
}