<?php
// SNS Carousel
add_shortcode('sns_carousel', 'dsk_carousel_template');
add_action('vc_after_init', 'dsk_carousel_settings');
function dsk_carousel_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_carousel'))
        include $template;
    return ob_get_clean();
}
function dsk_carousel_settings() {
	//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    	class WPBakeryShortCode_SNS_Carousel extends WPBakeryShortCodesContainer {}
    }
	$extra_class = dsk_extra_class();
	$css_animation = dsk_css_animation();
	if ( function_exists('vc_map') ) vc_map( array(
		"name" => esc_html__("SNS Carousel",'dsk-shortcodes'),
		"base" => "sns_carousel",
		"class" => "sns_carousel",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "Carousel for other shortcodes",'dsk-shortcodes' ),

	    "as_parent" => array('except' => 'sns_carousel'),
	    "content_element" => true,
	    "show_settings_on_create" => true,
	    "is_container" => true,
	    "js_view" => 'VcColumnView',

	    "params" => array(
	        // add params same as with any other content element
	        array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'dsk-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" => "",
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Slider Type",'dsk-shortcodes'),
				"param_name" => "slider_type",
				"value" => array(
					esc_html__("Horizontal",'dsk-shortcodes') => 'h',
					esc_html__("Vertical",'dsk-shortcodes') =>  'v'
				)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show Navigation",'dsk-shortcodes'),
				"param_name" => "show_nav",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '0',
					esc_html__("Yes",'dsk-shortcodes') =>  '1'
				)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show Paging",'dsk-shortcodes'),
				"param_name" => "show_paging",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '0',
					esc_html__("Yes",'dsk-shortcodes') =>  '1'
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Paging with Image",'dsk-shortcodes'),
				"param_name" => "show_dotimg",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '0',
					esc_html__("Yes",'dsk-shortcodes') =>  '1'
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number row on column",'dsk-shortcodes'),
				"param_name" => "row",
				"value" => esc_html__("1",'dsk-shortcodes'),
			),
	        array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Desktop",'dsk-shortcodes'),
				"param_name" => "n_desktop",
				"value" => esc_html__("1",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Tablet Landscape",'dsk-shortcodes'),
				"param_name" => "n_tablet",
				"value" => esc_html__("1",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number items on Tablet Portrait",'dsk-shortcodes'),
				"param_name" => "n_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Mobile Landscape",'dsk-shortcodes'),
				"param_name" => "n_mobile_l",
				"value" => esc_html__("1",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Mobile Portrait",'dsk-shortcodes'),
				"param_name" => "n_mobile_p",
				"value" => esc_html__("1",'dsk-shortcodes'),
				"group" => __( 'Column settings', 'dsk-shortcodes' ),
			),
			$css_animation,
			$extra_class,
	    ),
	) );
}
