<?php
// SNS Info Box
add_shortcode('sns_info_box', 'dsk_info_box_template');
add_action('vc_after_init', 'dsk_info_box_settings');
function dsk_info_box_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_info_box'))
        include $template;
    return ob_get_clean();
}
function dsk_info_box_settings() {
	$extra_class = dsk_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Box", 'dsk-shortcodes'),
		"base" => "sns_info_box",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Box contain: icon, title, description', 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Style 1', 'dsk-shortcodes' ) => '1',
					esc_html__( 'Style 2', 'dsk-shortcodes' ) => '2',
					esc_html__( 'Style 3', 'dsk-shortcodes' ) => '3',
				),
				"heading" => esc_html__("Box style", 'dsk-shortcodes'),
				"param_name" => "box_style"
		    ),
		    array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Have border', 'dsk-shortcodes' ) => '1',
					esc_html__( 'Just border left', 'dsk-shortcodes' ) => '2',
					esc_html__( 'No border', 'dsk-shortcodes' ) => '3',
				),
				"heading" => esc_html__("Want to use border?", 'dsk-shortcodes'),
				"param_name" => "want_border"
		    ),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("Padding for box", 'dsk-shortcodes'),
				"param_name" => "box_padding" ,
				"value" => esc_html__("20px",'dsk-shortcodes'),
				"description" => esc_html__("It's padding for box, example: 20px or 20px 10px 20px 10px", 'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'want_border',
					'value' => '1',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'dsk-shortcodes' ),
				'value' => array(
					esc_html__( 'Media', 'dsk-shortcodes' ) => 'media',
					esc_html__( 'Font Awesome', 'dsk-shortcodes' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'dsk-shortcodes' ) => 'openiconic',
					esc_html__( 'Typicons', 'dsk-shortcodes' ) => 'typicons',
					esc_html__( 'Entypo', 'dsk-shortcodes' ) => 'entypo',
					esc_html__( 'Linecons', 'dsk-shortcodes' ) => 'linecons',
				),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'dsk-shortcodes' ),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image", 'dsk-shortcodes'),
		      "param_name" => "icon_image",
		      'dependency' => array(
					'element' => 'icon_type',
					'value' => 'media',
				),
		    ),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'dsk-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_openiconic',
				'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'openiconic',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'description' => esc_html__( 'Select icon from library.', 'dsk-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_typicons',
				'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'typicons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'dsk-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_entypo',
				'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'entypo',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_linecons',
				'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'linecons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'description' => esc_html__( 'Select icon from library.', 'dsk-shortcodes' ),
			),
			array(
				"type" => "colorpicker",
				"value" => "",
				"heading" => esc_html__("Color for icon", 'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons','fontawesome','entypo','typicons','openiconic'),
				),
				"param_name" => "icon_color"
		    ),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for icon", 'dsk-shortcodes'),
				"param_name" => "icon_font_size" ,
				"value" => esc_html__("22px",'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons','fontawesome','entypo','typicons','openiconic'),
				),
				"description" => esc_html__("It's font-size for icon you sellected, example: 24px", 'dsk-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Custom Link", 'dsk-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'dsk-shortcodes'),
				"value" => esc_html__("http://", 'dsk-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title", 'dsk-shortcodes'),
				"param_name" => "title",
				"value" => esc_html__("Your Title Here ...",'dsk-shortcodes'),
				"admin_label" => true 
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Margin top for Title", 'dsk-shortcodes'),
				"param_name" => "title_margin_top" ,
				"value" => "",
				"description" => esc_html__("It's margin-top for title, example: 5px", 'dsk-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for Title", 'dsk-shortcodes'),
				"param_name" => "title_font_size" ,
				"value" => esc_html__("16px",'dsk-shortcodes'),
				"description" => esc_html__("It's font-size for title, example: 18px", 'dsk-shortcodes')
			),
			array(
				"type" => "colorpicker",
				"value" => "",
				"heading" => esc_html__("Color for Title", 'dsk-shortcodes'),
				"param_name" => "title_color"

		    ),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Description", 'dsk-shortcodes'),
				"param_name" => "desc"
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}