<?php
// SNS Info Box
add_shortcode('sns_info_inline', 'dsk_info_inline_template');
add_action('vc_after_init', 'dsk_info_inline_settings');
function dsk_info_inline_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_info_inline'))
        include $template;
    return ob_get_clean();
}
function dsk_info_inline_settings() {
	$extra_class = dsk_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Inline", 'dsk-shortcodes'),
		"base" => "sns_info_inline",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Contain: icon, title, link, ... and display inline', 'dsk-shortcodes' ),
		"params" => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'dsk-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'dsk-shortcodes' ) => '',
					esc_html__( 'Social', 'dsk-shortcodes' ) => 'social',
					esc_html__( 'Social Rounded', 'dsk-shortcodes' ) => 'social_rounded',
				),
				'param_name' => 'style',
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use icon?', 'dsk-shortcodes' ),
				'param_name' => 'use_icon',
				'description' => __( 'Use icon in content', 'dsk-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'dsk-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'use_icon',
					'value' => 'true',
				),
				'description' => esc_html__( 'Select icon from library.', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for Icon", 'dsk-shortcodes'),
				"param_name" => "icon_fontsize",
				"value" => esc_html__("18px",'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'use_icon',
					'value' => 'true',
				),
				'description' => __( 'Example: 18px', 'dsk-shortcodes' ),
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use label?', 'dsk-shortcodes' ),
				'param_name' => 'use_label',
				'description' => __( 'Use label in content', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Label", 'dsk-shortcodes'),
				"param_name" => "label",
				"value" => esc_html__("Your label here ...",'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'use_label',
					'value' => 'true',
				),
				"admin_label" => true 
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use link?', 'dsk-shortcodes' ),
				'param_name' => 'use_link',
				'description' => __( 'Use link in content', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Link", 'dsk-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'dsk-shortcodes'),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				"value" => esc_html__("http://", 'dsk-shortcodes')
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link type', 'dsk-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'dsk-shortcodes' ) => '0',
					esc_html__( 'Use mailto:', 'dsk-shortcodes' ) => '1',
					esc_html__( 'Use tel:', 'dsk-shortcodes' ) => '2',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'href_type',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link target', 'dsk-shortcodes' ),
				'value' => array(
					esc_html__( 'Same window', 'dsk-shortcodes' ) => '_self',
					esc_html__( 'New window', 'dsk-shortcodes' ) => '_blank',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'target',
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}