<?php
// SNS List Post
add_shortcode('sns_list_posts', 'dsk_list_posts_template');
add_action('vc_after_init', 'dsk_list_posts_settings');
function dsk_list_posts_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_list_posts'))
        include $template;
    return ob_get_clean();
}
function dsk_list_posts_settings() {
	$extra_class = dsk_extra_class();
		vc_map( array(
		"name" => esc_html__("SNS List Post",'dsk-shortcodes'),
		"base" => "sns_list_posts",
		"icon" => "sns_icon_listposts",
		"class" => "sns_listposts",
		"category" => esc_html__("DSK",'dsk-shortcodes'),
		"description" => esc_html__( "Show List Posts", 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'dsk-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("Latest News",'dsk-shortcodes'),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show date?",'dsk-shortcodes'),
				"param_name" => "show_date",
				"class" => "2",
				"value" => array(
					esc_html__("Yes",'dsk-shortcodes') => '1',
					esc_html__("No",'dsk-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show author?",'dsk-shortcodes'),
				"param_name" => "show_author",
				"class" => "2",
				"value" => array(
					esc_html__("Yes",'dsk-shortcodes') => '1',
					esc_html__("No",'dsk-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Template style",'dsk-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1",'dsk-shortcodes') =>  'style1',
					esc_html__("Style2 - Carousel",'dsk-shortcodes') => 'style2',
					esc_html__("Style3 - Carousel",'dsk-shortcodes') => 'style3',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to choose thumbnail",'dsk-shortcodes'),
				"param_name" => "thumbnail",
				"value" => array(
					esc_html__("No",'dsk-shortcodes') => '',
					esc_html__("dsk_blog_tiny_thumb",'dsk-shortcodes') => 'dsk_blog_tiny_thumb',
					esc_html__("dsk_blog_small_thumb",'dsk-shortcodes') => 'dsk_blog_small_thumb',
					//esc_html__("dsk_blog_xsmall_thumb",'dsk-shortcodes') => 'dsk_blog_xsmall_thumb',
					esc_html__("dsk_blog_large_thumb",'dsk-shortcodes') => 'dsk_blog_large_thumb',
					//esc_html__("dsk_blog_default_thumb",'dsk-shortcodes') => 'dsk_blog_default_thumb',
					//esc_html__("dsk_blog_masonry_thumb",'dsk-shortcodes') => 'dsk_blog_masonry_thumb',
					esc_html__("WP thumbnail",'dsk-shortcodes') => 'thumbnail',
					esc_html__("WP medium",'dsk-shortcodes') => 'medium',
					esc_html__("WP large",'dsk-shortcodes') => 'large',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Posts number limit",'dsk-shortcodes'),
				"param_name" => "number_limit",
				"value" => "4"
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Order By",'dsk-shortcodes'),
				"param_name" => "orderby",
				"class" => "",
				"value" => array(
					esc_html__("Date",'dsk-shortcodes') => 'date',
					esc_html__("Title",'dsk-shortcodes') =>  'title',
					esc_html__("author",'dsk-shortcodes') =>  'author',
					esc_html__("Random",'dsk-shortcodes') =>  'rand',
					esc_html__("Comment Count",'dsk-shortcodes') =>  'comment_count',
					esc_html__("Menu Order",'dsk-shortcodes') =>  'menu_order',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Sort order",'dsk-shortcodes'),
				"param_name" => "sortorder",
				"class" => "",
				"value" => array(
					esc_html__("ASC",'dsk-shortcodes') => 'ASC',
					esc_html__("DESC",'dsk-shortcodes') =>  'DESC',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'dsk-shortcodes'),
				"param_name" => "number_desktop",
				"value" => "5",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style3', 'style2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'dsk-shortcodes'),
				"param_name" => "number_tablet",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style3', 'style2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'dsk-shortcodes'),
				"param_name" => "number_tabletp",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style3', 'style2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'dsk-shortcodes'),
				"param_name" => "number_mobilel",
				"value" => "2",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style3', 'style2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'dsk-shortcodes'),
				"param_name" => "number_mobilep",
				"value" => "1",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style3', 'style2'),
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}