<?php
// SNS Info Box
add_shortcode('sns_loginregister', 'dsk_loginregistertemplate');
add_action('vc_after_init', 'dsk_loginregistersettings');
function dsk_loginregistertemplate($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_loginregister'))
        include $template;
    return ob_get_clean();
}
function dsk_loginregistersettings() {
	$extra_class = dsk_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Login and Register", 'dsk-shortcodes'),
		"base" => "sns_loginregister",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Contain login, register link, welcome text,....', 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Want to use welcome text", 'dsk-shortcodes'),
				"param_name" => "welcome_text",
				"value" => "",
				'description' => __( 'Example: Hello/Hi/Welcome...', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Login text link", 'dsk-shortcodes'),
				"param_name" => "login_text" ,
				"description" => esc_html__("Example: Login", 'dsk-shortcodes'),
				"value" => esc_html__("Login", 'dsk-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Want to use seperator between Login and Register?", 'dsk-shortcodes'),
				"param_name" => "seperator",
				"value" => esc_html__("|",'dsk-shortcodes'),
				'description' => __( 'Example: or', 'dsk-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Register text link", 'dsk-shortcodes'),
				"param_name" => "register_text" ,
				"description" => esc_html__("Example: Sign up", 'dsk-shortcodes'),
				"value" => esc_html__("Register", 'dsk-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Logout text link", 'dsk-shortcodes'),
				"param_name" => "logout_text" ,
				"description" => esc_html__("Example: Logout", 'dsk-shortcodes'),
				"value" => esc_html__("Logout", 'dsk-shortcodes')
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}