<?php
// SNS Vertical Menu
add_shortcode('sns_menu', 'dsk_menu_template');
add_action('vc_after_init', 'dsk_menu_settings');
function dsk_menu_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_menu'))
        include $template;
    return ob_get_clean();
}
function dsk_menu_settings() {
	$extra_class = dsk_extra_class();
	$custom_menus = array();
	if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
		$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
		if ( is_array( $menus ) && ! empty( $menus ) ) {
			foreach ( $menus as $single_menu ) {
				if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
					$custom_menus[ $single_menu->name ] = $single_menu->term_id;
				}
			}
		}
	}
	vc_map( array(
		"name"  => esc_html__("SNS Menu", 'dsk-shortcodes'),
		"base" => "sns_menu",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Display menu with our style ...', 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'dsk-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("Your menu",'dsk-shortcodes'),
				"admin_label" => true,
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Menu', 'dsk-shortcodes' ),
				'param_name' => 'nav_menu',
				'value' => $custom_menus,
				'description' => empty( $custom_menus ) ? esc_html__( 'Custom menus not found. Please visit <b>Appearance > Menus</b> page to create new menu.', 'dsk-shortcodes' ) : esc_html__( 'Select menu to display.', 'dsk-shortcodes' ),
				'admin_label' => true,
				'save_always' => true,
			),
			array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Default', 'dsk-shortcodes' ) => '1',
					esc_html__( 'Inline menu', 'dsk-shortcodes' ) => '2',
					esc_html__( 'Vertical menu', 'dsk-shortcodes' ) => '3',
				),
				"heading" => esc_html__("Menu style", 'dsk-shortcodes'),
				"param_name" => "menu_style"
		    ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Menu class",'dsk-shortcodes'),
				"param_name" => "menu_class",
				"value" =>  esc_html__("nav navbar-nav",'dsk-shortcodes'),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'No', 'dsk-shortcodes' ) => '2',
					esc_html__( 'Yes', 'dsk-shortcodes' ) => '1',
				),
				"heading" => esc_html__("Want to use responsive menu?", 'dsk-shortcodes'),
				"param_name" => "menu_responsive"
		    ),
			vc_map_add_css_animation(),
			$extra_class,
		)
	));
}