<?php
// SNS Single Testimonial
add_shortcode('sns_single_testimonial', 'dsk_single_testimonial_template');
add_action('vc_after_init', 'dsk_single_testimonial_settings');
function dsk_single_testimonial_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_single_testimonial'))
        include $template;
    return ob_get_clean();
}
function dsk_single_testimonial_settings() {
	$extra_class = dsk_extra_class();
	$css_animation = dsk_css_animation();
	
	vc_map( array(
		"name"  => esc_html__("SNS Single Testimonial", 'dsk-shortcodes'),
		"base" => "sns_single_testimonial",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Display single Testimonial', 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textarea",
				"heading" => esc_html__("Testimonial content", 'dsk-shortcodes'),
				"param_name" => "testimonial_content"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'dsk-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1",'dsk-shortcodes') => 'style1',
					esc_html__("Style2",'dsk-shortcodes') => 'style2',
				),
			),
			array(
		        "type" => "attach_image",
		        "heading" => esc_html__("Author avatar", 'dsk-shortcodes'),
		        "param_name" => "author_avatar",
		    ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author name",'dsk-shortcodes'),
				"param_name" => "author_name",
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author position",'dsk-shortcodes'),
				"param_name" => "author_position",
				"admin_label" => true,
			),
			
			$extra_class,
			$css_animation,
		)
	));
}