<?php
// SNS Time Count Down
add_shortcode('sns_time_countdown', 'dsk_time_countdown_template');
add_action('vc_after_init', 'dsk_time_countdown_settings');
function dsk_time_countdown_template($atts, $content = null) {
    ob_start();
    if ($template = dsk_shortcode_template('sns_time_countdown'))
        include $template;
    return ob_get_clean();
}
function dsk_time_countdown_settings() {
	$extra_class = dsk_extra_class();
	vc_map( array(
		"name"  => esc_html__("SNS Time Count Down", 'dsk-shortcodes'),
		"base" => "sns_time_countdown",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('DSK', 'dsk-shortcodes'),
		'description' => esc_html__( 'Show time count down', 'dsk-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Date", 'dsk-shortcodes'),
				"param_name" => "thedate" ,
				"value" => '2017/10/02',
				'description' => esc_html__( 'The format date is Y/m/d. EX: 2017/10/02', 'dsk-shortcodes' ),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'dsk-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1",'dsk-shortcodes') => 'style1',
					esc_html__("Style2",'dsk-shortcodes') => 'style2',
					esc_html__("Style3",'dsk-shortcodes') => 'style3',
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	));
}