<?php
add_action( 'init', 'register_rivalvcard_Portfolio' );
function register_rivalvcard_Portfolio() {
    
    $labels = array( 
        'name' => __( 'Portfolio', 'rivalvcard' ),
        'singular_name' => __( 'Portfolio', 'rivalvcard' ),
        'add_new' => __( 'Add New Portfolio', 'rivalvcard' ),
        'add_new_item' => __( 'Add New Portfolio', 'rivalvcard' ),
        'edit_item' => __( 'Edit Portfolio', 'rivalvcard' ),
        'new_item' => __( 'New Portfolio', 'rivalvcard' ),
        'view_item' => __( 'View Portfolio', 'rivalvcard' ),
        'search_items' => __( 'Search Portfolios', 'rivalvcard' ),
        'not_found' => __( 'No Portfolios found', 'rivalvcard' ),
        'not_found_in_trash' => __( 'No Portfolios found in Trash', 'rivalvcard' ),
        'parent_item_colon' => __( 'Parent Portfolio:', 'rivalvcard' ),
        'menu_name' => __( 'Portfolio', 'rivalvcard' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Portfolio',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments', 'post-formats' ),
        'taxonomies' => array( 'Portfolio_category','categories','tags' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => get_stylesheet_directory_uri(). '/images/admin_ico.png', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_type' => 'post'
    );

    register_post_type( 'Portfolio', $args );
}
add_action( 'init', 'create_Categories_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Categories_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like categories
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Categories', 'rivalvcard' ),
    'singular_name' => __( 'Categories', 'rivalvcard' ),
    'search_items' =>  __( 'Search Categories','rivalvcard' ),
    'all_items' => __( 'All Categories','rivalvcard' ),
    'parent_item' => __( 'Parent Categories','rivalvcard' ),
    'parent_item_colon' => __( 'Parent Categories:','rivalvcard' ),
    'edit_item' => __( 'Edit Categories','rivalvcard' ), 
    'update_item' => __( 'Update Categories','rivalvcard' ),
    'add_new_item' => __( 'Add New Categories','rivalvcard' ),
    'new_item_name' => __( 'New Categories Name','rivalvcard' ),
    'menu_name' => __( 'Categories','rivalvcard' ),
  );     

// Now register the taxonomy

  register_taxonomy('categories',array('Portfolio'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'categories' ),
  ));

}
add_action( 'init', 'create_Tags_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Tags_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like categories
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Tags', 'rivalvcard' ),
    'singular_name' => __( 'Tags', 'rivalvcard' ),
    'search_items' =>  __( 'Search Tags','rivalvcard' ),
    'all_items' => __( 'All Tags','rivalvcard' ),
    'parent_item' => __( 'Parent Tags','rivalvcard' ),
    'parent_item_colon' => __( 'Parent Tags:','rivalvcard' ),
    'edit_item' => __( 'Edit Tags','rivalvcard' ), 
    'update_item' => __( 'Update Tags','rivalvcard' ),
    'add_new_item' => __( 'Add New Tags','rivalvcard' ),
    'new_item_name' => __( 'New Tags Name','rivalvcard' ),
    'menu_name' => __( 'Tags','rivalvcard' ),
  );     

// Now register the taxonomy

  register_taxonomy('tags',array('Portfolio'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'tags' ),
  ));

}
?>