<?php
$shift_cv_slider_sc = shift_cv_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $shift_cv_slider_sc ) && strpos( $shift_cv_slider_sc, '[' ) !== false && strpos( $shift_cv_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$shift_cv_anchor_icon = shift_cv_get_theme_option( 'front_page_title_anchor_icon' );
		$shift_cv_anchor_text = shift_cv_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $shift_cv_anchor_icon ) || ! empty( $shift_cv_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $shift_cv_anchor_icon ) ? ' icon="' . esc_attr( $shift_cv_anchor_icon ) . '"' : '' )
									. ( ! empty( $shift_cv_anchor_text ) ? ' title="' . esc_attr( $shift_cv_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $shift_cv_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$shift_cv_scheme = shift_cv_get_theme_option( 'front_page_title_scheme' );
		if ( ! shift_cv_is_inherit( $shift_cv_scheme ) ) {
			echo ' scheme_' . esc_attr( $shift_cv_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( shift_cv_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$shift_cv_css      = '';
		$shift_cv_bg_image = shift_cv_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $shift_cv_bg_image ) ) {
			$shift_cv_css .= 'background-image: url(' . esc_url( shift_cv_get_attachment_url( $shift_cv_bg_image ) ) . ');';
		}
		if ( ! empty( $shift_cv_css ) ) {
			echo ' style="' . esc_attr( $shift_cv_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$shift_cv_anchor_icon = shift_cv_get_theme_option( 'front_page_title_anchor_icon' );
		$shift_cv_anchor_text = shift_cv_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $shift_cv_anchor_icon ) || ! empty( $shift_cv_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $shift_cv_anchor_icon ) ? ' icon="' . esc_attr( $shift_cv_anchor_icon ) . '"' : '' )
									. ( ! empty( $shift_cv_anchor_text ) ? ' title="' . esc_attr( $shift_cv_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( shift_cv_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' shift_cv-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$shift_cv_css      = '';
			$shift_cv_bg_mask  = shift_cv_get_theme_option( 'front_page_title_bg_mask' );
			$shift_cv_bg_color_type = shift_cv_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $shift_cv_bg_color_type ) {
				$shift_cv_bg_color = shift_cv_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $shift_cv_bg_color_type ) {
				$shift_cv_bg_color = shift_cv_get_scheme_color( 'bg_color', $shift_cv_scheme );
			} else {
				$shift_cv_bg_color = '';
			}
			if ( ! empty( $shift_cv_bg_color ) && $shift_cv_bg_mask > 0 ) {
				$shift_cv_css .= 'background-color: ' . esc_attr(
					1 == $shift_cv_bg_mask ? $shift_cv_bg_color : shift_cv_hex2rgba( $shift_cv_bg_color, $shift_cv_bg_mask )
				) . ';';
			}
			if ( ! empty( $shift_cv_css ) ) {
				echo ' style="' . esc_attr( $shift_cv_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$shift_cv_caption = shift_cv_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $shift_cv_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $shift_cv_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $shift_cv_caption, 'shift_cv_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$shift_cv_description = shift_cv_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $shift_cv_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $shift_cv_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $shift_cv_description ), 'shift_cv_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( shift_cv_get_theme_option( 'front_page_title_button1_link' ) != '' || shift_cv_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						shift_cv_show_layout( shift_cv_customizer_partial_refresh_front_page_title_button1_link() );
						shift_cv_show_layout( shift_cv_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
