<?php
// SNS Product
add_shortcode('sns_advance_cat_info', 'snsvicky_advance_cat_info_template');
add_action('vc_after_init', 'snsvicky_advance_cat_info_settings');
function snsvicky_advance_cat_info_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('sns_advance_cat_info'))
        include $template;
    return ob_get_clean();
}
function snsvicky_advance_cat_info_settings() {
	$extra_class = snsvicky_extra_class();
	$categories = snsvicky_woo_cat(0);
	$woocat_value_drop =  array();
	snsvicky_woo_cat_level(0, 0, $categories, 0, $woocat_value_drop);
	vc_map( array(
		"name" => esc_html__("SNS Advance Cat Info",'snsvicky-shortcodes'),
		"base" => "sns_advance_cat_info",
		"icon" => "sns_icon_advance_cat_info",
		"class" => "sns_advance_cat_info",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "WooCommerce advance category info",'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "dropdown",
				'multiple' => true,
				"class" => "",
				"value" => $woocat_value_drop,
				"param_name" => "cat"
			),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Custom category title", 'snsvicky-shortcodes'),
				"param_name" => "title",
				"value" => esc_html__("Your Category Title",'snsvicky-shortcodes'),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image for Category", 'snsvicky-shortcodes'),
		      "param_name" => "cat_image",
		      "description" => esc_html__('You should use image with transparent background','snsvicky-shortcodes'),
		    ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Image align",'snsvicky-shortcodes'),
				"param_name" => "image_align",
				"value" => array(
					esc_html__('Align left', 'snsvicky-shortcodes') => "left",
					esc_html__('Align right', 'snsvicky-shortcodes') => "right",
				),
			),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Custom description", 'snsvicky-shortcodes'),
				"param_name" => "desc"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}