<?php
// SNS Product
add_shortcode('sns_cat_info', 'snsvicky_cat_info_template');
add_action('vc_after_init', 'snsvicky_cat_info_settings');
function snsvicky_cat_info_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('sns_cat_info'))
        include $template;
    return ob_get_clean();
}
function snsvicky_cat_info_settings() {
	$extra_class = snsvicky_extra_class();
	$categories = snsvicky_woo_cat(0);
	$woocat_value_drop =  array();
	snsvicky_woo_cat_level(0, 0, $categories, 0, $woocat_value_drop);
	vc_map( array(
		"name" => esc_html__("SNS Cat Info",'snsvicky-shortcodes'),
		"base" => "sns_cat_info",
		"icon" => "sns_icon_cat_info",
		"class" => "sns_cat_info",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "WooCommerce category info",'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"heading" => esc_html__("Category",'snsvicky-shortcodes'),
				"type" => "dropdown",
				'multiple' => true,
				"class" => "",
				"value" => $woocat_value_drop,
				"param_name" => "cat"
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image for Category", 'snsvicky-shortcodes'),
		      "param_name" => "cat_image",
		    ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'snsvicky-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__('Style 1', 'snsvicky-shortcodes') => "1",
					esc_html__('Style 2', 'snsvicky-shortcodes') => "2",
					esc_html__('Style 3', 'snsvicky-shortcodes') => "3",
					esc_html__('Style 4', 'snsvicky-shortcodes') => "4",
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show product number of Category",'snsvicky-shortcodes'),
				"param_name" => "show_prd_num",
				"value" => array(
					esc_html__("Yes",'snsvicky-shortcodes') => '1',
					esc_html__("No",'snsvicky-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'style',
					'value' => array('1', '2'),
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}