<?php
// SNS Product
add_shortcode('sns_products', 'snsvicky_products_template');
add_action('vc_after_init', 'snsvicky_products_settings');
function snsvicky_products_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('sns_products'))
        include $template;
    return ob_get_clean();
}
function snsvicky_products_settings() {
	$extra_class = snsvicky_extra_class();
	$woocat_value = snsvicky_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Products",'snsvicky-shortcodes'),
		"base" => "sns_products",
		"icon" => "sns_icon_products",
		"class" => "sns_products",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "WooCommerce products",'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'snsvicky-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("New Products", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Title style",'snsvicky-shortcodes'),
				"param_name" => "title_style",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1 - Default",'snsvicky-shortcodes') => '',
					esc_html__("Style 2",'snsvicky-shortcodes') => '2',
				),
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"value" => $woocat_value,
				"heading" => esc_html__("Select Category",'snsvicky-shortcodes'),
				"param_name" => "lit_cat",
				"description" => esc_html__("If you don't select any category, It mean is selected all category", 'snsvicky-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Order By",'snsvicky-shortcodes'),
				"param_name" => "orderby",
				"value" => array(
					esc_html__('Latest Products', 'snsvicky-shortcodes') => "recent",
					esc_html__('BestSeller Products', 'snsvicky-shortcodes') => "best_selling",
					esc_html__('Top Rated Products', 'snsvicky-shortcodes') => "top_rate",
					esc_html__('On Sale Products', 'snsvicky-shortcodes') => "on_sale",
					esc_html__('Hot Deal', 'snsvicky-shortcodes') => "hot_deal",
					esc_html__('Featured Products', 'snsvicky-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'snsvicky-shortcodes') => "recent_review",
				),
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Mode View",'snsvicky-shortcodes'),
				"param_name" => "modeview",
				"admin_label" => true,
				"value" => array(
					esc_html__("Gird",'snsvicky-shortcodes') => '1',
					esc_html__("List",'snsvicky-shortcodes') => '2',
				),
				"description" => esc_html__("Mode View", 'snsvicky-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Grid styles",'snsvicky-shortcodes'),
				"param_name" => "gridstyle",
				"value" => array(
					esc_html__("Style 1 - Default",'snsvicky-shortcodes') => '',
					esc_html__("Style 2",'snsvicky-shortcodes') => '2',
					esc_html__("Style 3",'snsvicky-shortcodes') => '3',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Thumbnail type",'snsvicky-shortcodes'),
				"param_name" => "thumb_type",
				"value" => array(
					esc_html__("Shop Thumbnail",'snsvicky-shortcodes') => '',
					esc_html__("SNSVicky 70x80 Thumbnail",'snsvicky-shortcodes') => '7080',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Navigation",'snsvicky-shortcodes'),
				"param_name" => "use_nav",
				"value" => array(
					esc_html__("Yes",'snsvicky-shortcodes') => '1',
					esc_html__("No",'snsvicky-shortcodes') => '2',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Product number limit",'snsvicky-shortcodes'),
				"param_name" => "number_limit",
				"value" => "10",
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'snsvicky-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_mobilep",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_mobilel",
				"value" => "2"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_tabletp",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_tablet",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'snsvicky-shortcodes'),
				"param_name" => "number_desktop",
				"value" => "5"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}