<?php
// SNS Sale Count Down
add_shortcode('sns_sale_count_down', 'snsvicky_sale_countdown_template');
add_action('vc_after_init', 'snsvicky_sale_countdown_settings');
function snsvicky_sale_countdown_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('sns_sale_count_down'))
        include $template;
    return ob_get_clean();
}
function snsvicky_sale_countdown_settings() {
	$extra_class = snsvicky_extra_class();
	$woocat_value = snsvicky_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Sale Count Down",'snsvicky-shortcodes'),
		"base" => "sns_sale_count_down",
		"icon" => "sns_icon_products",
		"class" => "sns_sale_count_down",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "WooCommerce products sale count downt",'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'snsvicky-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("Hot Deal", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"value" => $woocat_value,
				"heading" => esc_html__("Select Category",'snsvicky-shortcodes'),
				"param_name" => "lit_cat",
				"description" => esc_html__("If you don't select any category, It mean is selected all category", 'snsvicky-shortcodes')
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Product number limit",'snsvicky-shortcodes'),
				"param_name" => "number_limit",
				"value" => "10",
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'snsvicky-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_mobilep",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_mobilel",
				"value" => "2"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_tabletp",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_tablet",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'snsvicky-shortcodes'),
				"param_name" => "number_desktop",
				"value" => "5"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}