<?php
// SNS Woo Tag Cloud
add_shortcode('sns_woo_tag_cloud', 'sns_woo_tag_cloud_template');
add_action('vc_after_init', 'sns_woo_tag_cloud_settings');
function sns_woo_tag_cloud_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('sns_woo_tag_cloud'))
        include $template;
    return ob_get_clean();
}
function sns_woo_tag_cloud_settings() {
	$extra_class = snsvicky_extra_class();
	vc_map( array(
		"name" => esc_html__("SNS Woo Tag Cloud",'snsvicky-shortcodes'),
		"base" => "sns_woo_tag_cloud",
		"icon" => "sns_icon_woo_tag_cloud",
		"class" => "sns_woo_tag_cloud",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "Display Product Tag Cloud",'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'snsvicky-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("Tag Cloud", 'snsvicky-shortcodes'),
			),
			// array(
			// 	"type" => "dropdown",
			// 	"class" => "",
			// 	"heading" => esc_html__("Taxonomy:",'snsvicky-shortcodes'),
			// 	"param_name" => "taxonomy",
			// 	"value" => 'product_tag',
			// 	"description" => ""
			// ),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__("Show Tag Count",'snsvicky-shortcodes'),
				"param_name" => "count",
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}