<?php
// SNSVicky Product Ajax Tab - Home1, Style1
add_shortcode('snsvicky_products_ajaxtab', 'snsvicky_products_ajaxtab_template');
add_action('vc_after_init', 'snsvicky_products_ajaxtab_settings');
function snsvicky_products_ajaxtab_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_woo_template('snsvicky_products_ajaxtab'))
        include $template;
    return ob_get_clean();
}
function snsvicky_products_ajaxtab_settings() {
	$extra_class = snsvicky_extra_class();
	$woocat_value = snsvicky_woo_cat();
	$categories = snsvicky_woo_cat(0);
	$woocat_value_drop =  array();
	snsvicky_woo_cat_level(0, 0, $categories, 0, $woocat_value_drop);

	vc_map( array(
		"name" => esc_html__("Products Ajax Tab",'snsvicky-shortcodes'),
		"base" => "snsvicky_products_ajaxtab",
		"icon" => "icon_snsvicky_products_ajaxtab",
		"class" => "snsvicky_products_ajaxtab",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "Products Ajax Tab",'snsvicky-shortcodes' ),
		"params" => array(
			// array(
			// 	"type" => "textfield",
			// 	"heading" => esc_html__("Title",'snsvicky-shortcodes'),
			// 	"param_name" => "title",
			// 	"admin_label" => true,
			// 	"value" =>  esc_html__("The titme", 'snsvicky-shortcodes'),
			// ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style for Tab Header",'snsvicky-shortcodes'),
				"param_name" => "style_tabheader",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1 - Default",'snsvicky-shortcodes') => '',
					esc_html__("Style 2",'snsvicky-shortcodes') => '2',
				),
			),
			array(
				"type" => "checkbox",
				"value" => $woocat_value,
				"heading" => esc_html__("Choice categories",'snsvicky-shortcodes'),
				"param_name" => "cat",
				"description" => esc_html__('If you dont choice, That mean it will query all category','snsvicky-shortcodes'),
			),
			array(
				"type" => "checkbox",
				"heading" => esc_html__("Select tab to display",'snsvicky-shortcodes'),
				"param_name" => "orderby_tab",
				"value" => array(
					esc_html__('Latest', 'snsvicky-shortcodes') => "recent",
					esc_html__('Best Seller', 'snsvicky-shortcodes') => "best_selling",
					esc_html__('Top Rated', 'snsvicky-shortcodes') => "top_rate",
					esc_html__('Special', 'snsvicky-shortcodes') => "on_sale",
					esc_html__('Featured', 'snsvicky-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'snsvicky-shortcodes') => "recent_review",
				),
				"description" => ""
			),
		    array(
				"type" => "dropdown",
				'multiple' => true,
				"class" => "",
				"value" => array(
					esc_html__('No Effect', 'snsvicky-shortcodes') => "simple-effect",
					esc_html__('fadeIn', 'snsvicky-shortcodes') => "fadeIn",
					esc_html__('fadeInUp', 'snsvicky-shortcodes') => "fadeInUp",
					esc_html__('fadeInDown', 'snsvicky-shortcodes') => "fadeInDown",
					esc_html__('fadeInRight', 'snsvicky-shortcodes') => "fadeInRight",
					esc_html__('pageLeft', 'snsvicky-shortcodes') => "pageLeft",
					esc_html__('pageRight', 'snsvicky-shortcodes') => "pageRight",
					esc_html__('pageTop', 'snsvicky-shortcodes') => "pageTop",
					esc_html__('pageBottom', 'snsvicky-shortcodes') => "pageBottom",
					esc_html__('bounceIn', 'snsvicky-shortcodes') => "bounceIn",
					esc_html__('bounceInRight', 'snsvicky-shortcodes') => "bounceInRight",
					esc_html__('zoomIn', 'snsvicky-shortcodes') => "zoomIn",
					esc_html__('zoomOut', 'snsvicky-shortcodes') => "zoomOut",
				),
				"heading" => esc_html__("Effect to show item in tab",'snsvicky-shortcodes'),
				"param_name" => "effect",
				
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Grid styles",'snsvicky-shortcodes'),
				"param_name" => "gridstyle",
				"value" => array(
					esc_html__("Style 1 - Default",'snsvicky-shortcodes') => '',
					esc_html__("Style 2",'snsvicky-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '1',
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product limit to query for each tab",'snsvicky-shortcodes'),
				"param_name" => "number_limit",
				"admin_label" => true,
				"value" =>  esc_html__("16", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'snsvicky-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product/column to display on Desktop",'snsvicky-shortcodes'),
				"param_name" => "number_desktop",
				"admin_label" => true,
				"value" =>  esc_html__("5", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product/column to display on Tablet Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_tablet",
				"admin_label" => true,
				"value" =>  esc_html__("3", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product/column to display on Tablet Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product/column to display on Mobile Landscape",'snsvicky-shortcodes'),
				"param_name" => "number_mobilel",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'snsvicky-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product/column to display on Nobile Portrait",'snsvicky-shortcodes'),
				"param_name" => "number_mobilep",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'snsvicky-shortcodes'),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}