<?php
$output = '';
$atts = vc_map_get_attributes( 'sns_sale_count_down', $atts );
extract( $atts );
if( class_exists('WooCommerce') ){
	if (!$number_limit) $number_limit = '-1';
	$uq = rand().time();
	$class = 'sns-sale-count-down woocommerce';
	$class .= ( trim(esc_attr($extra_class))!='' )?' '.esc_attr($extra_class):'';
	if ($css_animation) $class .= ' '.esc_attr($css_animation);
	$data = '';
	$data .= ' data-desktop="'.$number_desktop.'"';
	$data .= ' data-tabletl="'.$number_tablet.'"';
	$data .= ' data-tabletp="'.$number_tabletp.'"';
	$data .= ' data-mobilel="'.$number_mobilel.'"';
	$data .= ' data-mobilep="'.$number_mobilep.'"';
	wp_enqueue_script('owlcarousel');

	global $woocommerce, $wpdb;
    $query = $wpdb->prepare("
        SELECT posts.ID, posts.post_parent
        FROM {$wpdb->prefix}posts posts
        INNER JOIN {$wpdb->prefix}postmeta ON (posts.ID = {$wpdb->prefix}postmeta.post_id)
        INNER JOIN {$wpdb->prefix}postmeta AS mt1 ON (posts.ID = mt1.post_id)
        WHERE
            posts.post_status = 'publish'
            AND (mt1.meta_key = '_sale_price_dates_to' AND mt1.meta_value >= %s) 
            GROUP BY posts.ID 
            ORDER BY %s
        ",
    time(), "ASC");

    $product_ids_raw = $wpdb->get_results($query);
    $product_ids_countdown = array();
    foreach ( $product_ids_raw as $product_raw ) {
        if(!empty($product_raw->post_parent)){
            $product_ids_countdown[] = $product_raw->post_parent;
        }else{
            $product_ids_countdown[] = $product_raw->ID;  
        }
    }
    $product_ids_countdown = array_unique($product_ids_countdown);
    if ( is_array($product_ids_countdown) && count($product_ids_countdown) == 0 ) {
        $product_ids_countdown = wc_get_product_ids_on_sale(); 
    }
    $args = array(
        'post_type' 		=> 'product',
        'posts_per_page' 	=> -1,
        'post_status' 		=> 'publish',
    	'offset'            => 0,
        'paged' 			=> 1,
        'meta_query' 		=> array(
	        array(
	            'key' 	=> '_stock_status',
	            'value' => 'instock'
	        ),
	        array(
                'key'     => '_stock',
                'value'   => 0,
                'compare' => '>',
                'type'    => 'numeric'
            )
	    ),
	    'post__in' 			=> $product_ids_countdown
    );
	$loop = new WP_Query($args);

	$output .= '<div class="'.$class.'" '.$data.'>';
	if ($title) $output .= '<h2 class="wpb_heading"><span>'.esc_attr($title).'</span></h2>';
	if( $loop->have_posts() ) :
		//$output .= '<div class="prdlist-content">';
		ob_start();
		echo '<div class=" owl-carousel">';
		$i = 0;
		while ( $loop->have_posts() ) : $loop->the_post();
			if ( $number_row && $number_row > 1 ){
				if ( $i == 0 || $i%$number_row == 0 ) {
					echo '<div class="item-row">';
				}
			}
		    wc_get_template( 'vc/item-sale-countdown.php');
		    if ( $number_row && $number_row > 1 ){
		    	if ( $loop->post_count == $i+1 || ($i+1)%$number_row == 0 ){
		    		echo '</div><!--End .item-row-->';
		    	}
		    	$i++;
		    }
		endwhile;
		echo '</div>';
		$output .= ob_get_clean();
		//$output .= '</div>';
	else:
		$output .= '<p>'.esc_html__('There are no products matching to show', 'snsvicky-shortcodes').'</p>';
	endif;
	$output .= '</div>';
	wp_reset_postdata();
}
echo $output;
