<?php
// SNS Blog Page
add_shortcode('sns_blog_page', 'snsvicky_blog_page_template');
add_action('vc_after_init', 'snsvicky_blog_page_settings');
function snsvicky_blog_page_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_blog_page'))
        include $template;
    return ob_get_clean();
}
function snsvicky_blog_page_settings() {
	$extra_class = snsvicky_extra_class();
	$css_animation = snsvicky_css_animation();
	$cat_value = snsvicky_cat();
	vc_map( array(
		"name" => esc_html__("SNS Blog Page",'snsvicky-shortcodes'),
		"base" => "sns_blog_page",
		"icon" => "sns_icon_blogpage",
		"class" => "sns_blogpage",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "To create blog page with some style", 'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "checkbox",
				"value" => $cat_value,
				"class" => "",
				"heading" => esc_html__("Categories",'snsvicky-shortcodes'),
				"description" => esc_html__( "If you dont sellect category, the default is sellected all category", 'snsvicky-shortcodes' ),
				"param_name" => "category"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Blog Style",'snsvicky-shortcodes'),
				"param_name" => "blog_type",
				"value" => array(
					esc_html__("Blog Layout 1",'snsvicky-shortcodes') 	=> "",
					esc_html__("Blog Layout 2",'snsvicky-shortcodes') 	=>  "layout2",
					esc_html__("Masonry",'snsvicky-shortcodes')			=>  "masonry",
				),
				"description" => ""
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Post per pages",'snsvicky-shortcodes'),
				"param_name" => "posts_per_page",
				"value" => "6"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Excerpt Length",'snsvicky-shortcodes'),
				"param_name" => "excerpt_length",
				"value" => "35"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Page Navigation",'snsvicky-shortcodes'),
				"param_name" => "pagination",
				"value" => array(
					esc_html__("Default",'snsvicky-shortcodes') => 'def',
					esc_html__("Ajax",'snsvicky-shortcodes') =>  'ajax'
				),
				'description' => esc_html__('Choose Type of navigation.','snsvicky-shortcodes')
			),
			
			$css_animation,
			$extra_class,
		)
	) );
}