<?php
// SNS Carousel

$extra_class = snsvicky_extra_class();
if ( function_exists('vc_map') ) vc_map( array(
	"name" => esc_html__("SNS Carousel",'snsvicky-shortcodes'),
	"base" => "sns_carousel",
	"class" => "sns_carousel",
	"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
	"description" => esc_html__( "Carousel for other shortcodes",'snsvicky-shortcodes' ),
    "as_parent" => array('except' => 'sns_carousel'),
    "content_element" => true,
    "show_settings_on_create" => true,
    "is_container" => true,
    "js_view" => 'VcColumnView',
    "params" => array(
        // add params same as with any other content element
        array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html__("Title",'snsvicky-shortcodes'),
			"param_name" => "title",
			"admin_label" => true,
			"value" => "",
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__("Slider Type",'snsvicky-shortcodes'),
			"param_name" => "slider_type",
			"value" => array(
				esc_html__("Horizontal",'snsvicky-shortcodes') => 'h',
				esc_html__("Vertical",'snsvicky-shortcodes') =>  'v'
			)
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__("Show Navigation",'snsvicky-shortcodes'),
			"param_name" => "show_nav",
			"value" => array(
				esc_html__("No",'snsvicky-shortcodes') => '0',
				esc_html__("Yes",'snsvicky-shortcodes') =>  '1'
			)
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__("Show Paging",'snsvicky-shortcodes'),
			"param_name" => "show_paging",
			"value" => array(
				esc_html__("No",'snsvicky-shortcodes') => '0',
				esc_html__("Yes",'snsvicky-shortcodes') =>  '1'
			),
			'dependency' => array(
				'element' => 'slider_type',
				'value' => 'h',
			),
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__("Paging with Image",'snsvicky-shortcodes'),
			"param_name" => "show_dotimg",
			"value" => array(
				esc_html__("No",'snsvicky-shortcodes') => '0',
				esc_html__("Yes",'snsvicky-shortcodes') =>  '1'
			),
			'dependency' => array(
				'element' => 'slider_type',
				'value' => 'h',
			),
		),
        array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html__("Number items on Desktop",'snsvicky-shortcodes'),
			"param_name" => "n_desktop",
			"value" => esc_html__("1",'snsvicky-shortcodes'),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html__("Number items on Tablet Landscape",'snsvicky-shortcodes'),
			"param_name" => "n_tablet",
			"value" => esc_html__("1",'snsvicky-shortcodes'),
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__("Number items on Tablet Portrait",'snsvicky-shortcodes'),
			"param_name" => "n_tabletp",
			"admin_label" => true,
			"value" =>  esc_html__("1", 'snsvicky-shortcodes'),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html__("Number items on Mobile Landscape",'snsvicky-shortcodes'),
			"param_name" => "n_mobile_l",
			"value" => esc_html__("1",'snsvicky-shortcodes'),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html__("Number items on Mobile Portrait",'snsvicky-shortcodes'),
			"param_name" => "n_mobile_p",
			"value" => esc_html__("1",'snsvicky-shortcodes'),
		),
		vc_map_add_css_animation(),
		$extra_class,
    ),
) );

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_SNS_Carousel extends WPBakeryShortCodesContainer {
    }
}

add_shortcode('sns_carousel', 'snsvicky_carousel_template');
function snsvicky_carousel_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_carousel'))
        include $template;
    return ob_get_clean();
}