<?php
// SNS Info Box
add_shortcode('sns_info_box', 'snsvicky_info_box_template');
add_action('vc_after_init', 'snsvicky_info_box_settings');
function snsvicky_info_box_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_info_box'))
        include $template;
    return ob_get_clean();
}
function snsvicky_info_box_settings() {
	$extra_class = snsvicky_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Box", 'snsvicky-shortcodes'),
		"base" => "sns_info_box",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('SNS Vicky', 'snsvicky-shortcodes'),
		'description' => esc_html__( 'Box contain: icon, title, description', 'snsvicky-shortcodes' ),
		"params" => array(		
		    array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Have border', 'snsvicky-shortcodes' ) => '1',
					esc_html__( 'Just border left', 'snsvicky-shortcodes' ) => '2',
					esc_html__( 'No border', 'snsvicky-shortcodes' ) => '3',
				),
				"heading" => esc_html__("Box style", 'snsvicky-shortcodes'),
				"param_name" => "box_style"
		    ),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("Padding for box", 'snsvicky-shortcodes'),
				"param_name" => "box_padding" ,
				"value" => esc_html__("20px",'snsvicky-shortcodes'),
				"description" => esc_html__("It's padding for box, example: 20px or 20px 10px 20px 10px", 'snsvicky-shortcodes'),
				'dependency' => array(
					'element' => 'box_style',
					'value' => '1',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'snsvicky-shortcodes' ),
				'value' => array(
					esc_html__( 'Media', 'snsvicky-shortcodes' ) => 'media',
					esc_html__( 'Font Awesome', 'snsvicky-shortcodes' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'snsvicky-shortcodes' ) => 'openiconic',
					esc_html__( 'Typicons', 'snsvicky-shortcodes' ) => 'typicons',
					esc_html__( 'Entypo', 'snsvicky-shortcodes' ) => 'entypo',
					esc_html__( 'Linecons', 'snsvicky-shortcodes' ) => 'linecons',
				),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'snsvicky-shortcodes' ),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image", 'snsvicky-shortcodes'),
		      "param_name" => "icon_image",
		      'dependency' => array(
					'element' => 'icon_type',
					'value' => 'media',
				),
		    ),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'snsvicky-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_openiconic',
				'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'openiconic',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'description' => esc_html__( 'Select icon from library.', 'snsvicky-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_typicons',
				'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'typicons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'snsvicky-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_entypo',
				'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'entypo',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_linecons',
				'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'linecons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'description' => esc_html__( 'Select icon from library.', 'snsvicky-shortcodes' ),
			),
			array(
				"type" => "colorpicker",
				"value" => "",
				"heading" => esc_html__("Color for icon", 'snsvicky-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons','fontawesome','entypo','typicons','openiconic'),
				),
				"param_name" => "icon_color"
		    ),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for icon", 'snsvicky-shortcodes'),
				"param_name" => "icon_font_size" ,
				"value" => esc_html__("25px",'snsvicky-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons','fontawesome','entypo','typicons','openiconic'),
				),
				"description" => esc_html__("It's font-size for icon you sellected, example: 24px", 'snsvicky-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Custom Link", 'snsvicky-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'snsvicky-shortcodes'),
				"value" => esc_html__("http://", 'snsvicky-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title", 'snsvicky-shortcodes'),
				"param_name" => "title",
				"value" => esc_html__("Your Title Here ...",'snsvicky-shortcodes'),
				"admin_label" => true 
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Margin top for Title", 'snsvicky-shortcodes'),
				"param_name" => "title_margin_top" ,
				"value" => "",
				"description" => esc_html__("It's margin-top for title, example: 5px", 'snsvicky-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for Title", 'snsvicky-shortcodes'),
				"param_name" => "title_font_size" ,
				"value" => esc_html__("18px",'snsvicky-shortcodes'),
				"description" => esc_html__("It's font-size for title, example: 18px", 'snsvicky-shortcodes')
			),
			array(
				"type" => "colorpicker",
				"value" => "",
				"heading" => esc_html__("Color for Title", 'snsvicky-shortcodes'),
				"param_name" => "title_color"

		    ),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Description", 'snsvicky-shortcodes'),
				"param_name" => "desc"
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}