<?php
// SNS Info Box
add_shortcode('sns_info_inline', 'snsvicky_info_inline_template');
add_action('vc_after_init', 'snsvicky_info_inline_settings');
function snsvicky_info_inline_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_info_inline'))
        include $template;
    return ob_get_clean();
}
function snsvicky_info_inline_settings() {
	$extra_class = snsvicky_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Inline", 'snsvicky-shortcodes'),
		"base" => "sns_info_inline",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('SNS Vicky', 'snsvicky-shortcodes'),
		'description' => esc_html__( 'Contain: icon, title, link, ... and display inline', 'snsvicky-shortcodes' ),
		"params" => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'snsvicky-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'snsvicky-shortcodes' ) => '',
					esc_html__( 'Social', 'snsvicky-shortcodes' ) => 'social',
					esc_html__( 'Social Rounded', 'snsvicky-shortcodes' ) => 'social_rounded',
				),
				'param_name' => 'style',
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use icon?', 'snsvicky-shortcodes' ),
				'param_name' => 'use_icon',
				'description' => __( 'Use icon in content', 'snsvicky-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'snsvicky-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'use_icon',
					'value' => 'true',
				),
				'description' => esc_html__( 'Select icon from library.', 'snsvicky-shortcodes' ),
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use label?', 'snsvicky-shortcodes' ),
				'param_name' => 'use_label',
				'description' => __( 'Use label in content', 'snsvicky-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Label", 'snsvicky-shortcodes'),
				"param_name" => "label",
				"value" => esc_html__("Your label here ...",'snsvicky-shortcodes'),
				'dependency' => array(
					'element' => 'use_label',
					'value' => 'true',
				),
				"admin_label" => true 
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use link?', 'snsvicky-shortcodes' ),
				'param_name' => 'use_link',
				'description' => __( 'Use link in content', 'snsvicky-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Link", 'snsvicky-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'snsvicky-shortcodes'),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				"value" => esc_html__("http://", 'snsvicky-shortcodes')
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link target', 'snsvicky-shortcodes' ),
				'value' => array(
					esc_html__( 'Same window', 'snsvicky-shortcodes' ) => '_self',
					esc_html__( 'New window', 'snsvicky-shortcodes' ) => '_blank',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'target',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link type', 'snsvicky-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'snsvicky-shortcodes' ) => '0',
					esc_html__( 'Use mailto:', 'snsvicky-shortcodes' ) => '1',
					esc_html__( 'Use tel:', 'snsvicky-shortcodes' ) => '2',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'href_type',
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}