<?php
// SNS List Post
add_shortcode('sns_list_posts', 'snsvicky_list_posts_template');
add_action('vc_after_init', 'snsvicky_list_posts_settings');
function snsvicky_list_posts_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_list_posts'))
        include $template;
    return ob_get_clean();
}
function snsvicky_list_posts_settings() {
	$extra_class = snsvicky_extra_class();
		vc_map( array(
		"name" => esc_html__("SNS List Post",'snsvicky-shortcodes'),
		"base" => "sns_list_posts",
		"icon" => "sns_icon_listposts",
		"class" => "sns_listposts",
		"category" => esc_html__("SNS Vicky",'snsvicky-shortcodes'),
		"description" => esc_html__( "Show List Posts", 'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'snsvicky-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("Latest News",'snsvicky-shortcodes'),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Template style2",'snsvicky-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1",'snsvicky-shortcodes') => 'style1',
					esc_html__("Style2",'snsvicky-shortcodes') => 'style2',
					esc_html__("Style3",'snsvicky-shortcodes') => 'style3',
					esc_html__("Style4",'snsvicky-shortcodes') => 'style4',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Posts number limit",'snsvicky-shortcodes'),
				"param_name" => "number_limit",
				"value" => "4"
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Order By",'snsvicky-shortcodes'),
				"param_name" => "orderby",
				"class" => "",
				"value" => array(
					esc_html__("Date",'snsvicky-shortcodes') => 'date',
					esc_html__("Title",'snsvicky-shortcodes') =>  'title',
					esc_html__("author",'snsvicky-shortcodes') =>  'author',
					esc_html__("Random",'snsvicky-shortcodes') =>  'rand',
					esc_html__("Comment Count",'snsvicky-shortcodes') =>  'comment_count',
					esc_html__("Menu Order",'snsvicky-shortcodes') =>  'menu_order',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Sort order",'snsvicky-shortcodes'),
				"param_name" => "sortorder",
				"class" => "",
				"value" => array(
					esc_html__("ASC",'snsvicky-shortcodes') => 'ASC',
					esc_html__("DESC",'snsvicky-shortcodes') =>  'DESC',
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}