<?php
// SNS Single Testimonial
add_shortcode('sns_single_testimonial', 'snsvicky_single_testimonial_template');
add_action('vc_after_init', 'snsvicky_single_testimonial_settings');
function snsvicky_single_testimonial_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_single_testimonial'))
        include $template;
    return ob_get_clean();
}
function snsvicky_single_testimonial_settings() {
	$extra_class = snsvicky_extra_class();
	$css_animation = snsvicky_css_animation();
	
	vc_map( array(
		"name"  => esc_html__("SNS Single Testimonial", 'snsvicky-shortcodes'),
		"base" => "sns_single_testimonial",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('SNS Vicky', 'snsvicky-shortcodes'),
		'description' => esc_html__( 'Display single Testimonial', 'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textarea",
				"heading" => esc_html__("Testimonial content", 'snsvicky-shortcodes'),
				"param_name" => "testimonial_content"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'snsvicky-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style 1",'snsvicky-shortcodes') => 'style1',
					esc_html__("Style 2",'snsvicky-shortcodes') => 'style2',
					esc_html__("Style 3",'snsvicky-shortcodes') => 'style3',
				),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Author avatar", 'snsvicky-shortcodes'),
		      "param_name" => "author_avatar",
		    ),
		    array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Rating",'snsvicky-shortcodes'),
				"param_name" => "rating",
				"value" => array(
					esc_html__("1 star",'snsvicky-shortcodes') => 1,
					esc_html__("2 stars",'snsvicky-shortcodes') => 2,
					esc_html__("3 stars",'snsvicky-shortcodes') => 3,
					esc_html__("4 stars",'snsvicky-shortcodes') => 4,
					esc_html__("5 stars",'snsvicky-shortcodes') => 5,
				),
				'dependency' => array(
					'element' => 'style',
					'value' => 'style1',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author name",'snsvicky-shortcodes'),
				"param_name" => "author_name",
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author position",'snsvicky-shortcodes'),
				"param_name" => "author_position",
				"admin_label" => true,
			),
			$extra_class,
			$css_animation,
		)
	));
}