<?php
// SNS Vertical Menu
add_shortcode('sns_vertical_menu', 'snsvicky_vertical_menu_template');
add_action('vc_after_init', 'snsvicky_vertical_menu_settings');
function snsvicky_vertical_menu_template($atts, $content = null) {
    ob_start();
    if ($template = snsvicky_shortcode_template('sns_vertical_menu'))
        include $template;
    return ob_get_clean();
}
function snsvicky_vertical_menu_settings() {
	$extra_class = snsvicky_extra_class();
	$css_animation = snsvicky_css_animation();
	$custom_menus = array();
	if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
		$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
		if ( is_array( $menus ) && ! empty( $menus ) ) {
			foreach ( $menus as $single_menu ) {
				if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
					$custom_menus[ $single_menu->name ] = $single_menu->term_id;
				}
			}
		}
	}
	vc_map( array(
		"name"  => esc_html__("SNS Vertical Menu", 'snsvicky-shortcodes'),
		"base" => "sns_vertical_menu",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('SNS Vicky', 'snsvicky-shortcodes'),
		'description' => esc_html__( 'Display menu with vertical style ...', 'snsvicky-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'snsvicky-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("All Categories",'snsvicky-shortcodes'),
				"admin_label" => true,
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Menu', 'snsvicky-shortcodes' ),
				'param_name' => 'nav_menu',
				'value' => $custom_menus,
				'description' => empty( $custom_menus ) ? esc_html__( 'Custom menus not found. Please visit <b>Appearance > Menus</b> page to create new menu.', 'snsvicky-shortcodes' ) : esc_html__( 'Select menu to display.', 'snsvicky-shortcodes' ),
				'admin_label' => true,
				'save_always' => true,
			),
			$extra_class,
			$css_animation,
		)
	));
}