<?php
/*
Plugin Name: SNS VICKY Shortcodes
Plugin URI: http://snstheme.com
Description: Provide Shortcodes for SNS Vicky theme. This plugin just work for WPBakery Visual Composer.
Version: 1.3
Author URI: http://snstheme.com
License: GPL2+
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

define('SNSVICKY_SHORTCODES_URL', plugin_dir_url(__FILE__));
define('SNSVICKY_SHORTCODES_PATH', dirname(__FILE__));
class SNSVICKY_Shortcodes_Class {
	private $shortcodes = array(
                                "sns_info_box",
                                "sns_info_inline",
                                "snsvicky_postwcode",
                                "sns_carousel",
                                "sns_blog_page",
                                //"sns_vertical_menu",
                                "sns_single_testimonial",
                                "sns_list_posts"
                            );
    private $shortcodes_woo = array(
                                "sns_products",
                                "sns_sale_count_down",
                                "sns_cat_info",
                                "sns_advance_cat_info",
                                "snsvicky_products_ajaxtab",
                                "sns_woo_tag_cloud",
                                "sns_woo_upsell_products"
                            );
	function __construct() {
		// Load text domain
        load_plugin_textdomain( 'snsvicky-shortcodes', false, dirname( plugin_basename(__FILE__) ) . '/languages' );
        // Load Shortcode
        $this->loadshortcodes(); 
	}
	function loadshortcodes() {
        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
            require_once(SNSVICKY_SHORTCODES_PATH . '/functions.php');
            foreach ($this->shortcodes as $shortcode) {
                if ( file_exists(SNSVICKY_SHORTCODES_PATH . '/shortcodes/' . $shortcode . '.php') ) 
                	require_once(SNSVICKY_SHORTCODES_PATH . '/shortcodes/' . $shortcode . '.php');
            }
            include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
                foreach ($this->shortcodes_woo as $shortcode_woo) {
                    if ( file_exists(SNSVICKY_SHORTCODES_PATH . '/shortcodes-woo/' . $shortcode_woo . '.php') ) 
                    	require_once(SNSVICKY_SHORTCODES_PATH . '/shortcodes-woo/' . $shortcode_woo . '.php');
                }
                // Ajaxtab
                add_action('wp_ajax_sns_products_ajaxtab', array(&$this, 'snsvicky_content_tab_products'));
                add_action('wp_ajax_nopriv_sns_products_ajaxtab', array(&$this, 'snsvicky_content_tab_products'));
            }
        }
    }
    function snsvicky_content_tab_products(){
        $tab_args = array(
            'box_id'              => $_POST['box_id'],
            'tab_content_id'      => $_POST['tab_content_id'],
            'cat'                 => $_POST['cat'],
            'order'               => $_POST['order'],
            'limit'               => $_POST['limit'],
            'uq'                  => $_POST['uq'],
            'effect'              => $_POST['effect'],
            'gridstyle'           => $_POST['gridstyle'],
            'eclass'              => $_POST['eclass'],
            'row'                 => $_POST['row'],
        );
        include snsvicky_shortcode_woo_template('product-tab/tab-content');
        wp_die();
    }
}
// Finally initialize code
new SNSVICKY_Shortcodes_Class();