<?php
/*
Plugin Name: SNS VICKY Extra
Plugin URI: http://snstheme.com
Description: Extra some featured for SNS VICKY theme.
Version: 1.1
Author URI: http://snstheme.com
License: GPL2+
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

// Begin: Define Post Type: post-wcode
class SNSVICKY_PostWCode{
	function __construct(){
		// Load text domain
        load_plugin_textdomain( 'snsvicky-extra', false, dirname( plugin_basename(__FILE__) ) . '/languages' );
		add_action('init', array($this,'addPostWCodeType'));
	}
	function addPostWCodeType(){
		$labels = array(
			'name' => __( 'Post WCode', 'snsvicky-extra' ),
			'singular_name' => __( 'Post WCode', 'snsvicky-extra' ),
			'add_new' => __( 'Add New Post WCode', 'snsvicky-extra' ),
			'add_new_item' => __( 'Add New Post WCode', 'snsvicky-extra' ),
			'edit_item' => __( 'Edit Post WCode', 'snsvicky-extra' ),
			'new_item' => __( 'New Post WCode', 'snsvicky-extra' ),
			'view_item' => __( 'View Post WCode', 'snsvicky-extra' ),
			'search_items' => __( 'Search Post WCode', 'snsvicky-extra' ),
			'not_found' => __( 'No Post WCode found', 'snsvicky-extra' ),
			'not_found_in_trash' => __( 'No Post WCode found in Trash', 'snsvicky-extra' ),
			'parent_item_colon' => __( 'Parent Post WCode:', 'snsvicky-extra' ),
			'menu_name' => __( 'Post WCode', 'snsvicky-extra' ),
		);

		$args = array(
		    'labels' => $labels,
		    'exclude_from_search' => true,
            'has_archive' => false,
            'public' => true,
            'menu_icon'   => 'dashicons-media-code',
            'rewrite' => true,
            'supports' => array('title', 'editor'),
            'can_export' => true,
            'show_in_nav_menus' => false
		);
		register_post_type( 'post-wcode', $args );
	}
}
function snsvicky_load_postwcode(){
	global $snsvicky_postwcode;
	$snsvicky_postwcode = new SNSVICKY_PostWCode();
}
add_action( 'plugins_loaded', 'snsvicky_load_postwcode' );
// End: Define Post Type: post-code
// Begin: Define widget
class SNSVICKY_Widget_PostWCode extends WP_Widget {
    public function __construct() {
        parent::__construct(
			'postcode-widget',
			esc_html__( 'Post WCode', 'snsvicky-extra' ),
			array( "description" => esc_html__("Display somes shortcodes via slug of Post WCode", 'snsvicky-extra') )
		);
	}
	function widget($args, $instance) {
		extract($args);
        $title = '';
        if (isset($instance['title']))
		    $title = apply_filters('widget_title', $instance['title']);
        $output = '';
        if ($instance['name']) {
            $output = do_shortcode('[snsvicky_postwcode name="' . $instance['name'] . '"]');
        }
        if (!$output) return;
        //echo $before_widget;
		if ($title) {
			echo $before_title . $title . $after_title;
		}
        echo $output;
        //echo $after_widget;
	}
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['name'] = $new_instance['name'];
		return $instance;
	}
	function form($instance) {
		$defaults = array();
		$instance = wp_parse_args((array) $instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'snsvicky-extra'); ?>
                <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php if (isset($instance['title'])) echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('name'); ?>">
                <?php esc_html_e('Slug of Post WCode:', 'snsvicky-extra'); ?>
                <input type="text" class="widefat" id="<?php echo $this->get_field_id('name'); ?>" name="<?php echo $this->get_field_name('name'); ?>" value="<?php if (isset($instance['name'])) echo $instance['name']; ?>" />
            </label>
        </p>
	    <?php
	}
}
function snsvicky_load_widgets() {
    register_widget( 'SNSVICKY_Widget_PostWCode');
}
add_action('widgets_init', 'snsvicky_load_widgets');
// End: Define widget
// Add Custom CSS for snsvicky_postwcode
add_action( 'wp_head', 'snsvicky_load_postwcode_css', 1000 );
function snsvicky_load_postwcode_css(){
	$args = array(
			'post_type' => 'post-wcode',
			'post_status' => 'publish', 
			'posts_per_page' => -1
	);
	$wcode = new WP_Query($args);
	$output = '';
	$output .= '<style type="text/css">';
	if ( $wcode->have_posts() ) {
		while ( $wcode->have_posts() ) { // echo '->'.get_the_ID().'<br/>';
			$wcode->the_post();
			$wcode_css = get_post_meta( get_the_ID(), '_wpb_post_custom_css', true );
			$wcode_css .= get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		    if ( ! empty( $wcode_css ) ) {
		        $output .= $wcode_css;
		    }
		}
	}
    $output .= '</style>';
    wp_reset_postdata();
    echo $output;
}