<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <h1 class="post-title">
        <?php the_title(); ?>
    </h1>
    <div class="post-meta">
        <span class="post-author">
        <?php
        printf( wp_kses(__( '<a class="author-link" href="%s" ref="author">%s</a>', 'snsvicky' ), array(
                                    'a' => array(
                                        'href' => array(),
                                        'class' => array(),
                                        'ref' => array()
                                    ),
                                    ) ), esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),  get_the_author_meta('display_name') ); ?>
        </span>
        <?php
        // Date
        printf( '<span class="entry-date"><a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a></span>',
            get_permalink(),
            esc_attr( get_the_date( 'c' ) ),
            get_the_date()
        );
        ?>
        <?php
        // Edit link
        edit_post_link(esc_html__('Edit','snsvicky'), '<span class="edit-post">', '</span>'); ?>
    </div>
    <?php
    // Post Quote
    if ( get_post_format() == 'quote' && function_exists('rwmb_meta') && rwmb_meta('snsvicky_post_quotecontent') && rwmb_meta('snsvicky_post_quoteauthor') ) :
        $uq  = rand().time();
        ?>
        <div class="quote-info quote-info-<?php echo $uq; ?> post-thumb">
            <?php if ( rwmb_meta('snsvicky_post_quotecontent') ) : ?>
            <div class="quote-content gfont"><?php echo esc_html(rwmb_meta('snsvicky_post_quotecontent')); ?></div>
            <?php endif; ?>
             <?php if ( rwmb_meta('snsvicky_post_quoteauthor') ) : ?>
            <div class="quote-author">- <?php echo esc_html(rwmb_meta('snsvicky_post_quoteauthor')); ?></div>
            <?php endif; ?>
        </div>
    <?php
    // Post Link
    elseif ( get_post_format() == 'link' && function_exists('rwmb_meta') && rwmb_meta('snsvicky_post_linkurl') ) : ?>
        <div class="link-info">
            <a class="gfont" title="<?php echo esc_attr(rwmb_meta('snsvicky_post_linktitle')) ?>" href="<?php echo esc_url( rwmb_meta('snsvicky_post_linkurl') ) ?>"><?php echo esc_html(rwmb_meta('snsvicky_post_linktitle')) ?></a>
        </div>
    <?php
    // Post Video
    elseif ( get_post_format() == 'video' && get_post_meta(get_the_id(), 'snsvicky_post_video', true) ) : ?>
        <div class="video-thumb video-responsive">
            <?php
            echo wp_oembed_get(esc_attr(get_post_meta(get_the_id(), 'snsvicky_post_video', true)));
            ?>
        </div>
    <?php
    // Post Audio
    elseif ( get_post_format() == 'audio' && get_post_meta(get_the_id(), 'snsvicky_post_audio', true) ) : ?>
        <div class="audio-thumb audio-responsive">
            <?php
            echo wp_oembed_get(esc_attr(get_post_meta(get_the_id(), 'snsvicky_post_audio', true)));
            ?>
        </div>
    <?php
    // Post Gallery
    elseif ( function_exists('rwmb_meta') && rwmb_meta('snsvicky_post_gallery') ) :
        wp_enqueue_script('owlcarousel');
    ?>
        <div class="gallery-thumb">
            <div class="thumb-container owl-carousel">
            <?php
            foreach (rwmb_meta('snsvicky_post_gallery', 'type=image') as $image) {?>
               <div class="item"><img alt="<?php echo esc_attr($image['alt']); ?>" src="<?php echo esc_attr($image['full_url']); ?>"/></div>
            <?php
            }
            ?>
            </div>
        </div>
    <?php
    // Post Image
    elseif ( has_post_thumbnail() ) : ?>
        <div class="post-thumb">
            <?php
           the_post_thumbnail();
            ?>
        </div>
    <?php
    endif;?>
    <div class="post-content">
        <div class="content">
            <?php 
            the_content();
            // Post Paging
            wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'snsvicky' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); 
            ?>
        </div>
    </div><!-- /.post-content -->
    <?php
    if ( snsvicky_themeoption('show_postsharebox') ) :
       snsvicky_sharebox();
    endif;
    ?>
    <?php
    if ( snsvicky_themeoption('show_postsharebox') || get_the_tag_list() ) :?>
    <div class="post-foot">
        <?php if( get_the_category_list() ):?>
            <div class="cat-links">
                <?php echo '<span>'. esc_html__('Category: ', 'snsvicky').'</span>'; ?>
                <?php echo get_the_category_list(); ?>
            </div>
        <?php endif;?>
        <?php if( get_the_tag_list() ): ?>
            <span class="tags-links">
                <span class="label-tag"><?php echo esc_html__( 'Tags: ', 'snsvicky' ); ?></span>
                <?php the_tags('', ', '); ?>
            </span>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <?php
    // Related post
    if ( snsvicky_themeoption('enalble_related', false) ) :
    ?>
    <div class="post-related">
        <?php snsvicky_relatedpost(); ?>
    </div>
    <?php
    endif;
    // Author bio
    if ( snsvicky_themeoption('show_postauthor') ) :
        get_template_part( 'author-bio' );
    endif;
    // Post navigation.
    snsvicky_post_nav();
    ?>
    <?php 
    // If comments are open or we have at least one comment, load up the comment template.
    if ( comments_open() || get_comments_number() ) :
    comments_template();
    endif;
    ?>
</article>