<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php $not_found_image = get_theme_mod('not_found_page_image'); ?>

<section id="content">
    <div class="container">
        <div class="row">

          <div class="col-md-12">
            <div class="row">

            <div class="not_found_wrapper <?php if (!$not_found_image) echo 'not_found_wo_img';  ?>">

                <div class="not_found_meta">
                    <?php if ($not_found_image): ?>
                        <h1><?php echo gg_wrap_last_char(get_theme_mod('not_found_page_title', '404 Error'));?></h1>
                    <?php else: ?>
                        <h1><?php echo get_theme_mod('not_found_page_title', '404 Error'); ?></h1>
                    <?php endif; ?>

                    <?php if (get_theme_mod('not_found_page_search', 1) == 1) { ?> 
                    <p class="info-404"><?php echo esc_html(get_theme_mod('not_found_page_description', 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.')); ?></p>
                    <?php } ?>
                    <a class="link-404" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php _e('Go to homepage','okthemes'); ?></a>
                </div>

                <?php if ($not_found_image): ?>
                <div class="not_found_image">
                    <img src="<?php echo esc_url($not_found_image); ?>" alt="<?php echo esc_attr( get_bloginfo('name','display') ); ?>" />
                </div>
                <?php endif; ?>
            
            </div><!-- /.not_found_wrapper -->

            </div>
          </div>

        </div><!-- /.row .content -->
    </div><!--/.container -->    
</section>

<?php get_footer();
