<?php
// Add Custom Controls
require_once PARENT_DIR . '/admin/customizer/layout/pattern-picker-custom-control.php';
require_once PARENT_DIR . '/admin/customizer/text/textarea-custom-control.php';
require_once PARENT_DIR . '/admin/customizer/text/separator-custom-control.php';
require_once PARENT_DIR . '/admin/customizer/select/google-font-dropdown-custom-control.php';
require_once PARENT_DIR . '/admin/customizer/google-fonts.php';
require_once PARENT_DIR . '/admin/customizer/system-fonts.php';
require_once PARENT_DIR . '/admin/customizer/patterns.php';
require_once PARENT_DIR . '/admin/customizer/font-weights.php';
require_once PARENT_DIR . '/admin/importer/init.php';

add_action( 'customize_register', 'options_theme_customizer_register' );
function options_theme_customizer_register($wp_customize) {

	/**
	 * Layout section
	 */
    $wp_customize->add_section(
        'layout_section',
        array(
            'title' => 'General &amp; Layout',
            'description' => 'Various layout options.',
            'priority' => 1,
        )
    );

		/* Site preloader */
    	$wp_customize->add_setting(
		    'site_preloader',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'site_preloader',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/disable the site preloader?',
		        'section' => 'layout_section',
		        'priority' => 1,
		        'settings'   => 'site_preloader',
		    )
		);

		/* Sticky menu */
    	$wp_customize->add_setting(
		    'sticky_menu',
		    array(
		        'default' => '0',
		    )
		);
		$wp_customize->add_control(
		    'sticky_menu',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/disable sticky menu?',
		        'section' => 'layout_section',
		        'priority' => 3,
		        'settings'   => 'sticky_menu',
		    )
		);

	/**
	 * Logo section
	 */
    $wp_customize->add_section(
        'logos_section',
        array(
            'title' => 'Logos',
            'description' => 'Upload theme logos',
            'priority' => 2,
        )
    );
    	/* Tagline check */
    	$wp_customize->add_setting(
		    'tagline_check',
		    array(
		        'default' => true,
		    )
		);
		$wp_customize->add_control(
		    'tagline_check',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Display site tagline?',
		        'section' => 'title_tagline',
		        'settings'   => 'tagline_check',
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('logo_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'logo_separator',
		        array(
			        'section' => 'logos_section',
			        'priority' => 1,
		        )
		    )
		);
    	/* Main logo check */
    	$wp_customize->add_setting(
		    'logo_check',
		    array(
		        'default' => false,
		    )
		);
		$wp_customize->add_control(
		    'logo_check',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Display a custom image/logo image in place of title header. For retina display please upload the logo at twice the normal size.',
		        'section' => 'logos_section',
		        'priority' => 1,
		        'settings'   => 'logo_check',
		    )
		);
		
    	/* Main logo */
    	$wp_customize->add_setting(
		    'main_logo',
		    array(
		        'default'      => ''
		    )
		);
		$wp_customize->add_control(
		    new WP_Customize_Image_Control(
		        $wp_customize,
		        'main_logo',
		        array(
		            'label'    => 'Logo',
		            'settings' => 'main_logo',
		            'section'  => 'logos_section',
		            'priority' => 2,
		        )
		    )
		);
		
		/* Logo width */
		$wp_customize->add_setting(
		    'logo_width',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'logo_width',
		    array(
		        'label' => 'Logo width',
		        'section' => 'logos_section',
		        'type' => 'text',
		        'priority' => 3,
		    )
		);

		/* Logo height */
		$wp_customize->add_setting(
		    'logo_height',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'logo_height',
		    array(
		        'label' => 'Logo height',
		        'section' => 'logos_section',
		        'type' => 'text',
		        'priority' => 4,
		    )
		);

		/* Logo margin-top */
		$wp_customize->add_setting(
		    'logo_margin_top',
		    array(
		        'default' => '0',
		    )
		);
		$wp_customize->add_control(
		    'logo_margin_top',
		    array(
		        'label' => 'Logo margin top (in px)',
		        'section' => 'logos_section',
		        'type' => 'text',
		        'priority' => 5,
		    )
		);

		/* Main logo retina */
    	$wp_customize->add_setting(
		    'main_logo_retina',
		    array(
		        'default'      => ''
		    )
		);
		$wp_customize->add_control(
		    new WP_Customize_Image_Control(
		        $wp_customize,
		        'main_logo_retina',
		        array(
		            'label'    => 'Retina Logo (@2x)',
		            'settings' => 'main_logo_retina',
		            'section'  => 'logos_section',
		            'priority' => 6,
		        )
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('admin_logo_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'admin_logo_separator',
		        array(
			        'section' => 'logos_section',
			        'priority' => 7,
		        )
		    )
		);

		/* WP admin logo check */
    	$wp_customize->add_setting(
		    'admin_logo_check',
		    array(
		        'default' => false,
		    )
		);
		$wp_customize->add_control(
		    'admin_logo_check',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Display a custom image/logo on the wp admin login area.',
		        'section' => 'logos_section',
		        'priority' => 8,
		    )
		);
		/* WP admin logo */
    	$wp_customize->add_setting(
		    'admin_logo',
		    array(
		        'default'      => ''
		    )
		);
		$wp_customize->add_control(
		    new WP_Customize_Image_Control(
		        $wp_customize,
		        'admin_logo',
		        array(
		            'label'    => 'WP Admin Logo',
		            'settings' => 'admin_logo',
		            'section'  => 'logos_section',
		            'priority' => 9,
		        )
		    )
		);
		
		/* WP Admin Logo width */
		$wp_customize->add_setting(
		    'admin_logo_width',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'admin_logo_width',
		    array(
		        'label' => 'WP Admin Logo width',
		        'section' => 'logos_section',
		        'type' => 'text',
		        'priority' => 10,
		    )
		);

		/* WP Admin Logo height */
		$wp_customize->add_setting(
		    'admin_logo_height',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'admin_logo_height',
		    array(
		        'label' => 'WP Admin Logo height',
		        'section' => 'logos_section',
		        'type' => 'text',
		        'priority' => 11,
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('favicon_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'favicon_separator',
		        array(
			        'section' => 'logos_section',
			        'priority' => 12,
		        )
		    )
		);

		/* Favicon logo */
    	$wp_customize->add_setting(
		    'favicon_logo',
		    array(
		        'default'      => ''
		    )
		);
		$wp_customize->add_control(
		    new WP_Customize_Image_Control (
		        $wp_customize,
		        'favicon_logo',
		        array(
		            'label'    => 'Favicon Logo (16x16px)',
		            'settings' => 'favicon_logo',
		            'section'  => 'logos_section',
		            'priority' => 13,
		        )
		    )
		);

	/**
	 * Header section
	 */
    $wp_customize->add_section(
        'header_section',
        array(
            'title' => 'Header',
            'description' => 'Various header options.',
            'priority' => 3,
        )
    );

		/* Header cart */
    	$wp_customize->add_setting(
		    'header_cart',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'header_cart',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable header cart.',
		        'section' => 'header_section',
		        'priority' => 1,
		    )
		);
    	
		/* Header wishlist */
    	$wp_customize->add_setting(
		    'header_wishlist',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'header_wishlist',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable header wishlist.',
		        'section' => 'header_section',
		        'priority' => 2,
		    )
		);

		/* Header login_logout */
    	$wp_customize->add_setting(
		    'header_login_logout',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'header_login_logout',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable header login_logout.',
		        'section' => 'header_section',
		        'priority' => 3,
		    )
		);

		/* Search box */
    	$wp_customize->add_setting(
		    'header_search',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'header_search',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable header search for products.',
		        'section' => 'header_section',
		        'priority' => 4,
		    )
		);
		
		/* WPML language box */
    	$wp_customize->add_setting(
		    'header_wpml_box',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'header_wpml_box',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable header WPML language box. WPML plugin must be installed.',
		        'section' => 'header_section',
		        'priority' => 5,
		    )
		);

	/**
	 * Footer section
	 */
    $wp_customize->add_section(
        'footer_section',
        array(
            'title' => 'Footer',
            'description' => 'Various footer options.',
            'priority' => 999,
        )
    );
		/* Footer extras */
    	$wp_customize->add_setting(
		    'footer_extras',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'footer_extras',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable footer extras (Copyright).',
		        'section' => 'footer_section',
		        'priority' => 2,
		    )
		);
		/* Footer copyright */
		$wp_customize->add_setting(
		    'footer_extras_copyright',
		    array(
		        'default' => 'Copyright 2014 - All rights reserved voux',
		    )
		);
		$wp_customize->add_control(
		    'footer_extras_copyright',
		    array(
		        'label' => 'Footer copyright',
		        'section' => 'footer_section',
		        'type' => 'text',
		        'priority' => 3,
		    )
		);

	/**
	 * API section
	 */
    $wp_customize->add_section(
        'api_section',
        array(
            'title' => 'Google API',
            'description' => 'Add your Google API key for the contact page map',
            'priority' => 999,
        )
    );
		$wp_customize->add_setting(
		    'google_api_key',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'google_api_key',
		    array(
		        'label' => 'Key',
		        'section' => 'api_section',
		        'type' => 'text',
		        'priority' => 1,
		    )
		);

	/**
	 * Comments section
	 */
    $wp_customize->add_section(
        'comments_section',
        array(
            'title' => 'Comments',
            'description' => 'Choose to enable/disable comments on all pages or posts.',
            'priority' => 998,
        )
    );
    	/* Page comments */
    	$wp_customize->add_setting(
		    'general_page_comments'
		);
		$wp_customize->add_control(
		    'general_page_comments',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable comments on all pages.',
		        'section' => 'comments_section',
		        'priority' => 1,
		    )
		);
		/* Posts comments */
    	$wp_customize->add_setting(
		    'general_post_comments',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'general_post_comments',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable comments on all posts..',
		        'section' => 'comments_section',
		        'priority' => 2,
		    )
		);

	/**
	 * Custom CSS section
	 */
    $wp_customize->add_section(
        'css_section',
        array(
            'title' => 'Custom CSS',
            'description' => 'Your custom CSS goes here. Do not include the style tag.This is already done for you.',
            'priority' => 998,
        )
    );
		
		$wp_customize->add_setting( 
			'custom_css' 
		);
		$wp_customize->add_control(
		    new Textarea_Custom_Control(
		        $wp_customize,
		        'custom_css',
		        array(
		            'label' => 'CSS',
		            'section' => 'css_section',
		            'priority' => 1
		        )
		    )
		);

	/**
	 * Custom Scripts section
	 */
    $wp_customize->add_section(
        'js_section',
        array(
            'title' => 'Custom Scripts',
            'description' => 'Add custom footer scripts such as Google Analytics. Do not include the script tag. This is already done for you.',
            'priority' => 997,
        )
    );
		
		$wp_customize->add_setting( 
			'custom_js' 
		);
		$wp_customize->add_control(
		    new Textarea_Custom_Control(
		        $wp_customize,
		        'custom_js',
		        array(
		            'label' => 'JS',
		            'section' => 'js_section',
		            'priority' => 1
		        )
		    )
		);

	/**
	 * Store section
	 */
    $wp_customize->add_section(
        'store_section',
        array(
            'title' => 'Store',
            'description' => 'Customize store. WooCommerce plugin must be installed.',
            'priority' => 4,
        )
    );
    	/* Separator */
    	$wp_customize->add_setting('general_store_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'general_store_separator',
		        array(
		        	'label' => 'General options',
			        'section' => 'store_section',
			        'priority' => 1,
		        )
		    )
		);
		/* Catalog mode */
    	$wp_customize->add_setting(
		    'store_catalog_mode'
		);
		$wp_customize->add_control(
		    'store_catalog_mode',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable catalog mode. This will disable: add to cart, checkout and buy functions.',
		        'section' => 'store_section',
		        'priority' => 2,
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('shop_store_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'shop_store_separator',
		        array(
		        	'label' => 'Shop options',
			        'section' => 'store_section',
			        'priority' => 3,
		        )
		    )
		);

		/* Shop product columns */
    	$wp_customize->add_setting(
		    'shop_product_columns',
		    array(
		        'default' => '3',
		    )
		);
		$wp_customize->add_control(
		    'shop_product_columns',
		    array(
		        'type' => 'select',
		        'label' => 'Shop product columns',
		        'section' => 'store_section',
		        'choices' => array(
		            '2' => '2 columns',
					'3' => '3 columns',
					'4' => '4 columns',
		        ),
		        'priority' => 4,
		    )
		);
		/* Number of products per page */
		$wp_customize->add_setting(
		    'product_per_page',
		    array(
		        'default' => '12',
		    )
		);
		$wp_customize->add_control(
		    'product_per_page',
		    array(
		        'label' => 'Number of products per page',
		        'section' => 'store_section',
		        'type' => 'text',
		        'priority' => 5,
		    )
		);
		/* Wishlist button */
    	$wp_customize->add_setting(
		    'store_add_to_wishlist',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'store_add_to_wishlist',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable wishlist button on product.',
		        'section' => 'store_section',
		        'priority' => 6,
		    )
		);

		/* Sale flash */
    	$wp_customize->add_setting(
		    'store_sale_flash',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'store_sale_flash',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable sale flash on products.',
		        'section' => 'store_section',
		        'priority' => 7,
		    )
		);
		/* Products price */
    	$wp_customize->add_setting(
		    'store_products_price',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'store_products_price',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable products price.',
		        'section' => 'store_section',
		        'priority' => 8,
		    )
		);
		/* Products Add to cart */
    	$wp_customize->add_setting(
		    'store_add_to_cart',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'store_add_to_cart',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable add to cart button.',
		        'section' => 'store_section',
		        'priority' => 9,
		    )
		);
		
		/* Separator */
    	$wp_customize->add_setting('product_store_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'product_store_separator',
		        array(
		        	'label' => 'Product options',
			        'section' => 'store_section',
			        'priority' => 10,
		        )
		    )
		);
		/* Sale flash */
    	$wp_customize->add_setting(
		    'product_sale_flash',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_sale_flash',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable sale flash on products.',
		        'section' => 'store_section',
		        'priority' => 12,
		    )
		);
		/* Products price */
    	$wp_customize->add_setting(
		    'product_products_price',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_products_price',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable products price.',
		        'section' => 'store_section',
		        'priority' => 13,
		    )
		);
		/* Product excerpt */
    	$wp_customize->add_setting(
		    'product_products_excerpt',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_products_excerpt',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable product excerpt(short description).',
		        'section' => 'store_section',
		        'priority' => 14,
		    )
		);
		/* Product meta */
    	$wp_customize->add_setting(
		    'product_products_meta',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_products_meta',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable product meta(sku, category, tag).',
		        'section' => 'store_section',
		        'priority' => 15,
		    )
		);
		/* Product add to cart */
    	$wp_customize->add_setting(
		    'product_add_to_cart',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_add_to_cart',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable add to cart button',
		        'section' => 'store_section',
		        'priority' => 16,
		    )
		);
		/* Product Related products*/
    	$wp_customize->add_setting(
		    'product_related_products',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_related_products',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable Related products',
		        'section' => 'store_section',
		        'priority' => 17,
		    )
		);
		/* Product Up sells products*/
    	$wp_customize->add_setting(
		    'product_upsells_products',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_upsells_products',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable Up Sells products',
		        'section' => 'store_section',
		        'priority' => 18,
		    )
		);
		/* Product Reviews tab */
    	$wp_customize->add_setting(
		    'product_reviews_tab',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_reviews_tab',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable reviews tab',
		        'section' => 'store_section',
		        'priority' => 19,
		    )
		);
		/* Product Description tab */
    	$wp_customize->add_setting(
		    'product_description_tab',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_description_tab',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable description tab',
		        'section' => 'store_section',
		        'priority' => 20,
		    )
		);
		/* Product Attributes tab */
    	$wp_customize->add_setting(
		    'product_attributes_tab',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_attributes_tab',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable attributes tab',
		        'section' => 'store_section',
		        'priority' => 21,
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('cart_store_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'cart_store_separator',
		        array(
		        	'label' => 'Cart options',
			        'section' => 'store_section',
			        'priority' => 22,
		        )
		    )
		);
		/* Cross Sells products */
    	$wp_customize->add_setting(
		    'product_crosssells_products',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'product_crosssells_products',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable Cross Sells products',
		        'section' => 'store_section',
		        'priority' => 23,
		    )
		);	

	/**
	 * Social Media section
	 */
    $wp_customize->add_section(
        'social_section',
        array(
            'title' => 'Social Media',
            'description' => 'Add your social icons.',
            'priority' => 996,
        )
    );
    	
		/* Facebook Link (Widget) */
		$wp_customize->add_setting(
		    'facebook_link'
		);
		$wp_customize->add_control(
		    'facebook_link',
		    array(
		        'label' => 'Facebook Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 3,
		    )
		);
		/* Facebook Link in header */
    	$wp_customize->add_setting(
		    'facebook_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'facebook_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 4,
		    )
		);

		/* Twitter Link (Widget) */
		$wp_customize->add_setting(
		    'twitter_link',
		    array(
		        'default' => 'okwpthemes',
		    )
		);
		$wp_customize->add_control(
		    'twitter_link',
		    array(
		        'label' => 'Twitter Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 5,
		    )
		);
		/* Twitter Link in header */
    	$wp_customize->add_setting(
		    'twitter_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'twitter_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 6,
		    )
		);
		/* Twitter Link (Widget) */
		$wp_customize->add_setting(
		    'twitter_link',
		    array(
		        'default' => 'okwpthemes',
		    )
		);
		$wp_customize->add_control(
		    'twitter_link',
		    array(
		        'label' => 'Twitter Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 5,
		    )
		);

		/* Skype Link (Widget) */
		$wp_customize->add_setting(
		    'skype_link'
		);
		$wp_customize->add_control(
		    'skype_link',
		    array(
		        'label' => 'Skype Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 7,
		    )
		);
		/* Skype Link in header */
    	$wp_customize->add_setting(
		    'skype_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'skype_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 8,
		    )
		);

		/* Vimeo Link (Widget) */
		$wp_customize->add_setting(
		    'vimeo_link'
		);
		$wp_customize->add_control(
		    'vimeo_link',
		    array(
		        'label' => 'Vimeo Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 9,
		    )
		);
		/* Vimeo Link in header */
    	$wp_customize->add_setting(
		    'vimeo_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'vimeo_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 10,
		    )
		);

		/* LinkedIn Link (Widget) */
		$wp_customize->add_setting(
		    'linkedin_link'
		);
		$wp_customize->add_control(
		    'linkedin_link',
		    array(
		        'label' => 'LinkedIn Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 11,
		    )
		);
		/* LinkedIn Link in header */
    	$wp_customize->add_setting(
		    'linkedin_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'linkedin_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 12,
		    )
		);

		/* Dribble Link (Widget) */
		$wp_customize->add_setting(
		    'dribble_link'
		);
		$wp_customize->add_control(
		    'dribble_link',
		    array(
		        'label' => 'Dribble Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 13,
		    )
		);
		/* Dribble Link in header */
    	$wp_customize->add_setting(
		    'dribble_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'dribble_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 14,
		    )
		);

		/* Forrst Link (Widget) */
		$wp_customize->add_setting(
		    'forrst_link'
		);
		$wp_customize->add_control(
		    'forrst_link',
		    array(
		        'label' => 'Forrst Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 15,
		    )
		);
		/* Forrst Link in header */
    	$wp_customize->add_setting(
		    'forrst_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'forrst_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 16,
		    )
		);

		/* Flickr Link (Widget) */
		$wp_customize->add_setting(
		    'flickr_link'
		);
		$wp_customize->add_control(
		    'flickr_link',
		    array(
		        'label' => 'Flickr Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 17,
		    )
		);
		/* Flickr Link in header */
    	$wp_customize->add_setting(
		    'flickr_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'flickr_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 18,
		    )
		);

		/* Google Link (Widget) */
		$wp_customize->add_setting(
		    'google_link'
		);
		$wp_customize->add_control(
		    'google_link',
		    array(
		        'label' => 'Google Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 19,
		    )
		);
		/* Google Link in header */
    	$wp_customize->add_setting(
		    'google_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'google_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 20,
		    )
		);

		/* Youtube Link (Widget) */
		$wp_customize->add_setting(
		    'youtube_link'
		);
		$wp_customize->add_control(
		    'youtube_link',
		    array(
		        'label' => 'Youtube Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 21,
		    )
		);
		/* Youtube Link in header */
    	$wp_customize->add_setting(
		    'youtube_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'youtube_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 22,
		    )
		);

		/* Tumblr Link (Widget) */
		$wp_customize->add_setting(
		    'tumblr_link'
		);
		$wp_customize->add_control(
		    'tumblr_link',
		    array(
		        'label' => 'Tumblr Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 23,
		    )
		);
		/* Tumblr Link in header */
    	$wp_customize->add_setting(
		    'tumblr_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'tumblr_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 24,
		    )
		);

		/* Pinterest Link (Widget) */
		$wp_customize->add_setting(
		    'pinterest_link',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'pinterest_link',
		    array(
		        'label' => 'Pinterest Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 25,
		    )
		);
		/* Pinterest Link in header */
    	$wp_customize->add_setting(
		    'pinterest_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'pinterest_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 26,
		    )
		);

		/* Deviantart Link (Widget) */
		$wp_customize->add_setting(
		    'deviantart_link',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'deviantart_link',
		    array(
		        'label' => 'deviantart Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 27,
		    )
		);
		/* Deviantart Link in header */
    	$wp_customize->add_setting(
		    'deviantart_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'deviantart_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 28,
		    )
		);

		/* Foursquare Link (Widget) */
		$wp_customize->add_setting(
		    'foursquare_link',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'foursquare_link',
		    array(
		        'label' => 'foursquare Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 29,
		    )
		);
		/* Foursquare Link in header */
    	$wp_customize->add_setting(
		    'foursquare_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'foursquare_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 30,
		    )
		);

		/* Github Link (Widget) */
		$wp_customize->add_setting(
		    'github_link',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'github_link',
		    array(
		        'label' => 'github Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 31,
		    )
		);
		/* Github Link in header */
    	$wp_customize->add_setting(
		    'github_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'github_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 32,
		    )
		);

		/* Instagram Link (Widget) */
		$wp_customize->add_setting(
		    'instagram_link',
		    array(
		        'default' => '',
		    )
		);
		$wp_customize->add_control(
		    'instagram_link',
		    array(
		        'label' => 'Instagram Link (Widget)',
		        'section' => 'social_section',
		        'type' => 'text',
		        'priority' => 33,
		    )
		);
		/* Instagram Link in header */
    	$wp_customize->add_setting(
		    'instagram_link_header',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'instagram_link_header',
		    array(
		        'type' => 'checkbox',
		        'label' => 'Enable/Disable icon in header',
		        'section' => 'social_section',
		        'priority' => 34,
		    )
		);

	/**
	 * Page templates section
	 */
    $wp_customize->add_section(
        'templates_section',
        array(
            'title' => 'Page templates',
            'description' => 'Customize the style of different pages',
            'priority' => 4,
        )
    );
    	/* Portfolio slug */
		$wp_customize->add_setting(
		    'portfolio_cpt_slug',
		    array(
		        'default' => 'portfolio-item',
		    )
		);
		$wp_customize->add_control(
		    'portfolio_cpt_slug',
		    array(
		        'label' => 'Portfolio slug',
		        'section' => 'templates_section',
		        'type' => 'text',
		        'priority' => 1,
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('portfolio_archive_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'portfolio_archive_separator',
		        array(
		        	'label' => 'Portfolio Category/Archive page',
			        'section' => 'templates_section',
			        'priority' => 2,
		        )
		    )
		);
		/* Category/archive portfolio layout */
    	$wp_customize->add_setting(
		    'archive_portfolio_page_style',
		    array(
		        'default' => 'fullwidth',
		    )
		);
		$wp_customize->add_control(
		    'archive_portfolio_page_style',
		    array(
		        'type' => 'select',
		        'label' => 'Category/archive portfolio layout',
		        'section' => 'templates_section',
		        'choices' => array(
		            'left' => 'Left sidebar',
					'right' => 'Right sidebar',
					'fullwidth' => 'Fullwidth',
		        ),
		        'priority' => 3,
		    )
		);
		/* Category/archive portfolio columns */
    	$wp_customize->add_setting(
		    'archive_portfolio_page_columns',
		    array(
		        'default' => 'three_columns',
		    )
		);
		$wp_customize->add_control(
		    'archive_portfolio_page_columns',
		    array(
		        'type' => 'select',
		        'label' => 'Category/archive portfolio columns',
		        'section' => 'templates_section',
		        'choices' => array(
		            'four_columns' => '4 Columns',
					'three_columns' => '3 Columns',
					'two_columns' => '2 Columns',
		        ),
		        'priority' => 4,
		    )
		);
		
		/* Separator */
    	$wp_customize->add_setting('portfolio_inner_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'portfolio_inner_separator',
		        array(
		        	'label' => 'Portfolio inner (single) page',
			        'section' => 'templates_section',
			        'priority' => 5,
		        )
		    )
		);
		
		/* Related posts */
    	$wp_customize->add_setting(
		    'portfolio_related_posts',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'portfolio_related_posts',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable related posts on portfolio inner page',
		        'section' => 'templates_section',
		        'priority' => 9,
		    )
		);
		/* Related posts title */
		$wp_customize->add_setting(
		    'portfolio_related_posts_title',
		    array(
		        'default' => 'Related posts',
		    )
		);
		$wp_customize->add_control(
		    'portfolio_related_posts_title',
		    array(
		        'label' => 'Related posts title',
		        'section' => 'templates_section',
		        'type' => 'text',
		        'priority' => 10,
		    )
		);
		/* Number of related posts to show */
    	$wp_customize->add_setting(
		    'portfolio_related_posts_number',
		    array(
		        'default' => '3',
		    )
		);
		$wp_customize->add_control(
		    'portfolio_related_posts_number',
		    array(
		        'type' => 'select',
		        'label' => 'Number of related posts to show',
		        'section' => 'templates_section',
		        'choices' => array(
		            '2' => '2',
					'3' => '3',
					'4' => '4',
		        ),
		        'priority' => 11,
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('blog_inner_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'blog_inner_separator',
		        array(
		        	'label' => 'Blog inner (single) page',
			        'section' => 'templates_section',
			        'priority' => 12,
		        )
		    )
		);
		
		
		/* Share box */
    	$wp_customize->add_setting(
		    'blog_share_box',
		    array(
		        'default' => '1',
		    )
		);
		$wp_customize->add_control(
		    'blog_share_box',
		    array(
		        'type' => 'checkbox',
		        'label' => ' Enable/Disable share box on blog inner page',
		        'section' => 'templates_section',
		        'priority' => 16,
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('blog_archive_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'blog_archive_separator',
		        array(
		        	'label' => 'Blog category/archive page',
			        'section' => 'templates_section',
			        'priority' => 17,
		        )
		    )
		);
		/* Category/archive page style */
    	$wp_customize->add_setting(
		    'archive_page_style',
		    array(
		        'default' => 'right',
		    )
		);
		$wp_customize->add_control(
		    'archive_page_style',
		    array(
		        'type' => 'select',
		        'label' => 'Category/Archive page style',
		        'section' => 'templates_section',
		        'choices' => array(
		            'left' => 'Left sidebar',
					'right' => 'Right sidebar',
					'fullwidth' => 'Fullwidth',
		        ),
		        'priority' => 18,
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('search_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'search_separator',
		        array(
		        	'label' => 'Search page',
			        'section' => 'templates_section',
			        'priority' => 19,
		        )
		    )
		);
		/* Search page style */
    	$wp_customize->add_setting(
		    'search_page_style',
		    array(
		        'default' => 'right',
		    )
		);
		$wp_customize->add_control(
		    'search_page_style',
		    array(
		        'type' => 'select',
		        'label' => 'Search page style',
		        'section' => 'templates_section',
		        'choices' => array(
		            'left' => 'Left sidebar',
					'right' => 'Right sidebar',
					'fullwidth' => 'Fullwidth',
		        ),
		        'priority' => 20,
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('not_found_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'not_found_separator',
		        array(
		        	'label' => '404 page',
			        'section' => 'templates_section',
			        'priority' => 21,
		        )
		    )
		);
		/* Not found title */
		$wp_customize->add_setting(
		    'not_found_page_title',
		    array(
		        'default' => '404 Error',
		    )
		);
		$wp_customize->add_control(
		    'not_found_page_title',
		    array(
		        'label' => 'Not found title',
		        'section' => 'templates_section',
		        'type' => 'text',
		        'priority' => 22,
		    )
		);
		/* Not found description */
		$wp_customize->add_setting( 
			'not_found_page_description',
			array(
		        'default' => 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching, or one of the links below, can help.',
		    ) 
		);
		$wp_customize->add_control(
		    new Textarea_Custom_Control(
		        $wp_customize,
		        'not_found_page_description',
		        array(
		            'label' => 'Not found description',
		            'section' => 'templates_section',
		            'priority' => 23
		        )
		    )
		);
		/* 404 image */
    	$wp_customize->add_setting(
		    'not_found_page_image',
		    array(
		        'default'      => ''
		    )
		);
		$wp_customize->add_control(
		    new WP_Customize_Image_Control(
		        $wp_customize,
		        'not_found_page_image',
		        array(
		            'label'    => '404 image',
		            'settings' => 'not_found_page_image',
		            'section'  => 'templates_section',
		            'priority' => 24,
		        )
		    )
		);

    	
		/* Primary color */
		$wp_customize->add_setting(
		    'primary-color',
		    array(
		        'default' => '#1c1c1c',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'primary-color',
		        array(
		            'label' => 'Primary color',
		            'section' => 'colors',
		            'settings' => 'primary-color',
		            'priority' => 1,
		        )
		    )
		);

		/* Secondary color */
		$wp_customize->add_setting(
		    'secondary-color',
		    array(
		        'default' => '#f7f7f7',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'secondary-color',
		        array(
		            'label' => 'Secondary color',
		            'section' => 'colors',
		            'settings' => 'secondary-color',
		            'priority' => 3,
		        )
		    )
		);

		/* Separator */
    	$wp_customize->add_setting('font_colors_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'font_colors_separator',
		        array(
		        	'label' => 'Font colors',
			        'section' => 'colors',
			        'priority' => 7,
		        )
		    )
		);

		/* Text color */
		$wp_customize->add_setting(
		    'text-color',
		    array(
		        'default' => '#828282',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'text-color',
		        array(
		            'label' => 'Text color',
		            'section' => 'colors',
		            'settings' => 'text-color',
		            'priority' => 8,
		        )
		    )
		);

		/* Link color */
		$wp_customize->add_setting(
		    'link-color',
		    array(
		        'default' => '#1c1c1c',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'link-color',
		        array(
		            'label' => 'Link color',
		            'section' => 'colors',
		            'settings' => 'link-color',
		            'priority' => 9,
		        )
		    )
		);

		/* Headings color */
		$wp_customize->add_setting(
		    'headings-color',
		    array(
		        'default' => '#1c1c1c',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'headings-color',
		        array(
		            'label' => 'Headings color',
		            'section' => 'colors',
		            'settings' => 'headings-color',
		            'priority' => 10,
		        )
		    )
		);

		/* Menu color */
		$wp_customize->add_setting(
		    'menu-color',
		    array(
		        'default' => '#1c1c1c',
		        'sanitize_callback' => 'sanitize_hex_color'
		    )
		);

		$wp_customize->add_control(
		    new WP_Customize_Color_Control(
		        $wp_customize,
		        'menu-color',
		        array(
		            'label' => 'Menu/Footer color',
		            'section' => 'colors',
		            'settings' => 'menu-color',
		            'priority' => 11,
		        )
		    )
		);
		/* Separator */
    	$wp_customize->add_setting('background_color_separator');
		$wp_customize->add_control(
		    new Separator_Custom_Control(
		        $wp_customize,
		        'background_color_separator',
		        array(
		        	'label' => 'Background color',
			        'section' => 'colors',
			        'priority' => 13,
		        )
		    )
		);

	/**
	 * Fonts section
	 */
	global $fontWeightsArrays;

    $wp_customize->add_section(
        'fonts_section',
        array(
            'title' => 'Fonts',
            'description' => 'You have the possibility to select from 650 google fonts and from 6 system fonts (you find them at the beginning of the list).',
            'priority' => 5,
        )
    );
        
        $wp_customize->add_setting( 
        	'gg_font', 
        	array(
            	'default' => 'Montserrat',
        	) 
        );
        $wp_customize->add_control( 
        	new Google_Font_Dropdown_Custom_Control( 
        		$wp_customize, 
        		'gg_font', 
        		array(
		            'label'   => 'Font family. Default: Montserrat',
		            'section' => 'fonts_section',
		            'settings'   => 'gg_font',
		            'priority' => 1,
		        ) 
		    )
		);

		$wp_customize->add_setting( 
        	'gg_font_style', 
        	array(
            	'default' => '400',
        	) 
        );
		$wp_customize->add_control(
		    'gg_font_style',
		    array(
		        'type' => 'select',
		        'label' => 'Body font style. Default: 400 (Normal)',
		        'section' => 'fonts_section',
		        'choices' => $fontWeightsArrays,
		        'priority' => 2,
		    )
		);

	/**
	 * Background section
	 */
	$wp_customize->get_section('background_image')->title = __( 'Background', 'okthemes');

		/* Select background type */
    	$wp_customize->add_setting(
		    'background_type_select',
		    array(
		        'default' => 'none',
		    )
		);
		$wp_customize->add_control(
		    'background_type_select',
		    array(
		        'type' => 'select',
		        'label' => 'Background type',
		        'section' => 'background_image',
		        'choices' => array(
		        	'none' => 'None',
		            'image' => 'Background image',
					'pattern' => 'Background pattern'
		        ),
		        'priority' => 1,
		    )
		);

		/* Patterns */
    	$wp_customize->add_setting('background_type_patterns');
		$wp_customize->add_control(
		    new Pattern_Picker_Custom_Control(
		        $wp_customize,
		        'background_type_patterns',
		        array(
		        	'label'   => 'Background pattern',
			        'section' => 'background_image',
			        'priority' => 3,
		        )
		    )
		);

}

/**
 * Registers the Theme Customizer Admin script with WordPress.
 */
function voux_customizer_scripts() {

	wp_enqueue_script(
		'voux-theme-customizer-admin',
		get_template_directory_uri() . '/admin/customizer/js/admin-theme-customizer.js',
		array( 'jquery' ),
		'NULL',
		true
	);

}
add_action( 'customize_controls_print_footer_scripts', 'voux_customizer_scripts' );


function voux_customizer_style()
{
    ?>
	<style type="text/css">
		
		hr {
			border-width: 8px;
			margin: 0;
		}
		.customizer-separator span.customize-control-title {
			background: #F7FCFE;
			font-size: 12px;
			text-align: center;
			color:#2EA2CC;
			padding: 8px 0;
			margin: 0;
		}
		.customize-layout-list ul li {
			display: inline-block;
		    text-align: center;
		    width: 78px;
		}
		.customize-layout-list ul li img{
			width: 100%;
		}
		#customize-control-background_type_patterns label {
			width: 50px;
			height: 50px;
			float: left;
			text-align: center;
		}

	</style>
    <?php
}

add_action( 'customize_controls_print_footer_scripts', 'voux_customizer_style');


function mytheme_customize_css()
{
    ?>

    <?php
    global $systemFontTrimmedArrays, $googleFontArrays, $paternArray;
    $gg_font = get_theme_mod('gg_font','Montserrat:400,700');
    $gg_font_trimmed = str_replace('+', ' ', $gg_font);
    $gg_font_clean = explode(":", $gg_font, 2);

    if ($gg_font == 'Montserrat') {
    	$gg_font = 'Montserrat:300,400,500,700';
    }

    ?>

	<?php if ( ! in_array( $gg_font_trimmed, $systemFontTrimmedArrays ) ) { ?>
		<link href='//fonts.googleapis.com/css?family=<?php echo esc_html($gg_font); ?>' rel='stylesheet' type='text/css'>
	<?php } ?>


	<style type="text/css">

		body {
			<?php if ( $gg_font != 'Montserrat' ) { ?>
			font-family: <?php echo str_replace('+', ' ', $gg_font_clean[0]); ?>;
			<?php } ?>

			font-weight: <?php echo str_replace('italic', '', get_theme_mod('gg_font_style','400')); ?>;
			<?php if (strpos(get_theme_mod('gg_font_style','400'), 'italic') !== false) echo "font-style:italic;"; else echo "font-style:normal;"; ?>
			
			<?php if (get_theme_mod('text-color','#828282') != '#828282') { ?>	
			color: <?php echo get_theme_mod('text-color','#828282'); ?>;
			<?php } ?>

			<?php 
			global $paternArray;
			if (get_theme_mod('background_type_select') == 'pattern') {
				$pattern = get_theme_mod('background_type_patterns');
				$pattern_url = $paternArray[$pattern];
			?>
			background: url('<?php echo esc_url( $pattern_url ); ?>') repeat left top !important;
			<?php } ?>
		}

		/* Body colors */
		<?php if (get_theme_mod('text-color','#828282') != '#828282') { ?>	
			#site-title small,
			aside .gg-widget,
			aside .gg-widget a,
			.el-grid article.post .meta,
			.el-grid article.post .meta a,
			.el-grid article.page .meta,
			.el-grid article.page .meta a,
			.el-grid article.portfolio_cpt .meta,
			.el-grid article.portfolio_cpt .meta a,
			#comments .comment .media-body p.meta,
			#comments .comment .media-body p.meta a,
			footer.site-footer.gg-light .footer-widgets,
			.woocommerce ul.products li .price,
			.woocommerce .el-grid.products div.product .price,
			.gg-widget.widget_product_categories ul.product-categories li.cat-parent ul.children li > a,
			.woocommerce .shop_table.cart td.actions .cart-collaterals .shipping-calculator-wrapper h2,
			.woocommerce .shop_table.cart td.actions .cart-collaterals .shipping-calculator-wrapper h2 a,
			.woocommerce .shop_table.cart td.actions .cart-collaterals .shipping .shipping-calculator-button,
			.woocommerce-tabs .tabs li a,
			.dropdown-menu > li > a,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li,
			.wpb-js-composer .wpb_content_element .wpb_tour_tabs_wrapper .wpb_tabs_nav a,
			.wpb-js-composer .wpb_content_element .wpb_accordion_header a,
			.featured-image-box figure.sadie p {
				color: <?php echo get_theme_mod('text-color','#828282'); ?>;
			}
		<?php } ?>

		/* Link colors */
		<?php if (get_theme_mod('link-color','#1c1c1c') != '#1c1c1c') { ?>
			
			a,
			a:hover, 
			a:focus,
			#site-title a.brand,
			#site-title,
			aside .gg-widget a:hover,
			.pagination > li > a:hover,
			.pagination > li > span:hover,
			.pagination > li > a:focus,
			.pagination > li > span:focus,
			.pagination > li span.current,
			.pagination > li.pull-left > a,
			.pagination > li.pull-left > span,
			.pagination > li.pull-right > a,
			.pagination > li.pull-right > span,
			footer.site-footer.gg-light .footer-widgets a,
			footer.site-footer.gg-light .footer-widgets a:hover,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li.ui-tabs-active a,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li:hover a,
			.gg_filter li a,
			.gg-widget.widget_product_categories ul.product-categories li > a:first-child,
			.gg-widget.widget_product_categories ul.product-categories li.current-cat a,
			.gg-widget.widget_product_categories ul.product-categories li.cat-parent ul.children li.current-cat > a,
			.woocommerce-tabs .tabs li.active a,
			.gg-woo-mini-cart li.cart_list_product a {
				color: <?php echo get_theme_mod('link-color','#1c1c1c'); ?>;
			}

			.pagination > li > a:hover,
			.pagination > li > span:hover,
			.pagination > li > a:focus,
			.pagination > li > span:focus,
			.gg_filter li.active a,
			.gg_filter li:hover a,
			.gg_filter li a:hover {
			  border-color: <?php echo get_theme_mod('link-color','#1c1c1c'); ?>;
			}

		<?php } ?>

		/* Menu - Footer colors */
		<?php if (get_theme_mod('menu-color','#1c1c1c') != '#1c1c1c') { ?>
			.dropdown-menu > li > a:hover,
			.dropdown-menu > li > a:focus,
			.dropdown-menu > .active > a,
			.dropdown-menu > .active > a:hover,
			.dropdown-menu > .active > a:focus,
			.dropdown-menu > li > .dropdown-menu > li > a:hover,
			.dropdown-menu > li > .dropdown-menu > li > a:focus,
			.dropdown-menu > li > .dropdown-menu > .active > a,
			.dropdown-menu > li > .dropdown-menu > .active > a:hover,
			.dropdown-menu > li > .dropdown-menu > .active > a:focus,
			.navbar-default .navbar-nav > li > a,
			.navbar-default .navbar-nav > .open > a,
			.navbar-default .navbar-nav > .open > a:hover,
			.navbar-default .navbar-nav > .open > a:focus,
			.navbar-default .navbar-nav > li > a:hover,
			.navbar-default .navbar-nav > li > a:focus,
			.navbar-default .navbar-nav > .active > a,
			.navbar-default .navbar-nav > .active > a:hover,
			.navbar-default .navbar-nav > .active > a:focus,
			footer.site-footer .footer-extras,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li.ui-tabs-active,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li:hover,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li.ui-tabs-active a,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li:hover a {
			  color: <?php echo get_theme_mod('menu-color','#1c1c1c'); ?>;
			}
		<?php } ?>

		/* Headings colors */
		<?php if (get_theme_mod('headings-color','#1c1c1c') != '#1c1c1c') { ?>
			h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6, .coming-soon-wrapper h2, footer.site-footer.gg-light .footer-widgets .gg-widget h4.widget-title, .vc_toggle .vc_toggle_title {
				color: <?php echo get_theme_mod('headings-color','#1c1c1c'); ?>;
			}
		<?php } ?>

		/* Primary colors */
		<?php if (get_theme_mod('primary-color','#1c1c1c') != '#1c1c1c') { ?>
			
			pre,
			label,
			.label,
			legend,
			.counter-holder .counter,
			.wpb-js-composer .vc_progress_bar .vc_single_bar .vc_label,
			.wpb-js-composer .vc_btn_outlined.vc_btn_voux-primary-color, 
			.wpb-js-composer a.vc_btn_outlined.vc_btn_voux-primary-color, 
			.wpb-js-composer button.vc_btn_outlined.vc_btn_voux-primary-color,
			.wpb-js-composer .vc_btn_square_outlined.vc_btn_voux-primary-color, 
			.wpb-js-composer a.vc_btn_square_outlined.vc_btn_voux-primary-color, 
			.wpb-js-composer button.vc_btn_square_outlined.vc_btn_voux-primary-color,
			.wpb-js-composer .vc_btn_voux-secondary-color, 
			.wpb-js-composer a.vc_btn_voux-secondary-color, 
			.wpb-js-composer button.vc_btn_voux-secondary-color,
			.featured-icon-box .vc_icon_element .vc_icon_element-icon,
			.vc_widget.vc_widget_twitter ul:before,
			.gg-vc-quote,
			#countdown .colored-letter,
			.coming-soon-wrapper .gg-newsletter-widget,
			p.demo_store,
			#reviews #comments .comment p.meta strong,
			#reviews #comments .comment .star-rating,
			.woocommerce form.woocommerce-ordering .bootstrap-select.open > .btn,
			.single-product.woocommerce .product .thumbnails #slider-prev,
			.single-product.woocommerce .product .thumbnails #slider-next,
			.product-image-wrapper .product-buttons-icns .product-icn,
			.product-image-wrapper .product-buttons-icns .product-icn a,
			.gg-widget.widget_shopping_cart li .quantity .amount,
			.gg-widget.widget_shopping_cart .total,
			.gg-widget.widget_shopping_cart li a,
			.gg-widget.widget_price_filter .price_slider_amount button,
			.woocommerce .shop_table.cart th,
			.woocommerce .shop_table.cart td.actions .cart-collaterals .cart_totals th,
			.woocommerce .shop_table.cart td.actions .cart-collaterals .cart_totals td,
			.woocommerce form.checkout #order_review .shop_table th,
			.woocommerce form.checkout #order_review .shop_table td,
			body.woocommerce-wishlist .wishlist_table tr td.product-stock-status span.wishlist-in-stock,
			.woocommerce ul.order_details li strong,
			.gg-woo-mini-cart li.cart_list_product .quantity .amount,
			.gg-woo-mini-cart li.total,
			.woocommerce-message,
			.woocommerce-error,
			.woocommerce-info,
			.slick-prev:before,
			.slick-next:before {
				color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>; 
			}

			.pace .pace-activity .gg-loader .circle {
				border-top-color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>;
			}
			.coming-soon-wrapper .gg-newsletter-widget {
				border-color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>;
			}

			footer.site-footer .footer-widgets,
			.wpb-js-composer .vc_toggle_default .vc_toggle_icon:before, 
			.wpb-js-composer .vc_toggle_default .vc_toggle_icon:after,
			.wpb-js-composer .vc_toggle_default .vc_toggle_icon,
			.featured-image-box figure.sadie,
			.product-image-wrapper .product-buttons-icns .product-icn:hover,
			.gg-widget.widget_price_filter .ui-slider-horizontal .ui-slider-range,
			.gg-woo-mini-cart li.buttons .minicart-btn.checkout,
			#timeline .radio:checked + .line .circle {
				background-color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>;
			}

			.btn-primary,
			.nav-links a,
			.wpb-js-composer .vc_btn_voux-primary-color, 
			.wpb-js-composer a.vc_btn_voux-primary-color, 
			.wpb-js-composer button.vc_btn_voux-primary-color,
			.coming-soon-wrapper .gg-newsletter-widget .btn.btn-primary,
			.woocommerce .product .summary .button,
			.woocommerce .place-order #place_order,
			.woocommerce .button.wc-forward,
			.woocommerce .shipping-calculator-form button.button,
			.btn-primary:hover,
			.btn-primary:focus,
			.btn-primary.focus,
			.btn-primary:active,
			.btn-primary.active,
			.open > .dropdown-toggle.btn-primary {
				border-color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>;
				background-color: <?php echo get_theme_mod('primary-color','#1c1c1c'); ?>;
			}

			footer.site-footer .footer-widgets {
				color: <?php echo gg_hex_shift( get_theme_mod('primary-color','#1c1c1c'), 'lighter', 60 ); ?>
			}


		<?php } ?>

		<?php if (get_theme_mod('secondary-color','#f7f7f7') != '#f7f7f7') { ?>
			
			.pace .pace-activity,
			.sticky,
			pre,
			.form-control,
			.navbar .navbar-nav,
			.flanker.dynamic-width,
			.dropdown-menu,
			.dropdown-menu > li > .dropdown-menu,
			.navbar-default .navbar-nav > .open > a,
			.navbar-default .navbar-nav > .open > a:hover,
			.navbar-default .navbar-nav > .open > a:focus,
			.counter-holder.is_box,
			.vc_toggle .vc_toggle_title,
			.wpb-js-composer .vc_call_to_action,
			p.demo_store,
			.woocommerce-tabs .tabs li a,
			.wpb-js-composer .wpb_content_element .wpb_tabs_nav li {
				background-color: <?php echo get_theme_mod('secondary-color','#f7f7f7'); ?>;
			}

			.form-control,
			.vc_toggle,
			.wpb-js-composer .vc_call_to_action {
				border-color: <?php echo get_theme_mod('secondary-color','#f7f7f7'); ?>; 
			}

		<?php } ?>


		<?php 
		//Always at the end of the file
		if (get_theme_mod('custom_css') != '') {
			echo get_theme_mod('custom_css');
		} 
		?>

	</style>
    <?php
}

if ( ! is_admin() ) {
	add_action( 'wp_head', 'mytheme_customize_css');
}


