<?php
require_once(  dirname( __FILE__ ) .'/importer/okthemes-importer.php' ); //load admin theme data importer

class OKThemes_Theme_Demo_Data_Importer extends OKThemes_Theme_Importer {

    /**
     * Holds a copy of the object for easy reference.
     *
     * @since 2.2.0
     *
     * @var object
     */
    private static $instance;
    
    /**
     * Set the key to be used to store theme options
     *
     * @since 2.2.0
     *
     * @var object
     */
  public $theme_option_name = 'my_theme_options'; //set theme options name here
		
	public $theme_options_file_name = 'theme_options.txt';
  //public $theme_options_file_name = 'theme_options.json';
	
	public $widgets_file_name 		=  'widgets.json';
	
	public $content_demo_file_name  =  'content.xml';
	
	/**
	 * Holds a copy of the widget settings 
	 *
	 * @since 2.2.0
	 *
	 * @var object
	 */
	public $widget_import_results;
	
    /**
     * Constructor. Hooks all interactions to initialize the class.
     *
     * @since 2.2.0
     */
    public function __construct() {
    
		$this->demo_files_path = dirname(__FILE__) . '/demo-files/';

        self::$instance = $this;
		parent::__construct();

    }

	public function set_demo_menus(){

		// Menus to Import and assign - you can remove or add as many as you want
		$main_menu = get_term_by('name', 'Header', 'nav_menu');
		$footer_menu = get_term_by('name', 'Footer', 'nav_menu');

		set_theme_mod( 'nav_menu_locations', array(
                'main-menu' => $main_menu->term_id,
                'footer-menu' => $footer_menu->term_id
            )
        );

	}

    public function remove_hello_post(){

        //Remove the hello world post
        wp_delete_post(1);
    }

    public function set_page_options(){

        //Set the frontpage and the blog page
        $frontpage = get_page('2091');
        $blogpage = get_page('703');

        update_option('show_on_front', 'page');    // show on front a static page
        update_option('page_on_front', $frontpage->ID);
        update_option('page_for_posts', $blogpage->ID);

    }

    public function set_woocommerce_options(){

        //Set the woocommerce options
        if (is_woocommerce_activated()) {

            //Shop Page
            $shop_page = get_page_by_title('Shop');
            if($shop_page && $shop_page->ID){
              update_option('woocommerce_shop_page_id',$shop_page->ID);
            }
            
            //Cart Page
            $cart_page = get_page_by_title('Cart');
            if($cart_page && $cart_page->ID){
              update_option('woocommerce_cart_page_id',$cart_page->ID);
            }
            
            //Checkout Page
            $checkout_page = get_page_by_title('Checkout');
            if($checkout_page && $checkout_page->ID){
              update_option('woocommerce_checkout_page_id',$checkout_page->ID);
            }
            
            //My Account Page
            $myaccount_page = get_page_by_title('My Account');
            if($myaccount_page && $myaccount_page->ID){
              update_option('woocommerce_myaccount_page_id',$myaccount_page->ID);
            }

            //Wishlist Page
            $wishlist_page = get_page_by_title('Wishlist');
            if($wishlist_page && $wishlist_page->ID){
              update_option('yith_wcwl_wishlist_page_id',$wishlist_page->ID);
            }
            
            //Set image sizes    
            $catalog = array(
                'width'     => '540',   // px
                'height'    => '800',   // px
                'crop'      => 1        // true
            );
         
            $single = array(
                'width'     => '570',   // px
                'height'    => '830',   // px
                'crop'      => 1        // true
            );
         
            $thumbnail = array(
                'width'     => '70',   // px
                'height'    => '100',   // px
                'crop'      => 1        // false
            );

            // Image sizes
            update_option( 'shop_catalog_image_size', $catalog );   // Product category thumbs
            update_option( 'shop_single_image_size', $single );     // Single product image
            update_option( 'shop_thumbnail_image_size', $thumbnail );
            //Remove notice
            remove_action( 'admin_notices', 'update_notice' );

            //Update permalinks
            global $wp_rewrite;
            $wp_rewrite->set_permalink_structure('/%postname%/');

        } else {
            echo '<p>WooCommerce is not installed. The corresponding settings were not applied.</p>';
        }

    }

    public function set_revslider_options(){

        //Set the revolution slider

        if( class_exists('RevSlider') ) {
           
            $slider_array = array(
                get_template_directory()."/admin/importer/demo-files/demo-sliders/home_v1.zip",
                get_template_directory()."/admin/importer/demo-files/demo-sliders/home_v2.zip",
                get_template_directory()."/admin/importer/demo-files/demo-sliders/home_v3.zip",
                get_template_directory()."/admin/importer/demo-files/demo-sliders/home_v4.zip",
                get_template_directory()."/admin/importer/demo-files/demo-sliders/home_v6.zip"
            );

            $slider = new RevSlider();
             
            foreach($slider_array as $filepath){
                $slider->importSliderFromPost(false,false,$filepath);
            }
            

            echo ' Slider imported';
            
        } else {
            echo '<p>Revolution Slider is not installed. The corresponding settings were not applied.</p>';
        }
        

    }

}

new OKThemes_Theme_Demo_Data_Importer;