<?php
/**
 * The template for displaying Archive pages.
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php
$archive_layout = get_theme_mod('archive_page_style','right');
switch ($archive_layout) {
    case "left":
        $archive_content_class = 'col-xs-12 col-md-9 pull-right';
        $archive_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        $archive_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;
    case "right":
        $archive_content_class = 'col-xs-12 col-md-9 pull-left';
        $archive_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        $archive_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;
    case "fullwidth":
        $archive_content_class = 'col-xs-12 col-md-12';
        $archive_sidebar_class = 'col-xs-12 col-md-12';
        $archive_col_class     = 'col-xs-12 col-sm-6 col-md-4';
        break; 
    case NULL:
        $archive_content_class = 'col-xs-12 col-md-9 pull-left';
        $archive_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        $archive_col_class     = 'col-xs-12 col-sm-6 col-md-6';
        break;       
}

wp_enqueue_style('isotope');
wp_enqueue_script( 'gg-isotope' );

?>

    <?php if (have_posts()) :
    // Queue the first post.
    the_post(); ?>

    <section id="content">
        <div class="container">

            <?php if ( $archive_layout == 'fullwidth' ) : ?> 
            <div class="gg-content-separator"></div>
            <?php endif; //Apply full width border ?>

            <div class="row">
                <div class="<?php echo esc_attr($archive_content_class); ?>">

                    <?php if ( $archive_layout != 'fullwidth' ) : ?> 
                    <div class="gg-content-separator"></div>
                    <?php endif; //Apply content border ?>

                    <?php
                    // Rewind the loop back
                        rewind_posts();
                    ?>

                    <div class="gg_posts_grid">
                        <ul class="el-grid" data-layout-mode="fitRows" data-gap="gap">
                        <?php while (have_posts()) : the_post(); ?>
                            <li class="isotope-item <?php echo esc_attr($archive_col_class); ?>"><?php get_template_part( 'parts/part', get_post_format() ); ?></li>
                        <?php endwhile; ?>
                        </ul>
                    </div>

                    <?php if (function_exists("gg_pagination")) {
                        gg_pagination($wp_query->max_num_pages);
                    } ?>

                <?php endif; ?>
                </div>
                
                <?php if ($archive_layout !='fullwidth') { ?>
                <div class="<?php echo esc_attr($archive_sidebar_class); ?>">
                    <aside class="sidebar-nav">
                        <?php get_sidebar(); ?>
                    </aside>
                    <!--/aside .sidebar-nav -->
                </div><!-- /.col-3 col-sm-3 col-lg-3 -->
                <?php } ?>

            </div><!-- /.row -->
        </div><!-- /.row .container -->
    </section>
<?php get_footer(); ?>