<?php
/**
 * Footer
 *
 * @package WordPress
 * @subpackage voux
 */
?>

        <?php if (!is_page_template('theme-templates/coming-soon.php')) : ?>

        <?php
            $post_id = gg_global_page_id();
            $footer_style = _get_field('gg_page_footer_style',$post_id);

            if ($footer_style) {
                $footer_style_cls = $footer_style;
            } else {
                $footer_style_cls = 'dark';
            }
        ?>

        <footer class="site-footer <?php echo 'gg-'.esc_attr($footer_style_cls); ?>">

            <?php gg_footer_social(); ?>

            <?php if( 1 == get_theme_mod( 'footer_widgets' , 1) ) { ?>
            <div class="footer-widgets">
                <div class="container">
                    <?php get_sidebar("footer"); ?>
                </div><!-- /container -->
            </div>
            <?php } ?>

            <?php if( 1 == get_theme_mod( 'footer_extras', 1 ) ) { ?>
            <div class="footer-extras">
                <div class="container">
                    <div class="row">

                        <?php
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'footer-menu',
                                'container'         => 'div',
                                'container_class'   => 'col-xs-12 col-sm-6 col-md-8',
                                'menu_class'        => 'nav navbar-nav',
                                'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                'menu_id'           => 'footer-menu',
                                'depth'             => -1,
                                'walker'            => new wp_bootstrap_navwalker()
                            )
                        ); ?>

                        <?php if (get_theme_mod( 'footer_extras_copyright','Copyright 2014 - All rights reserved voux') != '') { ?>
                        <div class="col-xs-12 col-sm-6 col-md-4 gg-copyright-wrapper">
                            <p><?php echo esc_html(get_theme_mod('footer_extras_copyright','Copyright 2014 - All rights reserved voux')); ?></p>
                        </div>
                        <?php } ?>

                    </div><!-- /row -->
                </div><!-- /container -->
            </div><!-- /footer-extras -->
            <?php } ?>
        </footer>

        <?php endif; ?>

        <span id="gg-top-link-button" class="hidden">
            <a href="#gg-top">
                <i class="pe-7s-angle-up pe-3x pe-va"></i>
            </a>
        </span><!-- /top-link-block -->

        <?php wp_footer(); ?>

        <?php if (get_theme_mod('custom_js') != '') { ?>
            <script type="text/javascript">
                    <?php echo stripslashes(get_theme_mod('custom_js')); ?>
            </script>
        <?php } ?>

    </body>
</html>