<?php
/**
 * Theme Functions
 *
 * @author Gogoneata Cristian <cristian.gogoneata@gmail.com>
 * @package WordPress
 * @subpackage voux
 */

global $theme_name, $dependency_css;
$theme_name = "voux";
$dependency_css = array();

define("OKTHEMES_TEXTDOMAIN","okthemes");
define("OKTHEMES_THEMEVERSION","1.0");

@define( 'PARENT_DIR', get_template_directory() );
@define( 'CHILD_DIR', get_stylesheet_directory() );

@define( 'PARENT_URL', get_template_directory_uri() );
@define( 'CHILD_URL', get_stylesheet_directory_uri() );

// Include the helpers
include (PARENT_DIR.'/lib/helpers.php');

// Load TGM plugins
include (PARENT_DIR . '/lib/register-tgm-plugins.php');

//ACF

// ACF wrapper functions
include get_template_directory() . '/lib/acf-functions.php';

// Hide ACF field group menu item
add_filter('acf/settings/show_admin', '__return_false');

// ACF meta options
include get_template_directory() . '/lib/metaboxes.php';

// Include the customizer options
include (PARENT_DIR . '/admin/customizer/options.php');

// Include widgets
require_once (PARENT_DIR . '/lib/widgets.php');

// Include aq resize
include (PARENT_DIR . '/lib/aq_resizer.php');

// Include mobile detect
include_once (PARENT_DIR . '/lib/Mobile_Detect.php');

/**
 * Load woocommerce functions
 */
if (is_woocommerce_activated()) {
    require_once PARENT_DIR . '/lib/theme-woocommerce.php';
}

/**
 * Maximum allowed width of content within the theme.
 */
if (!isset($content_width)) {
    $content_width = 1170;
}

/**
 * Setup Theme Functions
 *
 */
if (!function_exists('gg_theme_setup')):
    function gg_theme_setup() {

        load_theme_textdomain(OKTHEMES_TEXTDOMAIN, get_template_directory() . '/lang');

        add_theme_support( 'title-tag' );
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
        
        $defaults = array(
            'default-color'          => 'ffffff',
            'default-image'          => '',
            'default-repeat'         => '',
            'default-position-x'     => '',
        );
        add_theme_support( 'custom-background', $defaults);
        add_theme_support(
                'woocommerce', apply_filters(
                    'voux_woocommerce_args', array(
                        'single_image_width'    => 9999,
                        'thumbnail_image_width' => 9999,
                        'product_grid'          => array(
                            'default_columns' => 3,
                            'default_rows'    => 3,
                            'min_columns'     => 1,
                            'max_columns'     => 6,
                            'min_rows'        => 1,
                        ),
                    )
                )
            );

        register_nav_menus(
            array(
                'main-menu' => __('Main Menu', OKTHEMES_TEXTDOMAIN),
                'footer-menu' => __('Footer Menu', OKTHEMES_TEXTDOMAIN)
            ));

        // load custom walker menu class file
        require (PARENT_DIR . '/lib/nav/class-bootstrapwp_walker_nav_menu.php');

        set_post_thumbnail_size('full');

        /*WooCommerce gallery support*/
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
    }
endif;
add_action('after_setup_theme', 'gg_theme_setup');


/**
 * Load CSS styles for theme.
 *
 */
function gg_styles_loader() {
    wp_enqueue_style('voux-bootstrap', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap.min.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-font-elegant', get_template_directory_uri() . '/assets/elegant-font/style.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-font-social', get_template_directory_uri() . '/assets/social-font/stylesheets.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-font-7-stroke', get_template_directory_uri() . '/assets/pe-icon-7-stroke/css/pe-icon-7-stroke.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-font-7-stroke-helper', get_template_directory_uri() . '/assets/pe-icon-7-stroke/css/helper.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-bootstrap-menu', get_template_directory_uri() . '/styles/dropdowns-enhancement.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('voux-bootstrap-select', get_template_directory_uri() . '/styles/bootstrap-select.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('isotope', get_template_directory_uri() . '/styles/isotope.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('magnific', get_template_directory_uri() . '/styles/magnific-popup.css', false, OKTHEMES_THEMEVERSION, 'all');
    
    //SlickCarousel
    wp_enqueue_style('slickcarousel', get_template_directory_uri() . '/assets/slick/slick.css', false, OKTHEMES_THEMEVERSION, 'all');
    wp_enqueue_style('slickcarousel-theme', get_template_directory_uri() . '/assets/slick/slick-theme.css', false, OKTHEMES_THEMEVERSION, 'all');

    wp_enqueue_style('bootval', get_template_directory_uri() . '/assets/bootstrap-validator/css/bootstrapValidator.css', false, OKTHEMES_THEMEVERSION, 'all');

    if (is_woocommerce_activated()) {
        wp_enqueue_style('gg-woocommerce', get_template_directory_uri() . '/styles/gg-woocommerce.css', false, OKTHEMES_THEMEVERSION, 'all');
    }

    wp_enqueue_style('voux-default', get_stylesheet_uri());

    wp_enqueue_style('voux-responsive', get_template_directory_uri() . '/styles/responsive.css', false, OKTHEMES_THEMEVERSION, 'all');

}
add_action('wp_enqueue_scripts', 'gg_styles_loader');

/**
 * Load JavaScript and jQuery files for theme.
 *
 */
function gg_scripts_loader() {

    $setBase = (is_ssl()) ? "https://" : "http://";

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    /*Site preloader*/
    if( 1 == get_theme_mod( 'site_preloader', 1 ) ) {
        wp_enqueue_script('pace',get_template_directory_uri() ."/js/pace.min.js",array('jquery'),OKTHEMES_THEMEVERSION,true);
    }
    
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . '/assets/bootstrap/js/bootstrap.min.js', array('jquery'),OKTHEMES_THEMEVERSION,true);
    wp_enqueue_script('bootstrap-menu', get_template_directory_uri() . '/js/dropdowns-enhancement.js', array('jquery'),OKTHEMES_THEMEVERSION,true);
    wp_enqueue_script('bootval', get_template_directory_uri() . '/assets/bootstrap-validator/js/bootstrapValidator.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_enqueue_script('bootselect', get_template_directory_uri() . '/js/bootstrap-select.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_enqueue_script('hoverintent', get_template_directory_uri() . '/js/hoverintent.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_register_script('gg-isotope', get_template_directory_uri() . '/js/jquery.isotope.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_register_script('magnific', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

    wp_enqueue_script('imagesloaded', get_template_directory_uri() . '/js/jquery.imagesloaded.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);   

    wp_enqueue_script('waypoints', get_template_directory_uri() . '/js/jquery.waypoints.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

    //Portfolio hover
    wp_register_script('hoverdir', get_template_directory_uri() . '/js/jquery.hoverdir.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_register_script('hoverdir-modernizr', get_template_directory_uri() . '/js/modernizr.custom.97074.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    
    //Infinite scroll
    wp_register_script('infinitescroll', get_template_directory_uri() . '/js/jquery.infinitescroll.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_register_script('manual-trigger', get_template_directory_uri() . '/js/manual-trigger.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

    //Slick Carousel
    wp_register_script('slickcarousel', get_template_directory_uri() . '/assets/slick/slick.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    wp_register_script('mousewheel', get_template_directory_uri() . '/assets/slick/jquery.mousewheel.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);
    
    wp_register_script('countto', get_template_directory_uri() . '/js/jquery.countto.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

    //Countdown for coming soon page
    wp_register_script('countdown', get_template_directory_uri() . '/js/jquery.countdown.min.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

    /*Maps*/
    wp_register_script('google-map-api',$setBase."maps.google.com/maps/api/js?key=".esc_attr(get_theme_mod('google_api_key'))."");
    wp_register_script('maplace',get_template_directory_uri() ."/js/maplace-0.1.3.min.js",array('jquery'),OKTHEMES_THEMEVERSION,true);

    /* Contact form */
    wp_enqueue_script('cfjs', get_template_directory_uri() ."/js/cf.js",array('jquery'),OKTHEMES_THEMEVERSION,true);
    wp_localize_script( 'cfjs', 'ajax_object_cf',
        array(
            'ajax_url' => admin_url( 'admin-ajax.php' )
        )
    );

    /* WooCommerce inputs fix */
    if (is_woocommerce_activated()) {
       wp_enqueue_script('woo-inputs', get_template_directory_uri() . '/js/woocommerce.js', array('jquery'), OKTHEMES_THEMEVERSION, true); 
    }

    /* General */
    wp_enqueue_script('custom', get_template_directory_uri() . '/js/custom.js', array('jquery'), OKTHEMES_THEMEVERSION, true);

}
add_action('wp_enqueue_scripts', 'gg_scripts_loader');

//Admin enque script for metabox
function gg_admin_metabox_script_loader() {
    wp_enqueue_script( 'jquery-custom-admin', get_template_directory_uri() . '/js/jquery.custom.admin.js', array( 'jquery' ), OKTHEMES_THEMEVERSION, true );
}
add_action( 'admin_enqueue_scripts', 'gg_admin_metabox_script_loader' );


/**
 * Define theme's widget areas.
 *
 */
function gg_widgets_init() {

    register_sidebar(
        array(
            'name'          => __('Page Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-page',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => "</div>",
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>',
        )
    );

    register_sidebar(
        array(
            'name'          => __('Posts Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-posts',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => "</div>",
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>',
        )
    );

    register_sidebar(
        array(
            'name'          => __('Search Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-search',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => "</div>",
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Portfolio Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-portfolio',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Shop Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-shop',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Product Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-product',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Contact Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-contact',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Footer First Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-footer-first',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Footer Second Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-footer-second',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Footer Third Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-footer-third',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );

    register_sidebar(
        array(
            'name'          => __('Footer Fourth Sidebar', OKTHEMES_TEXTDOMAIN),
            'id'            => 'sidebar-footer-fourth',
            'before_widget' => '<div id="%1$s" class="gg-widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        )
    );
}
add_action('init', 'gg_widgets_init');


/**
 * Display template for post meta information.
 *
 */
if (!function_exists('gg_posted_on')) :
    function gg_posted_on() {

    $date = sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a>',
        esc_url( get_permalink() ),
        esc_attr( get_the_time() ),
        esc_attr( get_the_date( 'c' ) ),
        esc_html( get_the_date() )
    );

    printf($date);    

}
endif;

/**
 * Display page header
 *
 */
if ( ! function_exists( 'gg_page_header' ) ) :

function gg_page_header() {
    $post_id = gg_global_page_id();
    ?>
    
    <?php
    $page_header = _get_field('gg_page_header',$post_id,true);
    $page_description = _get_field('gg_page_description',$post_id,'');
    $page_title_description_position = _get_field('gg_page_title_description_position',$post_id);
    $page_container = _get_field('gg_page_container_select',$post_id,'1170');

    $page_header_slider = _get_field('gg_page_header_slider',$post_id, false);
    $page_header_slider_position = _get_field('gg_page_header_slider_position',$post_id);
    $rev_slider_alias = _get_field('gg_page_header_slider_select',$post_id);

    switch ($page_title_description_position) {
        case "center":
            $page_title_container_class = 'col-md-10 col-md-offset-1';
            $page_text_align_class = 'text-center';
            break;
        case "left":
            $page_title_container_class = 'col-md-8';
            $page_text_align_class = 'text-left';
            break;
        case "right":
            $page_title_container_class = 'col-md-8 col-md-offset-8';
            $page_text_align_class = 'text-right';
            break;
        case NULL:
            $page_title_container_class = 'col-md-10 col-md-offset-1';
            $page_text_align_class = 'text-center';
            break;
    }

    ?>

    <?php if ( !is_singular( array( 'product' ) )  ) { ?>
            
        <?php if ( $page_header === TRUE OR $page_header === NULL ) { ?>

            <?php 
                if ( has_post_thumbnail($post_id) && is_page() ) :
                $page_header_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                $page_header_img_style = 'style="background-image: url('.$page_header_img_url[0].');"';
            ?>

            <div class="page-header-image" <?php echo $page_header_img_style; ?> ></div>

            <?php endif; ?>

            <?php if ( !is_404() && !is_front_page() ) : ?>
            <div class="page-title">
                <div class="container">
                    <div class="row">
                        <div class="<?php echo esc_attr($page_title_container_class); ?>">
                            <h1 class="<?php echo esc_attr($page_text_align_class); ?>">
                                <?php
                                    if ( is_search() ) {
                                        printf( __( 'Search Results for: %s', 'okthemes' ), get_search_query() );
                                    } elseif ( is_category() || is_tag() || is_author() || is_year() || is_month() || is_day() ) {
                                        echo get_the_archive_title();
                                    } elseif ( is_tax() ) {
                                        $tax = get_taxonomy( get_queried_object()->taxonomy );
                                        echo single_term_title( '', false );
                                    } elseif ( is_woocommerce_activated() && is_product_category() ) {
                                        single_cat_title();
                                    } elseif ( is_woocommerce_activated() && is_product_tag() ) {
                                        single_tag_title();
                                    } elseif ( is_woocommerce_activated() && is_page() && is_wc_endpoint_url() ) {
                                           $endpoint = WC()->query->get_current_endpoint();
                                           if ( $endpoint_title = WC()->query->get_endpoint_title( $endpoint ) ) {
                                                echo $endpoint_title;
                                            } 
                                    } else {
                                        echo get_the_title($post_id);
                                    }
                                ?>
                            </h1>

                            <?php if ($page_description != '' && is_page() ) { ?>
                            <div class="header-page-description <?php echo esc_attr($page_text_align_class); ?>">
                                <?php echo wp_kses_post($page_description); ?>
                            </div>
                            <?php } ?>

                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

        <?php } ?>

        <?php if ($page_header_slider) { ?>
        <div class="subheader-slider <?php echo esc_attr($page_header_slider_position); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php putRevSlider(esc_html($rev_slider_alias)); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <?php } ?>

<?php
    }
}
endif;


/**
 * Display template for post footer information (in single.php).
 *
 */
if (!function_exists('gg_posted_in')) :
    function gg_posted_in() {

    // Translators: used between list items, there is a space after the comma.
    $tag_list = get_the_tag_list('<ul class="list-inline post-tags"><li>','</li><li>','</li></ul>');

    // Translators: 1 is the tags
    if ( $tag_list ) {
        $utility_text = __( '%1$s', OKTHEMES_TEXTDOMAIN );
    } 

    printf($tag_list);

}

endif;


/**
 * Adds custom classes to the array of body classes.
 *
 */
if (!function_exists('gg_theme_body_classes')) :
    function gg_theme_body_classes($classes) {
        if (is_page()):

            $page_header_slider = _get_field('gg_page_header_slider', gg_global_page_id());
            $page_header_slider_position = _get_field('gg_page_header_slider_position', gg_global_page_id());

            if ( has_post_thumbnail( gg_global_page_id() ) ) {
                $classes[] = 'gg-page-has-header-image';
            }
            if ( $page_header_slider ) {
                $classes[] = 'gg-page-has-header-slider '.$page_header_slider_position;
            }
        endif;

        if (!is_multi_author()) {
            $classes[] = 'single-author';
        }

        if (is_page_template('theme-templates/portfolio.php')) {
            $classes[] = 'gg-portfolio-template';
        }
        if (is_page_template('theme-templates/contact.php')) {
            $classes[] = 'gg-contact-template';
        }
        if (is_page_template('theme-templates/coming-soon.php')) {
            $classes[] = 'gg-coming-soon-template';
        }

        if (!get_theme_mod('site_preloader')) {
            $classes[] = 'pace-not-active';
        }

        if (1 == get_theme_mod( 'logo_check')) {
            $classes[] = 'has-img-logo';
        }

        if (1 == get_theme_mod( 'sticky_menu')) {
            $classes[] = 'has-sticky-menu';
        }
        
        // current language code if wpml is installed
        if( function_exists( 'icl_get_home_url' ) ) {
              $classes[] = ICL_LANGUAGE_CODE;
        }

        //Mobile
        $detect = new Mobile_Detect;
        if( $detect->isMobile() || $detect->isTablet() ){
            $classes[] = 'gg-theme-is-mobile';
        }

        return $classes;
    }
    add_filter('body_class', 'gg_theme_body_classes');
endif;


add_filter( 'the_password_form', 'custom_password_form' );
function custom_password_form() {
 
    global $post;
 
    $label = 'pwbox-'.(empty($post->ID) ? rand() : $post->ID);
 
    $output = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
 
    <p>' . __("This post is password protected. To view it please enter your password below:","okthemes") . '</p>
 
    <div class="input-group"><span class="input-group-addon"><i class="icon_lock_alt"></i></span><label class="sr-only" for="' . esc_attr($label) . '">' . esc_attr__("Password","okthemes") . '</label><input name="post_password" id="' . esc_attr($label) . '" type="password" placeholder=' . esc_attr__("Password","okthemes") . ' size="20" /><span class="input-group-btn"><input type="submit" name="Submit" value="' . esc_attr__("Submit","okthemes") . '" /></span></div></form>'; 
    return $output;
}

function add_wpb_to_body_if_shortcode($classes) {
    global $post;
    if (isset($post->post_content) && false !== stripos($post->post_content, '[vc_row')) {
        array_push($classes, 'wpb-is-on');
    } else {
        array_push($classes, 'wpb-is-off');
    }
    return $classes;
}
add_filter('body_class', 'add_wpb_to_body_if_shortcode', 100, 1);

/**
 * Replaces the login header logo
 */
if (!function_exists('wp_admin_login_style')) :
    add_action( 'login_head', 'wp_admin_login_style' );
    function wp_admin_login_style() {
        if ( get_theme_mod( 'admin_logo' ) ) {
            echo '<style>
            .login h1 a { 
                background-image: url( '.esc_url(get_theme_mod('admin_logo')).' ) !important; 
                background-size:'.esc_attr(get_theme_mod('admin_logo_width')).'px '.esc_attr(get_theme_mod('admin_logo_height')).'px;
                width:'.esc_attr(get_theme_mod('admin_logo_width')).'px;
                height:'.esc_attr(get_theme_mod('admin_logo_height')).'px;
                margin-bottom:15px; 
            }
            </style>'; 
        }
    }
endif;
