<?php
/**
 * Default Page Header
 *
 * @package WordPress
 * @subpackage Voux
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->

	<script>(function(){document.documentElement.className='js'})();</script>

	<?php if (get_theme_mod('favicon_logo')) { ?>
        <link rel="shortcut icon" href="<?php echo esc_url(get_theme_mod('favicon_logo')); ?>">
    <?php } ?>  

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php 
if (!is_page_template('theme-templates/coming-soon.php')) {
	include PARENT_DIR . '/lib/headers/header-default.php';
}
?>

<?php 
if( 1 == get_theme_mod( 'header_search', 1 ) && is_woocommerce_activated() ) {
	get_template_part( 'parts/part','searchform-toolbar' );
}
?>