<?php
/**
 * Description: Default Home template to display loop of blog posts
 *
 * @package WordPress
 * @subpackage voux
 */
get_header(); ?>

<?php

global $blog_list_thumbnail, $blog_list_content, $blog_layout;

//Get the ID of the page used for Blog posts
$page_id = ( 'page' == get_option( 'show_on_front' ) ? get_option( 'page_for_posts' ) : get_the_ID() );

$page_layout = _get_field('gg_page_layout_select',$page_id);
$page_container = _get_field('gg_page_container_select',$page_id);

$blog_list_thumbnail = TRUE;
$blog_list_content = TRUE;
$blog_layout = 'list';

switch ($page_container) {
    case "1170":
        $page_container_class = 'container';
        break;
    case "fullscreen":
        $page_container_class = 'container-fluid';
        break;
    case NULL:
        $page_container_class = 'container';
        break;
}

switch ($page_layout) {
    case "with_right_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;
    case "with_left_sidebar":
        $page_content_class = 'col-xs-12 col-md-9 pull-right';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-left';
        break;
    case "no_sidebar":
        $page_content_class = 'col-xs-12 col-md-12';
        break;
    case NULL:
        $page_content_class = 'col-xs-12 col-md-9 pull-left';
        $page_sidebar_class = 'col-xs-12 col-md-3 pull-right';
        break;        
}

//Enqueue magnific
wp_enqueue_script( 'gg-magnific' );
wp_enqueue_style( 'gg-magnific' );
?>

<section id="content">
    <div class="<?php echo esc_attr($page_container_class); ?>">
        
        <?php if ( $page_layout == 'no_sidebar' ) : ?> 
        <div class="gg-content-separator"></div>
        <?php endif; //Apply full width border ?>

        <div class="row">
            <div class="<?php echo esc_attr($page_content_class); ?>">

                <?php if ( $page_layout != 'no_sidebar' ) : ?> 
                <div class="gg-content-separator"></div>
                <?php endif; //Apply content border ?>
    
                <div class="gg_posts_grid">
                <?php if ( have_posts() ) : ?>
                    <ul class="el-grid" data-layout-mode="<?php echo esc_attr($blog_layout); ?>">
                    <?php while ( have_posts() ) : the_post(); ?>
                        
                        <?php if ($blog_layout == 'list') : ?>
                            <li class="gg-post-list-item"><?php get_template_part( 'parts/part-list', get_post_format() ); ?></li>
                        <?php else: ?>
                            <li class="isotope-item <?php echo esc_attr($blog_columns_class); ?>"><?php get_template_part( 'parts/part', get_post_format() ); ?></li>
                        <?php endif; ?>
                    <?php endwhile; ?>

                    </ul>

                    <?php
                    if (function_exists("gg_pagination")) {
                        gg_pagination($wp_query->max_num_pages);
                    }
                    ?>

                <?php else : ?>

                    <?php get_template_part( 'parts/part', 'none' ); ?>

                <?php endif; // end have_posts() check ?>
                </div><!--/ .gg_posts_grid-->
            </div>

            <?php if (($page_layout !== 'no_sidebar')) { ?>
            <div class="<?php echo esc_attr($page_sidebar_class); ?>">
                <aside class="sidebar-nav">
                    <?php get_sidebar(); ?>
                </aside>
                <!--/aside .sidebar-nav -->
            </div><!-- /.col-4 col-sm-4 col-lg-4 -->
            <?php } ?>

        </div>
    </div>    
</section>
<?php get_footer(); ?>