(function ($) {
"use strict";

function gg_isotope_init() {

	if($('.el-grid:not(.gg-slick-carousel):not([data-layout-mode="list"])').length > 0){
	    var layout_modes = {
	        fitrows: 'fitRows',
	        masonry: 'masonry'
	    }
	    jQuery('.gg_posts_grid').each(function(){
	        var $container = jQuery(this);
	        var $thumbs = $container.find('.el-grid:not(.gg-slick-carousel):not([data-layout-mode="list"])');
	        var layout_mode = $thumbs.attr('data-layout-mode');
	        
	        $thumbs.isotope({
	            // options
	            itemSelector : '.isotope-item',
	            layoutMode : (layout_modes[layout_mode]==undefined ? 'fitRows' : layout_modes[layout_mode]),
	            getSortData: {
				    number: '[data-best-sellers]',
				},
				//filter: '.grid-cat-men'
	        });


	        // sort items on button click
			$('.sort-by-best-sellers').on( 'click', function() {
			  var sortByValue = $(this).attr('data-sort-by');
			  $thumbs.isotope({ sortBy: sortByValue });
			});

			//Isotope filter
	        if($container.find('.gg_filter:not(.gg-slick-carousel)').length > 0){
		        $container.find('.gg_filter:not(.gg-slick-carousel) a').data('isotope', $thumbs).click(function(e){
		            e.preventDefault();
		            var $thumbs = jQuery(this).data('isotope');
		            jQuery(this).parent().parent().find('.active').removeClass('active');
		            jQuery(this).parent().addClass('active');
		            $thumbs.isotope({filter: jQuery(this).attr('data-filter')});
		        });
	    	}

	        jQuery(window).bind('load resize', function() {
				$thumbs.imagesLoaded( function() {
				 	$thumbs.isotope('layout');
				});
	        });

	    });
	}
}

/* Magnific */
function gg_magnific_init() {
	if($('.el-grid:not(.products), .gg-slick-carousel.has_magnific, .wpb_image_grid.has_magnific, .wpb_single_image.has_magnific').length > 0){
		$( '.el-grid:not(.products), .gg-slick-carousel.has_magnific, .wpb_image_grid.has_magnific, .wpb_single_image.has_magnific' ).each(function(){
			$(this).magnificPopup({
				delegate: 'a.lightbox-el',
				type: 'image',
				gallery: {
		            enabled: true
		        },
				callbacks: {
				    elementParse: function(item) {
				      if(item.el.context.className == 'lightbox-el link-wrapper lightbox-video') {
				         item.type = 'iframe';
				      } else {
				         item.type = 'image';
				      }
				    }
				}
			});
		});
	}
}

/* SlickCarousel */
function gg_slickcarousel_init() {
	if($('.gg-slick-carousel:not(.gg_filter)').length > 0){
		$( '.gg-slick-carousel:not(.gg_filter)' ).each(function(){

			var $this = $(this);

			//Initialize slick
			$this.slick();

		  	if ($this.attr('data-mousewheel') == "true") {
			  	$this.on('mousewheel', function (e) {

				    if (e.deltaY>0) {
				        $(this).slick('slickNext');
				    } else {
				        $(this).slick('slickPrev');
				        
				    }
				    e.preventDefault();
				});
			}

			var filtered = false;

			$('.gg_filter.gg-slick-carousel a').on('click', function(e){

			  e.preventDefault();
			  $(this).parent().parent().find('.active').removeClass('active');
		      $(this).parent().addClass('active');

		      var gg_filter = $(this).parent().parent().parent().parent().find('.el-grid.gg-slick-carousel');

		      if ($(this).attr('data-filter') == '*') {
		      	gg_filter.slick('slickUnfilter');
		      	gg_filter.slick('slickGoTo',0);
			    filtered = false;
			  } else {
			  	gg_filter.slick('slickFilter',$(this).attr('data-filter'));
			  	gg_filter.slick('slickGoTo',0);
			    filtered = true;

			  } 

			});

		});

	}
}

/* SlickCarousel */
function gg_vc_rtl_row() {
	
}

/* Counter */
function gg_counter_init(){
	if($('.counter').length > 0){
		jQuery('.counter-holder').waypoint(function() {
			$('.counter').each(function() {
				if(!$(this).hasClass('initialized')){
					$(this).addClass('initialized');
					var $this = $(this),
					countToNumber = $this.attr('data-number'),
					refreshInt = $this.attr('data-interval'),
					speedInt = $this.attr('data-speed');

					$(this).countTo({
						from: 0,
						to: countToNumber,
						speed: speedInt,
						refreshInterval: refreshInt
					});
				}
			});
		}, { offset: '85%' });
	}
}

$(document).ready(function () {

	gg_slickcarousel_init();
    gg_magnific_init();
    gg_counter_init();
    gg_isotope_init();
    gg_vc_rtl_row();

    //Header continue hor line
    function header_line_continue() {
		if($('#toolbar-menu').length > 0) {
			var toolbar = $('#toolbar-menu');
			var main_menu = $('#main-menu');
			
			var flanker_holder = $('.flanker .flanker-holder');
    		var flanker_line = $('.flanker .flanker-holder .gg-hor-line');
    		
    		var main_menu_height = main_menu.outerHeight();
    		var toolbar_height = toolbar.outerHeight();
    		var header_height = main_menu_height + toolbar_height;

    		flanker_holder.css('height', header_height + "px");
       		flanker_line.css('top', toolbar_height + "px");

       		if($('body.has-sticky-menu').not('.under_header').length > 0) {
       			$('body').css('padding-top', header_height + "px");
       		}

       		$(window).on('scroll', function () {
       			if ($(this).scrollTop() > 60) {
       				$('body.has-sticky-menu.admin-bar .navbar-default').stop(true).animate({top: '32px'}, 200);
       			} else {
       				$('body.has-sticky-menu.admin-bar .navbar-default').stop(true).animate({top: '62px'}, 200);
       			}
       		});
		}
	}

	$(window).resize(function() {
		header_line_continue();
	});
	
	header_line_continue();


    function parseDate(input) {
		var parts = input.match(/(\d+)/g);

		if (parts.length < 6) {
			var l = 6-parts.length;
			var i = 0;
			while (i <= l) {
				parts.push('0');
				i++;
			}
		}
		return new Date(parts[0], parts[1]-1, parts[2], parts[3], parts[4], parts[5]);
	}

    /* jQuery countdown init */
    if($('.coming-soon-countdown #countdown').length > 0){
		$('.coming-soon-countdown #countdown').countdown({
			layout:	'<div class="counter-block"><span id="days-num">{dn} <span class="time-desc">{dl}</span></span></div>' +
					'<div class="counter-block"><span id="hours-num">{hn} <span class="time-desc">{hl}</span></span></div>' +
					'<div class="counter-block"><span id="min-num">{mn} <span class="time-desc">{ml}</span></span></div>' +
					'<div class="counter-block"><span id="sec-num">{sn} <span class="time-desc">{sl}</span></span></div>',
			until: parseDate($('#countdown').data('date')),
			onTick: everyFive
		});
	}

	function everyFive(periods) { 
	    $('.time-desc').each(function() {
		    $(this).html(
		        $(this).html().substr(0, $(this).html().length-1)
		          + "<span class='colored-letter'>"
		          + $(this).html().substr(-1)
		          + "</span>");
		});
	}


    //Set portfolio effect
    $(' .da-thumbs > li ').each( function() {
    		$(this).hoverdir();
    	}
    );

    jQuery(' .da-thumbs > li ').find('a.lightbox-el').on("click", function(){
        jQuery(this).parent().parent().parent().css({'display':'none'});
    });

    //Style select 
    if($('form.woocommerce-ordering select.orderby').length > 0) {
		$('form.woocommerce-ordering select.orderby, form.woocommerce-products-per-page select').selectpicker({
		    style: 'wc-ordering-select',
		    size: false
		});
	}
 
	// here for the submit button of the comment reply form
	

    function add_form_control_class() {

        $( '#submit, input[type="button"], input[type="reset"], input[type="submit"], a.checkout-button' ).addClass( 'btn btn-primary' );   
    
        $( 'table' ).not('.variations').addClass( 'table');

        $( 'form' ).not('.header-search form, .variations_form').addClass( 'table');

        $('form').attr('role', 'form');

    	var inputs = $('input, textarea')
                .not(':input[type=button], :input[type=submit], :input[type=reset]');

    	$(inputs).each(function() {
    	    $(this).addClass('form-control');
    	});
    }

    add_form_control_class();

    $(document.body).bind('updated_cart_totals', function() {
        add_form_control_class();
    });

	if($('body.gg-theme-is-mobile').length > 0) {
		$("a.product-image-overlay").click(function(event){
		    event.preventDefault();
		});
	}

	//Fullscreen search form
	if($('.site-header .gg-toolbar-search').length > 0) {
	    $('a[href="#fullscreen-searchform"]').on('click', function(event) {
	        event.preventDefault();
	        $('#fullscreen-searchform').addClass('open');
	        $('#fullscreen-searchform > form > input[type="search"]').focus();
	    });
	    
	    $('#fullscreen-searchform, #fullscreen-searchform button.close').on('click keyup', function(event) {
	        if (event.target == this || event.target.className == 'close' || event.keyCode == 27) {
	            $(this).removeClass('open');
	        }
	    });
    }

    //Currency switcher
	if($('.site-header .gg-currency-switcher').length > 0) {
	    $('.gg-currency-switcher ul.wcml_currency_switcher').addClass('dropdown-menu');
    }

    // Back to top button
	if ( ($(window).height() + 100) < $(document).height() ) {
	    
	    $('#gg-top-link-button').removeClass('hidden').affix({
	        // how far to scroll down before link "slides" into view
	        offset: {top:100}
	    });

	    $( "#gg-top-link-button a" ).on( "click", function() {
			$('html,body').animate({scrollTop:0},'slow');
			return false;
		});
	}

});

})(jQuery);