<?php

// Verify if woocommerce is active
if ( ! function_exists( 'is_woocommerce_activated' ) ) {
    function is_woocommerce_activated() {
        if ( class_exists( 'woocommerce' ) ) { 
            return true;
        } else { 
            return false;
        }
    }
}

// Verify if WPML is active
if ( ! function_exists( 'is_wpml_activated' ) ) {
    function is_wpml_activated() {
        if ( class_exists( 'SitePressLanguageSwitcher' ) ) { 
            return true; 
        } else { 
            return false;
        }
    }
}

//Fix the autoupdate in VC
function gg_voux_enable_vc_auto_theme_update() {
  if( function_exists('vc_updater') ) {
    $vc_updater = vc_updater();
    remove_filter( 'upgrader_pre_download', array( $vc_updater, 'preUpgradeFilter' ), 10 );
    if( function_exists( 'vc_license' ) ) {
      if( !vc_license()->isActivated() ) {
        remove_filter( 'pre_set_site_transient_update_plugins', array( $vc_updater->updateManager(), 'check_update' ), 10 );
      }
    }
  }
}
add_action('vc_after_init', 'gg_voux_enable_vc_auto_theme_update');

// Set VC as part of the theme
if(function_exists('vc_set_as_theme')) {

    vc_set_as_theme($disable_updater = true);
    vc_set_shortcodes_templates_dir(PARENT_DIR.'/lib/visualcomposer/vc_templates/');
    require_once (PARENT_DIR . '/lib/load-vc-modules.php');
    $dependency_css[] = 'js_composer_front';

    $list = array(
        'page',
        'portfolio_cpt'
    );
    vc_set_default_editor_post_types( $list );
}

// Hide activation and update specific parts of Slider Revolution
if(function_exists('set_revslider_as_theme')) {

    //Disable the activation nag
    update_option('revslider-valid-notice', 'false');
    update_option('revslider-valid', 'true');

    add_action( 'init', 'gg_rev_slider' );
    function gg_rev_slider() {
        set_revslider_as_theme();
    }
}

//Get the wmpl flags
if (is_wpml_activated()) {
    function language_selector_flags(){
        if (function_exists('icl_get_languages')) {
          $languages = icl_get_languages('skip_missing=0&orderby=custom&order=asc');
          if ($languages) {
              $out = '';
              $dropdown = '';
              foreach ($languages as $lang) {
                  $lcode = explode('-',$lang['language_code']);
       
                  if ($lang['active']) {
                      $button = '<a href="#" data-toggle="dropdown" aria-haspopup="true" class="dropdown-toggle"><img src="'.$lang['country_flag_url'].'" alt="'.$lang['translated_name'].'" /><span class="hidden-sm hidden-xs">'.$lang['translated_name'].'</span></a>';
                  } else {
                      $dropdown .= '<li><a href="'.$lang['url'].'" title="'.$lang['native_name'].'"><img src="'.$lang['country_flag_url'].'" alt="'.$lang['translated_name'].'" />'.$lang['translated_name'].'</a></li>';
                  }
              }
              $out .= $button;
              $out .= '<ul id="langswitch" class="dropdown-menu">'.$dropdown.'</ul>';
              echo $out;
          }
        }
    }
}

/**
 * Display an optional post thumbnail.
 */
if ( ! function_exists( 'gg_post_thumbnail' ) ) :
function gg_post_thumbnail() {
  if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
    return;
  }

  if ( is_single() ) :
  ?>

  <div class="post-thumbnail">
    <?php the_post_thumbnail(); ?>
  </div><!-- .post-thumbnail -->

  <?php else : ?>

  <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
    <?php
      the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) );
    ?>
  </a>

  <?php endif; // End is_singular()
}
endif;

/**
 * Add class to next post link
 */
function next_posts_link_css($content) { 
    return 'class="btn btn-primary"';
}
add_filter('next_posts_link_attributes', 'next_posts_link_css' );


/**
 * Infinite Scroll
 */
function custom_infinite_scroll_js() { ?>
  <script>

  if(jQuery('.el-grid[data-pagination="ajax_load"]').length > 0) {

    var container = jQuery('ul.el-grid');
    var infinite_scroll = {
      loading: {
        selector: '.load-more-anim',
        img: "<?php echo get_template_directory_uri(); ?>/images/animated-ring.gif",
        msgText: "<?php _e( 'Loading the next set of posts...', 'okthemes' ); ?>",
        finishedMsg: "<?php _e( 'All posts loaded.', 'okthemes' ); ?>"
      },
      behavior: "twitter",
      nextSelector:".pagination-span a",
      navSelector:".pagination-load-more",
      itemSelector:"ul.el-grid li",
      contentSelector:"ul.el-grid",
      animate: false,
      debug: true,

    };

    jQuery( infinite_scroll.contentSelector ).infinitescroll( 
      infinite_scroll,
      
      // Infinite Scroll Callback
      function( newElements ) {
        
        var newElems = jQuery( newElements ).hide();
        newElems.imagesLoaded(function(){
          newElems.fadeIn();

          if(jQuery('.el-grid[data-layout-mode="masonry"], .el-grid[data-layout-mode="fitRows"]').length > 0) {
            container.isotope( 'appended', newElems );
          }
          
          if(jQuery('.el-grid.da-thumbs').length > 0) {
            jQuery(' #da-thumbs > li ').each( function() {
                jQuery(this).hoverdir();
              }
            );
          }
          
        });
        
      }
      

    );
  }
  </script>
  
  <?php
}
add_action( 'wp_footer', 'custom_infinite_scroll_js',100 );

/**
 * Infinite Scroll
 */
function gg_vc_rtl_row() { ?>
  <script>

  if(jQuery('body.rtl').length > 0){
    jQuery( '.vc_row[data-vc-full-width="true"]' ).each(function(){

      //VC Row RTL
      var jQuerythis = jQuery(this);
      var vc_row = jQuerythis.offset().left;

      jQuerythis.css('right', - vc_row)
      

    });

  }

  </script>
  
  <?php
}
add_action( 'wp_footer', 'gg_vc_rtl_row',100 );

/**
 * Prints HTML with meta information for the categories, tags.
 */
if ( ! function_exists( 'gg_entry_meta' ) ) :
function gg_entry_meta() {
  if ( is_sticky() && is_home() && ! is_paged() ) {
    printf( '<span class="sticky-post">%s</span>', __( 'Featured', 'gg' ) );
  }

  $format = get_post_format();
  if ( current_theme_supports( 'post-formats', $format ) ) {
    printf( '<span class="entry-format">%1$s<a href="%2$s">%3$s</a></span>',
      sprintf( '<span>%s: </span>', _x( 'Format', 'Used before post format.', 'gg' ) ),
      esc_url( get_post_format_link( $format ) ),
      get_post_format_string( $format )
    );
  }

  if ( 'post' == get_post_type() ) {
    if ( is_singular() || is_multi_author() ) {
      printf( '<span class="byline"><span class="author vcard"><span>%1$s: </span><a class="url fn n" href="%2$s">%3$s</a></span></span>',
        _x( 'Author', 'Used before post author name.', 'gg' ),
        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
        get_the_author()
      );
    }

    $categories_list = get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'gg' ) );
    if ( $categories_list && gg_categorized_blog() ) {
      printf( '<span class="cat-links"><span>%1$s: </span>%2$s</span>',
        _x( 'Categories', 'Used before category names.', 'gg' ),
        $categories_list
      );
    }

    $tags_list = get_the_tag_list( '', _x( ', ', 'Used between list items, there is a space after the comma.', 'gg' ) );
    if ( $tags_list ) {
      printf( '<span class="tags-links"><span>%1$s: </span>%2$s</span>',
        _x( 'Tags', 'Used before tag names.', 'gg' ),
        $tags_list
      );
    }
  }

  if ( is_attachment() && wp_attachment_is_image() ) {
    // Retrieve attachment metadata.
    $metadata = wp_get_attachment_metadata();

    printf( '<span class="full-size-link"><span>%1$s: </span><a href="%2$s">%3$s &times; %4$s</a></span>',
      _x( 'Full size', 'Used before full size attachment link.', 'gg' ),
      esc_url( wp_get_attachment_url() ),
      $metadata['width'],
      $metadata['height']
    );
  }

  if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
    echo '<span class="comments-link">';
    comments_popup_link( __( 'Leave a comment', 'gg' ), __( '1 Comment', 'gg' ), __( '% Comments', 'gg' ) );
    echo '</span>';
  }
}
endif;


/**
 * Excerpt read more
 *
 */

function gg_excerpt_more( $more ) {
    return '<br class="read-more-spacer"> <a class="more-link clearfix" href="'. esc_url(get_permalink( get_the_ID() )) . '">' . __('Read More', OKTHEMES_TEXTDOMAIN) . '</a>';
}
add_filter( 'excerpt_more', 'gg_excerpt_more' );

/**
 * Read more
 *
 */
function wpse63748_add_morelink_class( $link, $text )
{
    return str_replace(
         'more-link'
        ,'more-link btn btn-default clearfix'
        ,$link
    );
}
add_action( 'the_content_more_link', 'wpse63748_add_morelink_class', 10, 2 );

/**
 * Tags widget style
 *
 */

function gg_tag_cloud_widget($args) {
    $args['number'] = 0; //adding a 0 will display all tags
    $args['largest'] = 12; //largest tag
    $args['smallest'] = 12; //smallest tag
    $args['unit'] = 'px'; //tag font unit
    $args['format'] = 'list'; //ul with a class of wp-tag-cloud
    return $args;
}
add_filter( 'widget_tag_cloud_args', 'gg_tag_cloud_widget' );

/**
 * Determine whether blog/site has more than one category.
 *
 */
function gg_categorized_blog() {
  if ( false === ( $all_the_cool_cats = get_transient( 'gg_categories' ) ) ) {
    // Create an array of all the categories that are attached to posts.
    $all_the_cool_cats = get_categories( array(
      'fields'     => 'ids',
      'hide_empty' => 1,

      // We only need to know if there is more than one category.
      'number'     => 2,
    ) );

    // Count the number of categories that are attached to the posts.
    $all_the_cool_cats = count( $all_the_cool_cats );

    set_transient( 'gg_categories', $all_the_cool_cats );
  }

  if ( $all_the_cool_cats > 1 ) {
    // This blog has more than 1 category so gg_categorized_blog should return true.
    return true;
  } else {
    // This blog has only 1 category so gg_categorized_blog should return false.
    return false;
  }
}

/**
 * Flush out the transients used in {@see gg_categorized_blog()}.
 *
 */
function gg_category_transient_flusher() {
  // Like, beat it. Dig?
  delete_transient( 'gg_categories' );
}
add_action( 'edit_category', 'gg_category_transient_flusher' );
add_action( 'save_post',     'gg_category_transient_flusher' );

//Get the global page id
if (! function_exists('gg_global_page_id')) :
function gg_global_page_id() {
	
  global $wp_query;

  if ( !is_404() && !is_search() && !is_tax( 'product_cat') ) {
    $current_page_id = $wp_query->post->ID;
  } else {
    $current_page_id = '';
  }
	
	
  if(is_home()){
	    if('page' == get_option('show_on_front')){
	        if(is_front_page()){
	            $current_page_id = get_option('page_on_front');
	        }else{
	            $current_page_id = get_option('page_for_posts');
	        }
	    }
	}

	if ( is_woocommerce_activated() && (is_woocommerce() || is_product_category()) ) {
    $current_page_id = wc_get_page_id( 'shop' );
  }

  return $current_page_id;

}
endif;

/**
 * Add rev sliders to metabox
 */
function gg_populate_rv_select( $field ) {
    global $wpdb;

    $rs_table_name = $wpdb->prefix . "revslider_sliders";
    $limit = 999;
    $rs = $wpdb->get_results( $wpdb->prepare("SELECT id, title, alias FROM $rs_table_name ORDER BY id ASC LIMIT %d", $limit) );

    $revsliders = array();
    if ($rs) {
        foreach ( $rs as $slider ) {
          $revsliders[$slider->alias] = $slider->alias;
        }
    } else {
        $revsliders["No sliders found"] = 'No sliders found';
    }

    $field['choices'] = $revsliders;

    return $field;
}

if(function_exists('set_revslider_as_theme')) {
add_filter('acf/load_field/name=gg_page_header_slider_select', 'gg_populate_rv_select');
}

function gg_check_email($email) {
    if (is_email($email)) {
        return 1;
    } else {
        return __( 'The entered email address isn\'t valid.', OKTHEMES_TEXTDOMAIN );
    }
}

//Contact form
function cf_ajax() {
    //Get the post id
    $post_id = absint($_POST['post_id']);

    $contact_page_email = _get_field( 'gg_contact_page_email',$post_id);
    $contact_page_email_from = _get_field( 'gg_contact_page_email_from',$post_id);
    $contact_page_success = _get_field( 'gg_contact_page_success_msg',$post_id);
    $contact_page_error = _get_field( 'gg_contact_page_error_msg',$post_id);

    if ($contact_page_success == '') {
        $contact_page_success = __( 'Your message was sent successfully.' , OKTHEMES_TEXTDOMAIN );
    }

    if ($contact_page_error == '') {
        $contact_page_error = __( 'There was an error submitting the form.' , OKTHEMES_TEXTDOMAIN );
    }

    if ($contact_page_email_from == '') {
        $contact_page_email_from = 'noreply@yoursitename.com';
    }

    $error = '';
    $status = 'error';

    if ( empty($_POST['name']) || empty($_POST['email']) || empty($_POST['message']) ) {
        $error = __( 'All fields are required to enter.' , OKTHEMES_TEXTDOMAIN );
    } else {
        if (!wp_verify_nonce($_POST['_cf_nonce'], 'contact_form_html')) {
            $error = __( 'Verification error, try again.' , OKTHEMES_TEXTDOMAIN );
        } else {

            $name           = sanitize_text_field($_POST['name']);
            $email          = sanitize_email($_POST['email']);
            $email_check    = gg_check_email($email);
            $subject        = sanitize_text_field($_POST['subject']);
            $messagecf      = esc_textarea($_POST['message']);


            if ($email_check == 1) {
                
                $subject = sprintf(__( 'New contact form message from : %1$s' , OKTHEMES_TEXTDOMAIN ), $name);

                $message = '<html><body>';
                $message .= '<table rules="all" style="border-color: #666;" cellpadding="10">';
                $message .= "<tr><td><strong>".__( 'Subject', OKTHEMES_TEXTDOMAIN)."</strong> </td><td>" . $subject . "</td></tr>";
                $message .= "<tr style='background: #eee;'><td><strong>".__( 'Name', OKTHEMES_TEXTDOMAIN)."</strong> </td><td>" . $name . "</td></tr>";
                $message .= "<tr><td><strong>".__( 'Email', OKTHEMES_TEXTDOMAIN)."</strong> </td><td>" . $email . "</td></tr>";
                $message .= "<tr style='background: #eee;'><td><strong>".__( 'Message', OKTHEMES_TEXTDOMAIN)."</strong> </td><td>" . $messagecf . "</td></tr>";
                $message .= "</table>";
                $message .= "</body></html>";

                $to = $contact_page_email;
                if (!isset($to) || ($to == '') ){
                    $to = get_option('admin_email');
                }
                
                $emailfrom = $contact_page_email_from;

                $header = 'From: '.get_option('blogname').' <'.$emailfrom.'>'. "\r\n";
                $header .= 'Reply-To: '.$email. "\r\n";
                $header .= 'Content-Type: text/html; charset=ISO-8859-1'. "\r\n";
                
                if ( wp_mail($to, $subject, $message, $header) ) {
                    $status = 'success';
                    $thankyou = '';
                    $error = ($thankyou != '') ? $thankyou : $contact_page_success;
                } else {
                    $error = $contact_page_error;
                }

            } else {
                $error = $email_check;
            }
        }
    }

    $resp = array('status' => $status, 'errmessage' => $error);
    wp_send_json($resp);
}
add_action( 'wp_ajax_cf_action', 'cf_ajax' );
add_action( 'wp_ajax_nopriv_cf_action', 'cf_ajax' );

if (! function_exists('gg_hex_r')) :
function gg_hex_r($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return implode(",", $rgb); // returns the rgb values separated by commas
   //return $rgb; // returns an array with the rgb values
}
endif;

/**
 * Color shift a hex value by a specific percentage factor
 *
 * @param string $supplied_hex Any valid hex value. Short forms e.g. #333 accepted.
 * @param string $shift_method How to shift the value e.g( +,up,lighter,>)
 * @param integer $percentage Percentage in range of [0-100] to shift provided hex value by
 * @return string shifted hex value
 * @version 1.0 2008-03-28
 */
if (!function_exists('gg_hex_shift')) :
    function gg_hex_shift( $supplied_hex, $shift_method, $percentage = 50 ) {
        $shifted_hex_value = null;
        $valid_shift_option = FALSE;
        $current_set = 1;
        $RGB_values = array( );
        $valid_shift_up_args = array( 'up', '+', 'lighter', '>' );
        $valid_shift_down_args = array( 'down', '-', 'darker', '<' );
        $shift_method = strtolower( trim( $shift_method ) );

        // Check Factor
        if ( !is_numeric( $percentage ) || ($percentage = ( int ) $percentage) < 0 || $percentage > 100 ) {
            trigger_error( "Invalid factor", E_USER_ERROR );
        }

        // Check shift method
        foreach ( array( $valid_shift_down_args, $valid_shift_up_args ) as $options ) {
            foreach ( $options as $method ) {
                if ( $method == $shift_method ) {
                    $valid_shift_option = !$valid_shift_option;
                    $shift_method = ( $current_set === 1 ) ? '+' : '-';
                    break 2;
                }
            }
            ++$current_set;
        }

        if ( !$valid_shift_option ) {
            trigger_error( "Invalid shift method", E_USER_ERROR );
        }

        // Check Hex string
        switch ( strlen( $supplied_hex = ( str_replace( '#', '', trim( $supplied_hex ) ) ) ) ) {
            case 3:
                if ( preg_match( '/^([0-9a-f])([0-9a-f])([0-9a-f])/i', $supplied_hex ) ) {
                    $supplied_hex = preg_replace( '/^([0-9a-f])([0-9a-f])([0-9a-f])/i', '\\1\\1\\2\\2\\3\\3', $supplied_hex );
                } else {
                    trigger_error( "Invalid hex color value", E_USER_ERROR );
                }
                break;
            case 6:
                if ( !preg_match( '/^[0-9a-f]{2}[0-9a-f]{2}[0-9a-f]{2}$/i', $supplied_hex ) ) {
                    trigger_error( "Invalid hex color value", E_USER_ERROR );
                }
                break;
            default:
                trigger_error( "Invalid hex color length", E_USER_ERROR );
        }

        // Start shifting
        $RGB_values['R'] = hexdec( $supplied_hex[0] . $supplied_hex[1] );
        $RGB_values['G'] = hexdec( $supplied_hex[2] . $supplied_hex[3] );
        $RGB_values['B'] = hexdec( $supplied_hex[4] . $supplied_hex[5] );

        foreach ( $RGB_values as $c => $v ) {
            switch ( $shift_method ) {
                case '-':
                    $amount = round( ((255 - $v) / 100) * $percentage ) + $v;
                    break;
                case '+':
                    $amount = $v - round( ($v / 100) * $percentage );
                    break;
                default:
                    trigger_error( "Oops. Unexpected shift method", E_USER_ERROR );
            }

            $shifted_hex_value .= $current_value = (
                strlen( $decimal_to_hex = dechex( $amount ) ) < 2
                ) ? '0' . $decimal_to_hex : $decimal_to_hex;
        }

        return '#' . $shifted_hex_value;
    }
endif;

/**
 * Get tax term slug
 */
if (!function_exists('gg_tax_terms_slug')) :
    function gg_tax_terms_slug($taxonomy) {
        global $post, $post_id;
        $return = '';
        // get post by post id
        $post = get_post($post->ID);
        // get post type by post
        $post_type = $post->post_type;
        // get post type taxonomies
        $terms = get_the_terms( $post->ID, $taxonomy );
        if ( !empty( $terms ) ) {
            $out = array();
            foreach ( $terms as $term )
                $out[] = 'grid-cat-' . $term->slug;
            $return = join( ' ', $out );
        }
        return $return;
    }
endif;

/**
 * Get taxonomies terms links
 */
if (!function_exists('portfolio_taxonomies_terms_links')) :
    function portfolio_taxonomies_terms_links(){
      global $post;
      // get post by post id
      $post = get_post( $post->ID );

      // get post type by post
      $post_type = 'portfolio_cpt';

      // get post type taxonomies
      $taxonomy_slug = 'portfolio_category';

      $out = array();
        // get the terms related to post
        $terms = get_the_terms( $post->ID, $taxonomy_slug );

        if ( !empty( $terms ) ) {
          //$out[] = "<p class='meta'><span class='post-comments'><i class='icon_menu-square_alt2'>";
          foreach ( $terms as $term ) {
            //$out[] = $term->name;
            $out[] =
              '  <a href="'
            .    get_term_link( $term->slug, $taxonomy_slug ) .'">'
            .    $term->name
            . "</a>\n";
          }
          //$out[] = "</span></p>\n";
        }

      return implode(',', $out );
    }
endif;

/**
 * Display template for pagination.
 *
 */
if (!function_exists('gg_pagination')) :
function gg_pagination($pages = '', $range = 2)
{ 
     $showitems = ($range * 2)+1; 

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }

     if(1 != $pages)
     {
         echo "<ul class=\"pagination\">";

         if($paged > 1 && $showitems < $pages) {
            echo "<li class='pull-left gg-prev-nav'><a href='".esc_url(get_pagenum_link($paged - 1))."'><i class='pe-7s-angle-left pe-3x pe-va'></i></a></li>";
         } else {
            echo "<li class=\"disabled pull-left gg-prev-nav\"><a href='".esc_url(get_pagenum_link($paged - 1))."'><i class='pe-7s-angle-left pe-3x pe-va'></i></a></li>";
         }

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                if ($paged == $i) {
                    echo "<li><span class=\"current\">".esc_html($i)."</span></li>";
                } else {
                    echo "<li><a href='".esc_url(get_pagenum_link($i))."' class=\"inactive\">".esc_html($i)."</a></li>";
                }
             }
         }

         if ($paged < $pages && $showitems < $pages) {
            echo "<li class='pull-right gg-next-nav'><a href=\"".esc_url(get_pagenum_link($paged + 1))."\"><i class='pe-7s-angle-right pe-3x pe-va'></i></a></li>"; 
         } else {
            echo "<li class=\"disabled pull-right gg-next-nav\"><a href=\"".esc_url(get_pagenum_link($paged + 1))."\"><i class='pe-7s-angle-right pe-3x pe-va'></i></a></li>"; 
         }
            
         echo "</ul>\n";
     }
}
endif;

/**
 * Display template for comments and pingbacks.
 *
 */
if (!function_exists('gg_comment')) :
    function gg_comment($comment, $args, $depth)
    {
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' : ?>

                <li <?php comment_class('media, comment'); ?> id="comment-<?php comment_ID(); ?>">
                    <div class="media-body">
                        <p>
                            <?php _e('Pingback:', OKTHEMES_TEXTDOMAIN); ?> <?php comment_author_link(); ?>
                        </p>
                    </div><!--/.media-body -->
                <?php
                break;
            default :
                // Proceed with normal comments.
                global $post; ?>

                <li <?php comment_class('media'); ?> id="li-comment-<?php comment_ID(); ?>">
                        <a href="<?php echo esc_url($comment->comment_author_url); ?>" class="pull-left avatar-holder">
                            <?php echo get_avatar($comment, 42); ?>
                        </a>
                        <div class="media-body">
                            <h4 class="media-heading comment-author vcard">
                                <?php
                                printf('<cite class="fn">%1$s %2$s</cite>',
                                    get_comment_author_link(),
                                    // If current post author is also comment author, make it known visually.
                                    ($comment->user_id === $post->post_author) ? '<span class="label"> ' . __(
                                        'Post author',
                                        OKTHEMES_TEXTDOMAIN
                                    ) . '</span> ' : ''); ?>
                            </h4>
                            <p class="meta">
                                <?php printf('<a href="%1$s"><time datetime="%2$s">%3$s</time></a>',
                                        esc_url(get_comment_link($comment->comment_ID)),
                                        get_comment_time('c'),
                                        sprintf(
                                            __('%1$s at %2$s', OKTHEMES_TEXTDOMAIN),
                                            get_comment_date(),
                                            get_comment_time()
                                        )
                                    ); ?>
                            </p>
                            <p class="reply">
                                <?php comment_reply_link( array_merge($args, array(
                                            'reply_text' => __('<i class="arrow_back"></i> Reply', OKTHEMES_TEXTDOMAIN),
                                            'depth'      => $depth,
                                            'max_depth'  => $args['max_depth']
                                        )
                                    )); ?>
                            </p>

                            <?php if ('0' == $comment->comment_approved) : ?>
                                <p class="comment-awaiting-moderation"><?php _e(
                                    'Your comment is awaiting moderation.',
                                    OKTHEMES_TEXTDOMAIN
                                ); ?></p>
                            <?php endif; ?>

                            <?php comment_text(); ?>
                                                    
                        </div>
                        <!--/.media-body -->
                <?php
                break;
        endswitch;
    }
endif;

/**
 * Function for aq_resize
 */
if (!function_exists('gg_aq_resize')) :
function gg_aq_resize( $attachment_id, $width = null, $height = null, $crop = true, $single = true ) {

    if ( is_null( $attachment_id ) ) 
        return null;

    $image = wp_get_attachment_image_src( $attachment_id, 'full' );

    $return = aq_resize( $image[0], $width, $height, $crop, $single );

    if ( $return ) {
        return $return;
    }
    else {
        return $image[0];
    }
}
endif;

/**
 * Wrap the first word in a span
 */
if (!function_exists('gg_wrap_word')) :
function gg_wrap_word( $title = '', $single = true ) {
    $ARR_title = explode(" ", $title);
    if(sizeof($ARR_title) > 1 ) {
        $ARR_title[0] = "<span class='gg-first-word'>".$ARR_title[0]."</span>";
        return implode(" ", $ARR_title);
    } elseif ($single == true) {
        return "<span class='gg-single-first-word'>".$title."</span>";
    } else {
        return $title;
    }
}
endif;

/**
 * Wrap the last character in a span
 */
if (!function_exists('gg_wrap_last_char')) :
function gg_wrap_last_char( $title = '' ) {
    if ( is_rtl() ) {
      return $title;
    } else {
      return preg_replace('/(.)$/', '<span class="gg-last-char">\1</span>', $title);
    }
    
}
endif;


/**
 * Check if element comes from VC
 */
if (!function_exists('gg_is_in_vc')) :
function gg_is_in_vc() {
    $classes = get_body_class();
    if (in_array('blog',$classes) || in_array('single',$classes) || in_array('search',$classes) || in_array('archive',$classes) || in_array('category',$classes)) {
        return false;
    } else {
        return true;
    }
}
endif;

if ( ! function_exists( 'gg_footer_social' ) ) :
/**
 * Display page footer message box
*/
function gg_footer_social() {
    $post_id = gg_global_page_id();
    $footer_social = _get_field('gg_page_social',$post_id,true);
    ?>

    <?php if ($footer_social) { ?>
    <div class="footer-social">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="nav nav-pills nav-justified">
                    <?php if(get_theme_mod('facebook_link')): ?>
                    <li><a class="social-facebook" href="<?php echo esc_url(get_theme_mod('facebook_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Facebook','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe227;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('twitter_link','okwpthemes')): ?>
                    <li><a class="social-twitter" href="<?php echo esc_url(get_theme_mod('twitter_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Twitter','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe287;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('instagram_link')): ?>
                    <li><a class="social-instagram" href="<?php echo esc_url(get_theme_mod('instagram_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Instagram','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe300;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('pinterest_link')): ?>
                    <li><a class="social-pinterest" href="<?php echo esc_url(get_theme_mod('pinterest_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Pinterest','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe264;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('google_link')): ?>
                    <li><a class="social-google" href="<?php echo esc_url(get_theme_mod('google_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Google +','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe239;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('vimeo_link')): ?>
                    <li><a class="social-vimeo" href="<?php echo esc_url(get_theme_mod('vimeo_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Vimeo','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe289;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('youtube_link')): ?>
                    <li><a class="social-youtube" href="<?php echo esc_url(get_theme_mod('youtube_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Youtube','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe299;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('linkedin_link')): ?>
                    <li><a class="social-linkedin" href="<?php echo esc_url(get_theme_mod('linkedin_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Linkedin','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe252;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('flickr_link')): ?>
                    <li><a class="social-flickr" href="<?php echo esc_url(get_theme_mod('flickr_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Flickr','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe229;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('dribble_link')): ?>
                    <li><a class="social-dribble" href="<?php echo esc_url(get_theme_mod('dribble_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Dribbble','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe221;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('forrst_link')): ?>
                    <li><a class="social-forrst" href="<?php echo esc_url(get_theme_mod('forrst_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Forrst','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe231;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('tumblr_link')): ?>
                    <li><a class="social-tumblr" href="<?php echo esc_url(get_theme_mod('tumblr_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Tumblr','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe285;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('deviantart_link')): ?>
                    <li><a class="social-deviantart" href="<?php echo esc_url(get_theme_mod('deviantart_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Deviantart','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe218;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('foursquare_link')): ?>
                    <li><a class="social-foursquare" href="<?php echo esc_url(get_theme_mod('foursquare_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Foursquare','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe232;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('github_link')): ?>
                    <li><a class="social-github" href="<?php echo esc_url(get_theme_mod('github_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Github','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe236;</span></a></li>
                    <?php endif; ?>
                    <?php if(get_theme_mod('skype_link')): ?>
                    <li><a class="social-skype" href="<?php echo esc_url(get_theme_mod('skype_link')); ?>" target="_blank"><span class="hidden-xs"><?php _e('Skype','okthemes'); ?></span><span class="symbol visible-xs-block">&#xe274;</span></a></li>
                    <?php endif; ?>

                  </ul>

                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <?php
}
endif;