<?php
/**
 * Registering meta boxes
 */

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array (
    'key' => 'group_546ef5e7380c4',
    'title' => 'Blog Options',
    'fields' => array (
        array (
            'key' => 'field_546ef5ea14c14',
            'label' => 'Blog layout',
            'name' => 'gg_blog_layout',
            'type' => 'select',
            'instructions' => 'Select the blog layout',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'list' => 'List',
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54cb4cd11649d',
            'label' => 'Blog list thumbnail',
            'name' => 'gg_blog_list_thumbnail',
            'type' => 'true_false',
            'instructions' => 'Show/hide the thumbnail on blog list',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'list',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 0,
        ),
        array (
            'key' => 'field_54cb4d001649e',
            'label' => 'Blog list content',
            'name' => 'gg_blog_list_content',
            'type' => 'true_false',
            'instructions' => 'Show/hide the content on blog list page',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'list',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 0,
        ),
        array (
            'key' => 'field_546f0a785014f',
            'label' => 'Blog layout style',
            'name' => 'gg_blog_layout_style',
            'type' => 'select',
            'instructions' => 'Select the blog layout style',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'masonry',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'fitRows',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546f0aff3a532',
            'label' => 'Blog columns',
            'name' => 'gg_blog_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'fitRows',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_546ef5ea14c14',
                        'operator' => '==',
                        'value' => 'masonry',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54bfb061ff824',
            'label' => 'Number of posts to show',
            'name' => 'gg_blog_no_of_posts_to_show',
            'type' => 'text',
            'instructions' => 'Insert the number of blog posts to show',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 5,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54eedbbefea3b',
            'label' => 'Blog pagination',
            'name' => 'gg_blog_pagination',
            'type' => 'select',
            'instructions' => 'Select the blog pagination',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'numbered' => 'Numbered pagination',
                'ajax_load' => 'Ajax load more pagination',
            ),
            'default_value' => array (
                'numbered' => 'numbered',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_type',
                'operator' => '==',
                'value' => 'posts_page',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/blog.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_54f078a4097a7',
    'title' => 'Coming soon options',
    'fields' => array (
        array (
            'key' => 'field_54f07c34143e1',
            'label' => 'Coming soon',
            'name' => 'gg_coming_soon_text',
            'type' => 'text',
            'instructions' => 'Coming soon text',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Coming soon',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54f07b6d143df',
            'label' => 'Date',
            'name' => 'gg_coming_soon_date',
            'type' => 'date_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'display_format' => 'Y, m, d',
            'return_format' => 'Y, m , d',
            'first_day' => 1,
        ),
        array (
            'key' => 'field_54f07be7143e0',
            'label' => 'Newsletter',
            'name' => 'gg_coming_soon_newsletter',
            'type' => 'true_false',
            'instructions' => 'Enable the newsletter. ',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/coming-soon.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_545fd8502b9c3',
    'title' => 'Contact Page Options',
    'fields' => array (
        array (
            'key' => 'field_546dcd82787e0',
            'label' => 'General',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_546dd01d244b4',
            'label' => 'Address',
            'name' => 'gg_contact_address',
            'type' => 'textarea',
            'instructions' => 'Insert the address.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => 'br',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54bfb479ef2fb',
            'label' => 'Get directions button',
            'name' => 'gg_contact_get_directions',
            'type' => 'true_false',
            'instructions' => 'Enable/disable get directions button',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_546dcfa3244b2',
            'label' => 'Phone',
            'name' => 'gg_contact_phone',
            'type' => 'textarea',
            'instructions' => 'Insert phone numbers here. One phone per line.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'UK: (555) 555 5556',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => 'br',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546dcfd0244b3',
            'label' => 'Email',
            'name' => 'gg_contact_email',
            'type' => 'email',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
        ),
        array (
            'key' => 'field_546dcd2bd9317',
            'label' => 'Contact form',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_545fd8677d64f',
            'label' => 'Contact form',
            'name' => 'gg_contact_form',
            'type' => 'true_false',
            'instructions' => 'Enable/disable contact form. Default: true',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_545fd9b10cb74',
            'label' => 'Email address',
            'name' => 'gg_contact_page_email',
            'type' => 'text',
            'instructions' => 'Enter your email address. On this address you will receive the emails from this contact form.',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546de0476002b',
            'label' => 'From: Email address',
            'name' => 'gg_contact_page_email_from',
            'type' => 'text',
            'instructions' => 'Enter the FROM email address. E.G.: noreply@yoursitename.com',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'noreply@yoursitename.com',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fda0b7c2ec',
            'label' => 'Success text',
            'name' => 'gg_contact_page_success_msg',
            'type' => 'text',
            'instructions' => 'Enter the success message that will be displayed on successful email delivery.',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Your message was sent successfully.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fda6446ed5',
            'label' => 'Error text',
            'name' => 'gg_contact_page_error_msg',
            'type' => 'text',
            'instructions' => 'Enter the error message that will be displayed on    email delivery failure.',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'There was an error submitting the form.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546dcd41d9318',
            'label' => 'Map',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_545fdaaede793',
            'label' => 'Map',
            'name' => 'gg_contact_map',
            'type' => 'true_false',
            'instructions' => 'Enable/disable map. Default: true',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_545fdacdde794',
            'label' => 'Latitude',
            'name' => 'gg_contact_map_latitude',
            'type' => 'text',
            'instructions' => 'Enter the latitude value of your location in this format 51.13456
Latitude value is the first string (before comma) of google map address. E.G.: 51.13456, -1.34333',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb0853b00',
            'label' => 'Longitude',
            'name' => 'gg_contact_map_longitude',
            'type' => 'text',
            'instructions' => 'Enter the longitude value of your location in this format -1.34333
Latitude value is the second string (after comma) of google map address. E.G.: 51.13456, -1.34333',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb2b53b01',
            'label' => 'Zoom',
            'name' => 'gg_contact_zoom',
            'type' => 'text',
            'instructions' => 'Insert the zoom level. Default: 10',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb5153b02',
            'label' => 'InfoWindow',
            'name' => 'gg_contact_map_infowindow',
            'type' => 'textarea',
            'instructions' => 'Insert your address details. Will appear after you click on the marker icon. HTML supported.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => 'wpautop',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb8053b03',
            'label' => 'InfoWindow title',
            'name' => 'gg_contact_map_infowindow_title',
            'type' => 'text',
            'instructions' => 'Insert the infoWindow title. Will appear only on marker hover.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/contact.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'left',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546cd8557271d',
    'title' => 'Page Layout',
    'fields' => array (
        array (
            'key' => 'field_546efd85462c2',
            'label' => 'Page container',
            'name' => 'gg_page_container_select',
            'type' => 'select',
            'instructions' => 'Select the page container',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1170 => '1170px container',
                'fullscreen' => 'Fullscreen',
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546cd877c748e',
            'label' => 'Page layout',
            'name' => 'gg_page_layout_select',
            'type' => 'select',
            'instructions' => 'Select the page layout',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'with_right_sidebar' => 'With right sidebar',
                'with_left_sidebar' => 'With left sidebar',
                'no_sidebar' => 'No sidebar',
            ),
            'default_value' => array (
                'with_right_sidebar' => 'with_right_sidebar',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'default',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/blog.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/contact.php',
            ),
        ),
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'post',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/portfolio.php',
            ),
        ),
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'product',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_5464cf5f3e820',
    'title' => 'Page Options',
    'fields' => array (
        array (
            'key' => 'field_5464cfec33375',
            'label' => 'Page header',
            'name' => 'gg_page_header',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => 'Enable/Disable page header.',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_5464d01033376',
            'label' => 'Page title',
            'name' => 'gg_page_title',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cfec33375',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => 'Enable/Disable page title.',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_54bfb010bea18',
            'label' => 'Page footer social media',
            'name' => 'gg_page_social',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cfec33375',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => 'Enable/Disable page social',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_54f583ac1144c',
            'label' => 'Page footer style',
            'name' => 'gg_page_footer_style',
            'type' => 'select',
            'instructions' => 'Select the footer style',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'dark' => 'Dark',
                'light' => 'light',
            ),
            'default_value' => array (
                'dark' => 'dark',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_5464d02f33377',
            'label' => 'Page description',
            'name' => 'gg_page_description',
            'type' => 'textarea',
            'instructions' => 'Insert your page short description here.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cfec33375',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => 'wpautop',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54db8281fda4a',
            'label' => 'Page title & description position',
            'name' => 'gg_page_title_description_position',
            'type' => 'select',
            'instructions' => 'Select the title and description position',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cfec33375',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'center' => 'Center',
                'left' => 'Left',
                'right' => 'Right',
            ),
            'default_value' => array (
                'center' => 'center',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54af910f75f0e',
            'label' => 'Page header slideshow',
            'name' => 'gg_page_header_slider',
            'type' => 'true_false',
            'instructions' => 'Enable/disable page slideshow',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 0,
        ),
        array (
            'key' => 'field_54af96c4857a4',
            'label' => 'Slideshow',
            'name' => 'gg_page_header_slider_select',
            'type' => 'select',
            'instructions' => 'Select the slideshow',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54af910f75f0e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'home_v2' => 'home_v2',
                'home_v1' => 'home_v1',
                'home_v6' => 'home_v6',
                'home_v3' => 'home_v3',
                'home_v4' => 'home_v4',
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54eb317a2df70',
            'label' => 'Slider position',
            'name' => 'gg_page_header_slider_position',
            'type' => 'select',
            'instructions' => 'Select how the slider will be displayed.',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54af910f75f0e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'under_header' => 'Under the header',
                'bellow_header' => 'Bellow the header',
            ),
            'default_value' => array (
                'under_header' => 'under_header',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'default',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/blog.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/contact.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/portfolio.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_54d0cd3f95809',
    'title' => 'Portfolio Item Options',
    'fields' => array (
        array (
            'key' => 'field_54d0cd7c84b5a',
            'label' => 'Portfolio item click',
            'name' => 'gg_select_portfolio_open_type',
            'type' => 'select',
            'instructions' => 'Select what to open when you click on the portfolio item.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'nothing' => 'Nothing',
                'lightbox_image' => 'An image in lightbox',
                'lightbox_video' => 'A video in lightbox',
                'custom_url' => 'A custom URL',
                'separate_page' => 'Portfolio item content in an separate page',
            ),
            'default_value' => array (
                'nothing' => 'nothing',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54d0ce1743340',
            'label' => 'Portfolio item lightbox image',
            'name' => 'gg_port_item_lightbox_image',
            'type' => 'image',
            'instructions' => 'Upload the image used in lightbox.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0cd7c84b5a',
                        'operator' => '==',
                        'value' => 'lightbox_image',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
        array (
            'key' => 'field_54d0ce52ee3ff',
            'label' => 'Portfolio item lightbox video',
            'name' => 'gg_port_item_lightbox_video',
            'type' => 'text',
            'instructions' => 'Insert the video link (Vimeo or Youtube)',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0cd7c84b5a',
                        'operator' => '==',
                        'value' => 'lightbox_video',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54d0ce7dee400',
            'label' => 'Custom URL',
            'name' => 'gg_port_item_custom_url',
            'type' => 'url',
            'instructions' => 'Insert a custom URL here. The portfolio item will link to this URL instead of the default one (the one that sends you to the portfolio details page)',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0cd7c84b5a',
                        'operator' => '==',
                        'value' => 'custom_url',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
        ),
        array (
            'key' => 'field_54d0cea3ee401',
            'label' => 'Portfolio post slideshow images',
            'name' => 'gg_port_post_slideshow_image',
            'type' => 'gallery',
            'instructions' => 'Upload the images used portfolio item page slideshow.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0cd7c84b5a',
                        'operator' => '==',
                        'value' => 'separate_page',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'portfolio_cpt',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_54d0bbff402a5',
    'title' => 'Portfolio Options',
    'fields' => array (
        array (
            'key' => 'field_54d0bbff52a4c',
            'label' => 'Portfolio layout',
            'name' => 'gg_portfolio_layout',
            'type' => 'select',
            'instructions' => 'Select the portfolio layout',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
                'carousel' => 'Carousel style',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54d0bbff53629',
            'label' => 'Portfolio layout style',
            'name' => 'gg_portfolio_layout_style',
            'type' => 'select',
            'instructions' => 'Select the portfolio layout style',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'fitRows',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'masonry',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54d0bbff539ed',
            'label' => 'Portfolio columns',
            'name' => 'gg_portfolio_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 1,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'fitRows',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'masonry',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54d0bbff53dd9',
            'label' => 'Number of posts to show',
            'name' => 'gg_portfolio_no_of_posts_to_show',
            'type' => 'text',
            'instructions' => 'Insert the number of portfolio posts to show',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54f09153f4468',
            'label' => 'Portolio pagination',
            'name' => 'gg_portfolio_pagination',
            'type' => 'select',
            'instructions' => 'Select the portfolio pagination',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'fitRows',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_54d0bbff52a4c',
                        'operator' => '==',
                        'value' => 'masonry',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'numbered' => 'Numbered pagination',
                'ajax_load' => 'Ajax load more pagination',
            ),
            'default_value' => array (
                'numbered' => 'numbered',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/portfolio.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546f25c33193d',
    'title' => 'Post Options',
    'fields' => array (
        array (
            'key' => 'field_546f25d44af1e',
            'label' => 'Social share',
            'name' => 'gg_post_social_share',
            'type' => 'true_false',
            'instructions' => 'Enable/Disable social share on post',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_54bfb0c1e5f56',
            'label' => 'Post navigation',
            'name' => 'gg_post_navigation',
            'type' => 'true_false',
            'instructions' => 'Enable/Disable the posts navigation',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'post',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

endif;