<?php

/*
 * Remove default stylesheet
 */
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

/**
 * Suppress certain WooCommerce admin notices
 */
function gg_voux_wc_suppress_nags() {
    if ( class_exists( 'WC_Admin_Notices' ) ) {
        // Remove the "you have outdated template files" nag
        WC_Admin_Notices::remove_notice( 'template_files' );
        
        // Remove the "install pages" and "wc-install" nag
        WC_Admin_Notices::remove_notice( 'install' );
    }
}
add_action( 'wp_loaded', 'gg_voux_wc_suppress_nags', 99 );


/**
 * Load JavaScript and jQuery files for theme.
 *
 */
function gg_wc_scripts_loader() {
    wp_enqueue_script('woo-inputs', get_template_directory_uri() . '/js/woocommerce.js', array('jquery'), OKTHEMES_THEMEVERSION, true); 
}
add_action('wp_enqueue_scripts', 'gg_wc_scripts_loader');


/**
 * Hide shop page title
 */
add_filter('woocommerce_show_page_title', 'remove_shop_page_title' );
function remove_shop_page_title() {
    return false;
}

/** 
 * Remove tab headings
 */
add_filter('woocommerce_product_description_heading', 'gg_clear_tab_headings');
add_filter('woocommerce_product_additional_information_heading', 'gg_clear_tab_headings');
function gg_clear_tab_headings() {
    return '';
}

// Remove the product rating display on product loops
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
// Remove the product rating display on product single
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );

//Move the product tabs 
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 );

//Move product meta after tabs 
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 70 );

/*
 * Add custom pagination
 */
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);
function woocommerce_pagination() {
        gg_pagination();       
    }
add_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10);

function gg_open_wc_ordering_wrapper(){
    echo '<div class="gg-wc-ordering-wrapper">';
}

function gg_close_wc_ordering_wrapper(){
    echo '</div>';
}

add_action( 'woocommerce_before_shop_loop', 'gg_open_wc_ordering_wrapper', 10);
add_action( 'woocommerce_before_shop_loop', 'gg_close_wc_ordering_wrapper', 40);

/*
 * Allow shortcodes in product excerpts
 */
if (!function_exists('woocommerce_template_single_excerpt')) {
   function woocommerce_template_single_excerpt( $post ) {
       global $post;
       if ($post->post_excerpt) echo '<div itemprop="description">' . do_shortcode(wpautop(wptexturize($post->post_excerpt))) . '</div>';
   }
}

/*
 * Change number of products per row
 */
add_filter('loop_shop_columns', 'loop_columns');
if (!function_exists('loop_columns')) {
    function loop_columns() {
        return get_theme_mod('shop_product_columns','3');
    }
}

/*
 * Products per page
 */
add_filter('loop_shop_per_page',  'show_products_per_page');
function show_products_per_page() {
    $product_per_page = get_theme_mod('product_per_page','12');
    return $product_per_page;
}

/**
 * Add search fragment
 */
function woocommerceframework_add_search_fragment ( $settings ) {
    $settings['add_fragment'] = '?post_type=product';
    return $settings;
}



/**
 * Enable/Disable Sale Flash
 */
if ( get_theme_mod('store_sale_flash', 1) == 0 ) {
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
}
else {
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
    add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
}

/**
 * Enable/Disable Products price
 */
if ( get_theme_mod('store_products_price', 1) == 0 ) {
    remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
}
else {
    remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
    add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
}

/**
 * Enable/Disable Add to cart
 */

if ( get_theme_mod('store_add_to_cart', 1) == 0 ) {
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart',10);
}
else {
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
    add_action('woocommerce_before_shop_loop_item_title','woocommerce_template_loop_add_to_cart',30);
}

/**
 * Options for product page
 */

if ( get_theme_mod('product_sale_flash', 1) == 0 ) {    
    remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
}

if ( get_theme_mod('product_products_price', 1) == 0 ) {    
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
}

if ( get_theme_mod('product_products_excerpt', 1) == 0 ) {  
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
}

if ( get_theme_mod('product_add_to_cart', 1) == 0 ) {
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
}

if ( get_theme_mod('product_products_meta', 1) == 0 ) {
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
}

/**
 * Enable/Disable Review tab
 */
if ( get_theme_mod('product_reviews_tab', 1) == 0 ) {
add_filter( 'woocommerce_product_tabs', 'gg_woo_remove_reviews_tab', 98);
    function gg_woo_remove_reviews_tab($tabs) {
        unset($tabs['reviews']);
        return $tabs;
    }
}

/**
 * Enable/Disable Description tab
 */
if ( get_theme_mod('product_description_tab', 1) == 0 ) {
add_filter( 'woocommerce_product_tabs', 'gg_woo_remove_description_tab', 98);
    function gg_woo_remove_description_tab($tabs) {
        unset($tabs['description']);
        return $tabs;
    }
}

/**
 * Enable/Disable Attributes tab
 */
if ( get_theme_mod('product_attributes_tab', 1) == 0 ) {
add_filter( 'woocommerce_product_tabs', 'gg_woo_remove_attributes_tab', 98);
    function gg_woo_remove_attributes_tab($tabs) {
        unset($tabs['attributes']);
        return $tabs;
    }
}

/**
 * Enable/Disable Related products
 */
if ( get_theme_mod('product_related_products', 1) == 0 ) {
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
} else {
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
    add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
}

//Display related products based on the number of columns the page has
add_filter( 'woocommerce_output_related_products_args', 'gg_related_products' );
function gg_related_products() {
    $page_layout = get_theme_mod('product_page_layout', 'no_sidebar');
    switch ($page_layout) {
        case "with_right_sidebar":
        case "with_left_sidebar":
            $args = array('posts_per_page' => 3, 'columns' => 3,);
            break;
        case "no_sidebar":
            $args = array('posts_per_page' => 4, 'columns' => 4,);
            break;           
    }
    return $args;
}

/**
 * Enable/Disable Up Sells products
 */
if ( get_theme_mod('product_upsells_products', 1) == 0 ) {
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
} else {
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
    add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_upsells', 15 );
}
if ( ! function_exists( 'woocommerce_output_upsells' ) ) {
    function woocommerce_output_upsells() {
        
        $page_layout = get_theme_mod('product_page_layout', 'no_sidebar');
        switch ($page_layout) {
            case "with_right_sidebar":
            case "with_left_sidebar":
                woocommerce_upsell_display( 3,3 ); // Display 4 products in rows of 4
                break;
            case "no_sidebar":
                woocommerce_upsell_display( 4,4 ); // Display 4 products in rows of 4
                break;           
        }
    }
}

// Remove WooCommerce Catalog Ordering Dropdown
//remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
//remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20);

/**
 * Enable/Disable Cross Sells products
 */
if ( get_theme_mod('product_crosssells_products' , 1) == 0) {
    remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
    //remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display', 20 );
}

/**
 * Catalog mode functions (must be always the last function)
 **/

if (get_theme_mod('store_catalog_mode' , 0) == 1) {
    // Remove add to cart button from the product loop
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart',10);
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );

    // Remove add to cart button from the product details page
    remove_action( 'woocommerce_before_add_to_cart_form', 'woocommerce_template_single_product_add_to_cart', 10, 2);
     
    //disabled actions (add to cart, checkout and pay)
    remove_action( 'init', 'woocommerce_add_to_cart_action', 10);
    remove_action( 'init', 'woocommerce_checkout_action', 10 );
    remove_action( 'init', 'woocommerce_pay_action', 10 );

    // check for clear-cart get param to clear the cart
    add_action( 'init', 'woocommerce_clear_cart_url' );
    function woocommerce_clear_cart_url() {    
        global $woocommerce;
        if ( isset( $_GET['empty-cart'] ) ) { 
            $woocommerce->cart->empty_cart(); 
        }    
    }

}


// Handle cart in header fragment for ajax add to cart
add_filter('woocommerce_add_to_cart_fragments', 'woocommerceframework_header_add_to_cart_fragment');
function woocommerceframework_header_add_to_cart_fragment( $fragments ) {
    //global $woocommerce;
    ob_start();
    ?>

    <li class="gg-woo-mini-cart pull-right">

    <a class="dropdown-toggle cart-parent" aria-haspopup="true" data-toggle="dropdown" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'okthemes'); ?>">
        <i class="pe-7s-shopbag pe-2x pe-va"></i>
        <span class="<?php if (WC()->cart->cart_contents_count == 0) echo 'gg-cart-empty'; ?>"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
        <?php 
        if (WC()->cart->cart_contents_count > 0) {
            echo ' <span class="gg-multiplier">x</span> ' . WC()->cart->get_cart_total();
        } 
        ?>
    </a>
    <?php

    echo '<ul class="cart_list dropdown-menu">';
       if (sizeof(WC()->cart->cart_contents)>0) : foreach (WC()->cart->cart_contents as $cart_item_key => $cart_item) :
           $_product = $cart_item['data'];
           if ($_product->exists() && $cart_item['quantity']>0) :
                echo '<li class="cart_list_product"><a href="'.esc_url(get_permalink($cart_item['product_id'])).'">';
               
                if (has_post_thumbnail($cart_item['product_id'])) {
                    $alt = get_post_meta($cart_item['product_id'], '_wp_attachment_image_alt', true);
                    $img_src = gg_aq_resize( get_post_thumbnail_id($cart_item['product_id']), 60, 90, true, true );
                    echo '<img src="'.esc_url($img_src).'" alt="'.$alt.'" />';
                } 

               echo apply_filters('woocommerce_cart_widget_product_title', $_product->get_title(), $_product).'</a>';
               
               if($_product instanceof woocommerce_product_variation && is_array($cart_item['variation'])) :
                   echo woocommerce_get_formatted_variation( $cart_item['variation'] );
                 endif;
               
               echo '<span class="quantity">' .esc_html($cart_item['quantity']).' &times; '.wc_price($_product->get_price()).'</span></li>';
           endif;
       endforeach;

        else: echo '<li class="empty">'.esc_html__('No products in the cart.','okthemes').'</li>'; endif;
        if (sizeof(WC()->cart->cart_contents)>0) :
        echo '<li class="total"><span class="total-title">';

        if (get_option('js_prices_include_tax')=='yes') :
            _e('Cart Total', 'okthemes');
        else :
            _e('Cart Subtotal', 'okthemes');
        endif;

        echo '</span>'.WC()->cart->get_cart_total().'</li>';

        echo '<li class="buttons"><a href="'.esc_url(wc_get_cart_url()).'" class="minicart-btn">'.esc_html__('View Cart','okthemes').'</a> <a href="'.esc_url(wc_get_checkout_url()).'" class="minicart-btn checkout">'.esc_html__('Checkout','okthemes').'</a></li>';
    endif;
    
    echo '</ul>';

    ?>

    </li>

    <?php
    $fragments['li.gg-woo-mini-cart'] = ob_get_clean();
    return $fragments;

}

/**
 * Minicart function
 **/
if (!function_exists('header_mini_cart')) { 
function header_mini_cart() { 
?>

<li class="gg-woo-mini-cart pull-right">

<a class="dropdown-toggle cart-parent" aria-haspopup="true" data-toggle="dropdown" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'okthemes'); ?>">
    <i class="pe-7s-shopbag pe-2x pe-va"></i>
    <span class="<?php if (WC()->cart->cart_contents_count == 0) echo 'gg-cart-empty'; ?>"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
    <?php if (WC()->cart->cart_contents_count > 0) {
        echo ' <span class="gg-multiplier">x</span> ' . WC()->cart->get_cart_total();
    } ?>
</a>

<?php
    
    echo '<ul class="cart_list dropdown-menu">';
       if (sizeof(WC()->cart->cart_contents)>0) : foreach (WC()->cart->cart_contents as $cart_item_key => $cart_item) :
           $_product = $cart_item['data'];
           if ($_product->exists() && $cart_item['quantity']>0) :
               echo '<li class="cart_list_product"><a href="'.esc_url(get_permalink($cart_item['product_id'])).'">';
               
               if (has_post_thumbnail($cart_item['product_id'])) {
                    $alt = get_post_meta($cart_item['product_id'], '_wp_attachment_image_alt', true);
                    $img_src = gg_aq_resize( get_post_thumbnail_id($cart_item['product_id']), 60, 90, true, true );
                    echo '<img src="'.esc_url($img_src).'" alt="'.$alt.'" />';
                }
               
               echo apply_filters('woocommerce_cart_widget_product_title', $_product->get_title(), $_product).'</a>';
               
               if($_product instanceof woocommerce_product_variation && is_array($cart_item['variation'])) :
                   echo woocommerce_get_formatted_variation( $cart_item['variation'] );
                 endif;
               
               echo '<span class="quantity">' .esc_html($cart_item['quantity']).' &times; '.wc_price($_product->get_price()).'</span></li>';
           endif;
       endforeach;

        else: echo '<li class="empty">'.esc_html__('No products in the cart.','okthemes').'</li>'; endif;
        if (sizeof(WC()->cart->cart_contents)>0) :
        echo '<li class="total"><span class="total-title">';

        if (get_option('js_prices_include_tax')=='yes') :
            _e('Cart Total', 'okthemes');
        else :
            _e('Cart Subtotal', 'okthemes');
        endif;
        echo '</span>'.WC()->cart->get_cart_total().'</li>';

        echo '<li class="buttons"><a href="'.esc_url(wc_get_cart_url()).'" class="minicart-btn">'.esc_html__('View Cart','okthemes').'</a> <a href="'.esc_url(wc_get_checkout_url()).'" class="minicart-btn checkout">'.esc_html__('Checkout','okthemes').'</a></li>';
    endif;
    echo '</ul>';
?>

</li>

<?php } 

}

/* Wishlist Yith */
if ( class_exists( 'YITH_WCWL_Init' ) ) { 
    if (get_theme_mod('store_add_to_wishlist', 1 ) == 1) { 

        function yit_change_wishlist_label() {
            return __( 'Add to Wishlist', 'okthemes' );
        }    

        function yit_change_browse_wishlist_label() {
            return __( 'View Wishlist', 'okthemes' );
        }

        add_filter( 'yith_wcwl_button_label', 'yit_change_wishlist_label' );
        add_filter( 'yith-wcwl-browse-wishlist-label', 'yit_change_browse_wishlist_label' );

        update_option( 'yith_wcwl_use_button', 'no' );
        update_option( 'yith_wcwl_button_position', 'shortcode' );
        update_option ('yith_wcwl_wishlist_title', '');

        //update_option ('yith_wcwl_share_fb', '0');
        //update_option ('yith_wcwl_share_twitter', '0');
        //update_option ('yith_wcwl_share_pinterest', '0');
        //update_option ('yith_wcwl_share_googleplus', '0');
        //update_option ('yith_wcwl_share_email', '0');
    }
}

if ( class_exists( 'YITH_WCMG' ) ) {
    update_option ('yith_wcmg_zoom_mobile_position', 'inside');
    update_option ('yith_wcmg_slider_items', '6');
}



add_action( 'woocommerce_single_product_summary', 'gg_add_wishlist', 35 );
function gg_add_wishlist() {
    if ( class_exists( 'YITH_WCWL_Init' ) ) { 
        if (get_theme_mod('store_add_to_wishlist', 1 ) == 1) {
            echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
        } 
    }
}

/**
 * Add product share under the images in product page
 */
add_action( 'woocommerce_before_single_product_summary', 'gg_product_share', 30 );
function gg_product_share() {
    get_template_part( 'parts/part', 'socialsharewc' );
}

/**
 * Remove cart totals from cart collaterals for WooCommerce 2.3.8
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals', 10 );

/**
 * Add Sold out badge
 */
include (PARENT_DIR.'/lib/woocommerce-sold-out.php');

/**
 * Add Products per page
 */
include (PARENT_DIR.'/lib/woocommerce-products-pp.php');