<?php
$headings_array = array(
   __("Heading 1", "js_composer")         => "h1", 
   __("Heading 2", "js_composer")         => "h2", 
   __("Heading 3", "js_composer")         => "h3", 
   __("Heading 4", "js_composer")         => "h4",
   __("Heading 5", "js_composer")         => "h5",
   __("Heading 6", "js_composer")         => "h6"
);

$add_css_animation = array(
    "type" => "dropdown",
    "heading" => __("CSS Animation", "js_composer"),
    "param_name" => "css_animation",
    "admin_label" => true,
    "value" => array(__("No", "js_composer") => '', __("Top to bottom", "js_composer") => "top-to-bottom", __("Bottom to top", "js_composer") => "bottom-to-top", __("Left to right", "js_composer") => "left-to-right", __("Right to left", "js_composer") => "right-to-left", __("Appear from center", "js_composer") => "appear"),
    "description" => __("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "js_composer")
  );

$align_array = array(
   __("Align left", "js_composer")         => "pull-left", 
   __("Align right", "js_composer")        => "pull-right", 
   __("Align center", "js_composer")       => "pull-center"
);

$portfolio_col_select_array = array(
   __("Two columns", "js_composer")       => "two_columns", 
   __("Three columns", "js_composer")     => "three_columns", 
   __("Four columns", "js_composer")      => "four_columns"
);

$team_col_select_array = array(
   __("Two columns", "js_composer")       => "two_columns", 
   __("Three columns", "js_composer")     => "three_columns", 
   __("Four columns", "js_composer")      => "four_columns"
);

$testimonials_col_select_array = array(
   __("One column", "js_composer")        => "one_column",
   __("Two columns", "js_composer")       => "two_columns", 
   __("Three columns", "js_composer")     => "three_columns"
);

//Default VC arrays

$colors = array(
   'Blue' => 'blue', // Why __( 'Blue', 'js_composer' ) doesn't work?
   'Turquoise' => 'turquoise',
   'Pink' => 'pink',
   'Violet' => 'violet',
   'Peacoc' => 'peacoc',
   'Chino' => 'chino',
   'Mulled Wine' => 'mulled_wine',
   'Vista Blue' => 'vista_blue',
   'Black' => 'black',
   'Grey' => 'grey',
   'Orange' => 'orange',
   'Sky' => 'sky',
   'Green' => 'green',
   'Juicy pink' => 'juicy_pink',
   'Sandy brown' => 'sandy_brown',
   'Purple' => 'purple',
   'White' => 'white'
);

$sizes = array(
   'Mini' => 'btn-mini',
   'Small' => 'btn-small',
   'Normal' => 'md',
   'Large' => 'btn-large'
);

$button_styles = array(
   'Rounded' => 'rounded',
   'Square' => 'square',
   'Round' => 'round',
   'Outlined' => 'outlined',
   //'3D' => '3d',
   'Square Outlined' => 'square_outlined'
);

$cta_styles = array(
   'Rounded' => 'rounded',
   'Square' => 'square',
   'Round' => 'round',
   'Outlined' => 'outlined',
   'Square Outlined' => 'square_outlined'
);

$txt_align = array(
   'Left' => 'left',
   'Right' => 'right',
   'Center' => 'center',
   'Justify' => 'justify'
);

$el_widths = array(
   '100%' => '',
   '90%' => '90',
   '80%' => '80',
   '70%' => '70',
   '60%' => '60',
   '50%' => '50'
);

$sep_styles = array(
   'Border' => '',
   'Dashed' => 'dashed',
   'Dotted' => 'dotted',
   'Double' => 'double'
);

$box_styles = array(
   'Default' => '',
   'Rounded' => 'vc_box_rounded',
   'Border' => 'vc_box_border',
   'Outline' => 'vc_box_outline',
   'Shadow' => 'vc_box_shadow',
   'Bordered shadow' => 'vc_box_shadow_border',
   '3D Shadow' => 'vc_box_shadow_3d',
   'Circle' => 'vc_box_circle', //new
   'Circle Border' => 'vc_box_border_circle', //new
   'Circle Outline' => 'vc_box_outline_circle', //new
   'Circle Shadow' => 'vc_box_shadow_circle', //new
   'Circle Border Shadow' => 'vc_box_shadow_border_circle' //new
);

$target_arr = array(
   __( 'Same window', 'js_composer' ) => '_self',
   __( 'New window', 'js_composer' ) => "_blank"
);

$img_style_arr = array(
   __( 'Default (Square corners)', 'okthemes' ) => "default",
   __( 'Rounded corners', 'okthemes' ) => "rounded",
   __( 'Circle', 'okthemes' ) => "circle"
);


$gg_icons_array = array();

// Initialising Shortcodes
if (class_exists('WPBakeryVisualComposerAbstract')) {

   /**
    * Taxonomy checkbox list field.
    *
    */
   function gg_taxonomy_settings_field($settings, $value) {
      $dependency = vc_generate_dependencies_attributes($settings);

      $terms_fields = array();
      $terms_slugs = array();

      $value_arr = $value;
      if ( !is_array($value_arr) ) {
         $value_arr = array_map( 'trim', explode(',', $value_arr) );
      }

      if ( !empty($settings['taxonomy']) ) {

         $terms = get_terms( $settings['taxonomy'] );
         if ( $terms && !is_wp_error($terms) ) {

            foreach( $terms as $term ) {
               $terms_slugs[] = $term->slug;

               $terms_fields[] = sprintf(
                  '<label><input id="%s" class="%s" type="checkbox" name="%s" value="%s" %s/>%s</label>',
                  $settings['param_name'] . '-' . $term->slug,
                  $settings['param_name'].' '.$settings['type'],
                  $settings['param_name'],
                  $term->term_id,
                  checked( in_array( $term->term_id, $value_arr ), true, false ),
                  $term->name
               );
            }
         }
      }

      return '<div class="gg_taxonomy_block">'
            .'<input type="hidden" name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-checkboxes '.$settings['param_name'].' '.$settings['type'].'_field" value="'.$value.'" '.$dependency.' />'
             .'<div class="gg_taxonomy_terms">'
             .implode( $terms_fields )
             .'</div>'
          .'</div>';
   }
   vc_add_shortcode_param('gg_taxonomy', 'gg_taxonomy_settings_field', get_template_directory_uri() . '/lib/visualcomposer/gg-taxonomy.js' );

   /**
    * Posts checkbox list field.
    *
    */
   function gg_posttype_settings_field($settings, $value) {
      $dependency = vc_generate_dependencies_attributes($settings);

      $posts_fields = array();
      $terms_slugs = array();

      $value_arr = $value;
      if ( !is_array($value_arr) ) {
         $value_arr = array_map( 'trim', explode(',', $value_arr) );
      }

      if ( !empty($settings['posttype']) ) {

         $args = array(
            'no_found_rows' => 1,
            'ignore_sticky_posts' => 1,
            'posts_per_page' => -1,
            'post_type' => $settings['posttype'],
            'post_status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC'
         );

         $gg_query = new WP_Query( $args );
         if ( $gg_query->have_posts() ) {

            foreach( $gg_query->posts as $p ) {

               $posts_fields[] = sprintf(
                  '<label><input id="%s" class="%s" type="checkbox" name="%s" value="%s" %s/>%s</label>',
                  $settings['param_name'] . '-' . $p->post_name,
                  $settings['param_name'] . ' ' . $settings['type'],
                  $settings['param_name'],
                  $p->post_name,
                  checked( in_array( $p->post_name, $value_arr ), true, false ),
                  $p->post_title
               );
            }
         }
      }

      return '<div class="gg_posttype_block">'
            .'<input type="hidden" name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-checkboxes '.$settings['param_name'].' '.$settings['type'].'_field" value="'.$value.'" '.$dependency.' />'
             .'<div class="gg_posttype_post">'
             .implode( $posts_fields )
             .'</div>'
          .'</div>';
   }
   
   vc_add_shortcode_param('gg_posttype', 'gg_posttype_settings_field', get_template_directory_uri() . '/lib/visualcomposer/gg-posttype.js' );
}

?>