<?php
class WPBakeryShortCode_gg_blockquote extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('blockquote', array($this, 'gg_blockquote'));  
   }

   public function gg_blockquote( $atts, $content = null ) { 

         $output = $quote = '';
         extract(shortcode_atts(array(
             'quote'        => '',
         ), $atts));

         $output .= "\n\t".'<blockquote class="gg-vc-quote">';
         $output .= "\n\t".$quote;
         $output .= "\n\t".'</blockquote>';

         return $output;
   }
}

$WPBakeryShortCode_gg_blockquote = new WPBakeryShortCode_gg_blockquote();


vc_map( array(
   "name" => __("Blockquote", "okthemes"),
   "description" => __('Display a blockquote.', 'okthemes'),
   "base" => "blockquote",
   "class" => "clear_vc_style",
   "icon" => "icon-wpb-gg_vc_blockquote",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   'admin_enqueue_js' => array(get_template_directory_uri().'/lib/visualcomposer/custom-vc.js'),
   "category" => __('OKThemes', 'okthemes'),
   "params" => array(
      array(
         "type" => "textarea",
         "heading" => __("Quote", "okthemes"),
         "param_name" => "quote",
         "value" => '',
         "description" => __("Insert quote content here", "okthemes")
      ),
   ),
   //'js_view'  => 'luxuryvillaVcBlockquoteView',
) );

?>