<?php
class WPBakeryShortCode_gg_contact_form extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('contact_form', array($this, 'gg_contact_form'));  
   }

   public function gg_contact_form( $atts, $content = null ) { 

         $output = $email_address = $success_message = $error_message = '';
         extract(shortcode_atts(array(
             'widget_title' => '',
             'email_address'    => '',
             'success_message'  => 'Your message was sent successfully.',
             'error_message'   => 'There was an error submitting the form.'
         ), $atts));

         $randID = rand();          

          $output .= "\n\t".wpb_widget_title(array('title' => $widget_title, 'extraclass' => 'wpb_contactform_heading'));
          
          $output .= "\n\t".'<form class="contact-form-mini" action="'.get_permalink().'" id="contact-form-mini-'.$randID.'" method="post" data-bv-message="This value is not valid" data-bv-feedbackicons-valid="glyphicon glyphicon-ok" data-bv-feedbackicons-invalid="glyphicon glyphicon-remove" data-bv-feedbackicons-validating="glyphicon glyphicon-refresh" data-bv-container="tooltip">';
          $output .= "\n\t".'<div id="cf-msg"></div>';
          $output .= "\n\t\t\t".'<div class="form-group">';
          $output .= "\n\t\t\t\t".'<label class="sr-only" for="name">'. __( 'Name', 'okthemes' ) .'</label>';
          $output .= "\n\t\t\t\t".'<input data-bv-notempty="true" data-bv-notempty-message=" '.__( 'The name is required and cannot be empty', 'okthemes' ).' " placeholder="'. __( 'Name', 'okthemes' ) .'" type="text" name="name" id="name" value="" class="form-control" />';
          $output .= "\n\t\t\t".'</div>';    
          $output .= "\n\t\t\t".'<div class="form-group">';   
          $output .= "\n\t\t\t\t".'<label class="sr-only" for="email">'. __( 'Email', 'okthemes' ) .'</label>';
          $output .= "\n\t\t\t\t".'<input data-bv-notempty="true" data-bv-notempty-message=" '.__( 'The email is required and cannot be empty', 'okthemes' ).' " data-bv-emailaddress="true" data-bv-emailaddress-message="'.__( 'The input is not a valid email address', 'okthemes' ).' " placeholder="'. __( 'Email', 'okthemes' ) .'" type="text" name="email" id="email" value="" class="form-control" />';
          $output .= "\n\t\t\t".'</div>';
          $output .= "\n\t\t\t".'<div class="form-group">';
          $output .= "\n\t\t\t\t".'<label class="sr-only" for="message">'. __( 'Message', 'okthemes' ) .'</label>';
          $output .= "\n\t\t\t\t".'<textarea data-bv-notempty="true" data-bv-notempty-message="'.__( 'The message is required and cannot be empty', 'okthemes' ) .'" rows="3" placeholder="'. __( 'Comments', 'okthemes' ) .'" name="message" id="message" class="form-control"></textarea>';
          $output .= "\n\t\t\t".'</div>';

          $output .= "\n\t\t\t".'<input name="action" type="hidden" value="cf_action" />';
          $output .= "\n\t\t\t".' <input name="post_id" type="hidden" value="'.$randID.'" />';
          $output .= "\n\t\t\t".wp_nonce_field( 'contact_form_html', '_cf_nonce');

          $output .= "\n\t\t\t".'<div class="form-group">';
          $output .= "\n\t\t\t\t".'<button type="submit" id="cfs" class="btn btn-primary">' . __( 'Send', 'okthemes' ) . '</button>';
          $output .= "\n\t\t\t".'</div>';
          $output .= "\n\t".'</form>';

         return $output;
         
   }
}

$WPBakeryShortCode_gg_contact_form = new WPBakeryShortCode_gg_contact_form();  

vc_map( array(
   "name" => __("Contact form","okthemes"),
   "description" => __('Display a mini contact form.', 'okthemes'),
   "base" => "contact_form",
   "class" => "theme_icon_class",
   "icon" => "icon-wpb-gg_vc_contact_form",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   "category" => __('OKThemes','okthemes'),
   "params" => array(
      array(
         "type" => "textfield",
         "heading" => __("Widget title","okthemes"),
         "param_name" => "widget_title",
         "value" => '',
         "admin_label" => true,
         "description" => __("Insert widget title here","okthemes")
      ),
      array(
         "type" => "textfield",
         "heading" => __("Email","okthemes"),
         "param_name" => "email_address",
         "admin_label" => true,
         "description" => __("Insert the contact form email here.","okthemes")
      ),
      array(
          "type" => "textfield",
          "heading" => __('Success message', 'okthemes'),
          "param_name" => "success_message",
          "value" => 'Your message was sent successfully.',
          "description" => __("Insert the success message.", "okthemes")
      ),
      array(
          "type" => "textfield",
          "heading" => __('Error message', 'okthemes'),
          "param_name" => "error_message",
          "value" => 'There was an error submitting the form.',
          "description" => __("Insert the error message.", "okthemes")
      ),

      $add_css_animation,

   )
) );

?>