<?php
class WPBakeryShortCode_gg_counter extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('counter', array($this, 'gg_counter'));  
   }


   public function gg_counter( $atts, $content = null ) { 

         $output = $type = $icon_fontawesome = $icon_openiconic = $icon_typicons = $icon_entypoicons = $icon_linecons = $title = $subtitle = $is_box = $background_style = $padding_style = '';
         $defaults = array(
             'title'            => '',
             'subtitle'         => '',
             'align'            => 'left',
             'number'           => '',
             'font_size'        => '30',
             'font_color'       => '',
             'css_animation'    => '',
             'interval'         => '100',
             'speed'            => '1500',
             'size'             => '',
             'add_icon'         => '',
             'add_box'          => '',
             'add_box'          => '',
             'title_color'      => '',
             'subtitle_color'   => '',
             'icon_color'       => '',
             'box_background'   => '',
             'padding'          => ''
        );

          /** @var array $atts - shortcode attributes */
        $atts = vc_shortcode_attribute_parse( $defaults, $atts );
        extract( $atts );

         wp_enqueue_script('waypoints');
         wp_enqueue_script('countto');

         // Enqueue needed icon font.
        vc_icon_element_fonts_enqueue( $type );

        if($css_animation != ""){
          $clsss_css_animation =  " wpb_animate_when_almost_visible wpb_start_animation wpb_" . $css_animation;
        } else {
          $clsss_css_animation =  "";
        }

        $style = '';
        
        if ($font_size != '') {
          $style .= ' font-size:'.$font_size.'px;';
        }

        if ($font_color != '') {
          $style .= ' color:'.$font_color.';';
        }

        if ($title != '') {
          if ($title_color != "") {
            $title_color = 'style="color:'.$title_color.'"';  
          }
          $title = '<p '.$title_color.'>'.$title.'</p>';
        }

        if ($subtitle != '') {
          if ($subtitle_color != "") {
            $subtitle_color = 'style="color:'.$subtitle_color.'"';  
          }
          $subtitle = '<em '.$subtitle_color.'>'.$subtitle.'</em>';
        }

        if ($add_box == 'use_box') {
          
          $is_box = 'is_box';

          if( $padding != '' ) {
            $padding_style = ' padding: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding) ? $padding : $padding.'px').';';
          }

          if( $box_background != '' ) {
            $background_style = 'background:'.$box_background.';';
          }
        }


       

         $output  = "\n\t".'<div class="counter-holder media '.$clsss_css_animation.' '.$is_box.'" style="text-align:'.$align.'; '.$padding_style.' '.$background_style.' ">';
         

         if ($add_icon == 'use_icon') {
        $output .= "\n\t".'<div class="vc_icon_element vc_icon_element-outer vc_icon_element-align-'.esc_attr( $align ).'">';
        $output .= "\n\t".'<div class="vc_icon_element-inner vc_icon_element-size-'.esc_attr( $size ).'">';
        $output .= "\n\t".'<span class="vc_icon_element-icon '.esc_attr( ${"icon_" . $type} ).'" '.( $icon_color != '' ? 'style="color:' . esc_attr( $icon_color ) . ' !important"' : '' ).'></span>';
        $output .= "\n\t".'</div></div>';

        }


         $output .= "\n\t\t\t".'<div class="counter-content media-body">';
         $output .= "\n\t\t\t\t".'<span style="'.$style.'" class="counter" data-number="'.$number.'" data-interval="'.$interval.'" data-speed="'.$speed.'">'.$number.'</span>';
         $output .= "\n\t\t\t\t".$title;
         $output .= "\n\t\t\t\t".$subtitle;
         $output .= "\n\t\t\t".'</div>';
         $output .= "\n\t".'</div> ';

         return $output;
         
   }
}

$WPBakeryShortCode_gg_counter = new WPBakeryShortCode_gg_counter();  

vc_map( array(
   "name" => __("Counter","okthemes"),
   "description" => __('A counter from 0 to a specified number.', 'okthemes'),
   "base" => "counter",
   "class" => "theme_icon_class",
   "icon" => "icon-wpb-gg_vc_counter",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   "category" => __('OKThemes','okthemes'),
   "params" => array(
      array(
         "type" => "textfield",
         "heading" => __("Title","okthemes"),
         "param_name" => "title",
         "admin_label" => true,
         "description" => __("Insert the title here","okthemes")
      ),
      array(
         "type" => "textfield",
         "heading" => __("Subtitle","okthemes"),
         "param_name" => "subtitle",
         "admin_label" => true,
         "description" => __("Insert the subtitle here","okthemes")
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Title color","okthemes"),
        "param_name" => "title_color",
        "dependency" => Array('element' => "title", 'not_empty' => true)
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Subtitle color","okthemes"),
        "param_name" => "subtitle_color",
        "dependency" => Array('element' => "subtitle", 'not_empty' => true)
      ),
      array(
        "type" => "textfield",
        "heading" => __("Number", "okthemes"),
        "param_name" => "number"
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Number color", "okthemes"),
        "param_name" => "font_color",
        "dependency" => Array('element' => "number", 'not_empty' => true)
      ),
      array(
        "type" => "textfield",
        "heading" => __("Number font size (px)", "okthemes"),
        "param_name" => "font_size",
        "value" => '30',
        "dependency" => Array('element' => "number", 'not_empty' => true)
      ),
      array(
         "type" => "checkbox",
         "heading" => __("Icon?","okthemes"),
         "value" => array(__("Use an icon for your counter.","okthemes") => "use_icon" ),
         "param_name" => "add_icon"
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Icon library', 'js_composer' ),
        'value' => array(
          __( 'Font Awesome', 'js_composer' ) => 'fontawesome',
          __( 'Open Iconic', 'js_composer' ) => 'openiconic',
          __( 'Typicons', 'js_composer' ) => 'typicons',
          __( 'Entypo', 'js_composer' ) => 'entypo',
          __( 'Linecons', 'js_composer' ) => 'linecons',
          __( 'Stroke', 'js_composer' ) => 'stroke',
        ),
        'param_name' => 'type',
        'description' => __( 'Select icon library.', 'js_composer' ),
        "dependency" => Array('element' => "add_icon", 'value' => array('use_icon'))
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'fontawesome',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'openiconic',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'typicons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'typicons',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'entypo',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'entypo',
        ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'linecons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'linecons',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon stroke', 'js_composer' ),
        'param_name' => 'icon_stroke',
        'value' => 'pe-7s-album', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => true, // default true, display an "EMPTY" icon?
          'type' => 'stroke',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'stroke',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Size', 'js_composer' ),
        'param_name' => 'size',
        'value' => array(
          __( 'Small', 'js_composer' ) => 'sm',
          __( 'Normal', 'js_composer' ) => 'md',
          __( 'Large', 'js_composer' ) => 'lg',
          __( 'Extra Large', 'js_composer' ) => 'xl',
        ),
        'std' => 'md',
        'description' => __( 'Icon size.', 'js_composer' ),
        "dependency" => Array('element' => "add_icon", 'value' => array('use_icon'))
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Icon color","okthemes"),
        "param_name" => "icon_color",
        "dependency" => Array('element' => "add_icon", 'value' => array('use_icon'))
      ),
      array(
         "type" => "checkbox",
         "heading" => __("Box?","okthemes"),
         "value" => array(__("Display the counter in a box","okthemes") => "use_box" ),
         "param_name" => "add_box"
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Box background","okthemes"),
        "param_name" => "box_background",
        "description" => __("Choose your background color.", "okthemes"),
        "dependency" => Array('element' => "add_box", 'value' => array('use_box'))
      ),
      array(
          "type" => "textfield",
          "heading" => __('Box Padding', 'okthemes'),
          "param_name" => "padding",
          "description" => __("You can use px, em, %, etc. or enter just number and it will use pixels. ", "okthemes"),
          "dependency" => Array('element' => "add_box", 'value' => array('use_box'))
      ),
      array(
        "type" => "textfield",
        "heading" => __("Refresh interval", "okthemes"),
        "param_name" => "interval",
        "value" => '100'
      ),
      array(
        "type" => "textfield",
        "heading" => __("Speed", "okthemes"),
        "param_name" => "speed",
        "value" => '1500'
      ),
      array(
         "type" => "dropdown",
         "heading" => __("Align", "okthemes"),
         "param_name" => "align",
         "value" => array(__("Align left", "okthemes") => "left", __("Align right", "okthemes") => "right", __("Align center", "okthemes") => "center"),
         "description" => __("Set the alignment", "okthemes")
      ),

      $add_css_animation,

   )
) );

?>