<?php
class WPBakeryShortCode_gg_featured_icon extends WPBakeryShortCode {

   public function __construct() {  
         add_shortcode('featured_icon', array($this, 'gg_featured_icon'));  
   }

   public function gg_featured_icon( $atts, $content = null ) { 

         $output = $margin_style = $style = $icon_box_style_start = $icon_box_style_end = $icon_size_css = $icon_color_css = $featured_title = $image = $align_center = $icon_box_css = $icon_box_back = $icon_border_style = '';
         $icon = $color = $size = $align = $el_class = $custom_color = $link = $background_style = $background_color =
         $type = $icon_fontawesome = $icon_openiconic = $icon_typicons = $icon_entypoicons = $icon_linecons = '';
         $defaults = array(
             'featured_title'        => '',
             'featured_desc'         => '',
             'link'                  => '',
             'featured_icon'         => '',
             'read_more'             => '',
             'read_more_link'        => '',
             'read_more_title'       =>'',
             'align'                 => 'pull-left',
             'icon_box'              => '',
             'icon_box_color'        => '',
             'el_class'              => '',
             'css_animation'         => '',
             'icon_size'             => 'normal',
             'icon_box_style'        => '',
             'icon_color'            => '',
             'icon_border'           => '',
             'featured_icon_check'   => '',
             'css'                   => '',
         );


         /** @var array $atts - shortcode attributes */
        $atts = vc_shortcode_attribute_parse( $defaults, $atts );
        extract( $atts );

        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );
        $css_class .= $this->getExtraClass( $el_class );
        $css_class .= $this->getCSSAnimation( $css_animation );
        
        // Enqueue needed icon font.
        vc_icon_element_fonts_enqueue( $type );

        $url = vc_build_link( $link );
        $read_more_url = vc_build_link( $read_more_link );
        $has_style = false;

        if($align == "center"){
            $css_class .=' gg-center-align';
        }

        $output .= "\n\t".'<div class="featured-icon-box '.esc_attr( $css_class ).'">';

        if ($featured_icon_check == 'use_featured_icon') {
        $output .= "\n\t".'<div class="vc_icon_element vc_icon_element-outer vc_icon_element-align-'.esc_attr( $align ).'">';
        $output .= "\n\t".'<div class="vc_icon_element-inner vc_icon_element-size-'.esc_attr( $size ).'">';
        $output .= "\n\t".'<span class="vc_icon_element-icon '.esc_attr( ${"icon_" . $type} ).'" '.( $color === 'custom' ? 'style="color:' . esc_attr( $custom_color ) . ' !important"' : '' ).'></span>';
        
          if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
            $output .= "\n\t".'<a class="vc_icon_element-link" href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '"></a>';
          }

        $output .= "\n\t".'</div></div>';

        }

        if ( strlen( $url['url'] ) > 0 ) {
          $output .= "\n\t".'<h3><a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_html($featured_title).'</a></h3>';
        } else {
          $output .= "\n\t".'<h3>'.esc_html($featured_title).'</h3>';
        }

        if ( strlen( $featured_desc ) > 0 ) {
          $output .= "\n\t". '<div class="clearfix"></div><div class="featured-icon-desc">'. wp_kses_post( $featured_desc ).'</div>';
        }

        if ($read_more == 'use_read_more') {
          if ( strlen( $read_more_link ) > 0 && strlen( $read_more_url['url'] ) > 0 ) {
              $output .= "\n\t".'<a class="featured-icon-read-more" href="' . esc_attr( $read_more_url['url'] ) . '" title="' . esc_attr( $read_more_url['title'] ) . '" target="' . ( strlen( $read_more_url['target'] ) > 0 ? esc_attr( $read_more_url['target'] ) : '_self' ) . '">'.$read_more_title.'</a>';
            }
        }
        
        $output .= "\n\t".'</div>';

        return $output;
         
   }
}

$WPBakeryShortCode_gg_featured_icon = new WPBakeryShortCode_gg_featured_icon();  

vc_map( array(
   "name" => __("Featured icon box","okthemes"),
   "description" => __('Display an featured icon with title and description.', 'okthemes'),
   "base" => "featured_icon",
   "class" => "clear_vc_style",
   "icon" => "icon-wpb-gg_vc_featured_icon_box",
   'admin_enqueue_css' => array(get_template_directory_uri().'/lib/visualcomposer/styles.css'),
   'admin_enqueue_js' => array(get_template_directory_uri().'/lib/visualcomposer/custom-vc.js'),
   "category" => __('OKThemes', 'okthemes'),

   "params" => array(
      array(
         "type" => "textfield",
         "heading" => __("Title","okthemes"),
         "param_name" => "featured_title",
         "admin_label" => true,
         "description" => __("Insert title here","okthemes")
      ),
      array(
        "type" => "vc_link",
        "heading" => __("URL (Link)", "okthemes"),
        "param_name" => "link",
        "description" => __("Insert the link.", "okthemes"),
        "dependency" => Array('element' => "featured_title", 'not_empty' => true)
      ),
      array(
         "type" => "textarea",
         "heading" => __("Description","okthemes"),
         "param_name" => "featured_desc",
         "description" => __("Insert short description here","okthemes"),
         "dependency" => Array('element' => "featured_title", 'not_empty' => true)
      ),

      array(
         "type" => "checkbox",
         "heading" => __("Use an Read more link?","okthemes"),
         "value" => array(__("Yes, please","okthemes") => "use_read_more" ),
         "param_name" => "read_more",
         "dependency" => Array('element' => "featured_desc", 'not_empty' => true)
      ),

      array(
        "type" => "vc_link",
        "heading" => __("Read more URL (Link)", "okthemes"),
        "param_name" => "read_more_link",
        "description" => __("Insert the link.", "okthemes"),
        "dependency" => Array('element' => "read_more", 'value' => array('use_read_more'))
      ),

      array(
         "type" => "textfield",
         "heading" => __("Read more title","okthemes"),
         "param_name" => "read_more_title",
         "description" => __("Insert read more title here","okthemes"),
         'std' => 'Read more',
         "dependency" => Array('element' => "read_more", 'value' => array('use_read_more'))
      ),

      array(
         "type" => "checkbox",
         "heading" => __("Use an icon?","okthemes"),
         "value" => array(__("Yes, please","okthemes") => "use_featured_icon" ),
         "param_name" => "featured_icon_check"
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Icon library', 'js_composer' ),
        'value' => array(
          __( 'Font Awesome', 'js_composer' ) => 'fontawesome',
          __( 'Open Iconic', 'js_composer' ) => 'openiconic',
          __( 'Typicons', 'js_composer' ) => 'typicons',
          __( 'Entypo', 'js_composer' ) => 'entypo',
          __( 'Linecons', 'js_composer' ) => 'linecons',
          __( 'Stroke', 'js_composer' ) => 'stroke',
        ),
        'param_name' => 'type',
        'description' => __( 'Select icon library.', 'js_composer' ),
        "dependency" => Array('element' => "featured_icon_check", 'value' => array('use_featured_icon'))
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'fontawesome',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'openiconic',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'typicons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'typicons',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'entypo',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'entypo',
        ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', 'js_composer' ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'linecons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'linecons',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon stroke', 'js_composer' ),
        'param_name' => 'icon_stroke',
        'value' => 'pe-7s-album', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => true, // default true, display an "EMPTY" icon?
          'type' => 'stroke',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => array(
          'element' => 'type',
          'value' => 'stroke',
        ),
        'description' => __( 'Select icon from library.', 'js_composer' ),
      ),
      array(
        'type' => 'colorpicker',
        'heading' => __( 'Custom Icon Color', 'js_composer' ),
        'param_name' => 'custom_color',
        'description' => __( 'Select custom icon color.', 'js_composer' ),
        "dependency" => Array('element' => "featured_icon_check", 'value' => array('use_featured_icon'))
      ),

      array(
        'type' => 'dropdown',
        'heading' => __( 'Size', 'js_composer' ),
        'param_name' => 'size',
        'value' => array(
          __( 'Small', 'js_composer' ) => 'sm',
          __( 'Normal', 'js_composer' ) => 'md',
          __( 'Large', 'js_composer' ) => 'lg',
          __( 'Extra Large', 'js_composer' ) => 'xl',
        ),
        'std' => 'md',
        'description' => __( 'Icon size.', 'js_composer' ),
        "dependency" => Array('element' => "featured_icon_check", 'value' => array('use_featured_icon'))
      ),

      array(
        'type' => 'dropdown',
        'heading' => __( 'Icon alignment', 'js_composer' ),
        'param_name' => 'align',
        'value' => array(
          __( 'Align left', 'js_composer' ) => 'left',
          __( 'Align right', 'js_composer' ) => 'right',
          __( 'Align center', 'js_composer' ) => 'center',
        ),
        'description' => __( 'Select icon alignment.', 'js_composer' ),
        "dependency" => Array('element' => "featured_icon_check", 'value' => array('use_featured_icon'))
      ),
      array(
      'type' => 'textfield',
      'heading' => __( 'Extra class name', 'js_composer' ),
      'param_name' => 'el_class',
      'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer' )
      ),
      $add_css_animation,
      array(
        'type' => 'css_editor',
        'heading' => __( 'Css', 'okthemes' ),
        'param_name' => 'css',
        'group' => __( 'Design options', 'okthemes' ),
        ),

   ),
  //'js_view'  => 'vouxVcFeaturedIconView',
) );

?>